/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.teamtagger.manager;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_310;

public class TeamListManager {
    private static final String FILE_NAME = "team-list.txt";
    private static final Set<String> TEAM_SET = new HashSet<String>();

    private static Path getFilePath() {
        Path gameDir = class_310.method_1551().field_1697.toPath();
        return gameDir.resolve(FILE_NAME);
    }

    public static void load() {
        TEAM_SET.clear();
        Path path = TeamListManager.getFilePath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(path);
                for (String line : lines) {
                    String name = line.trim();
                    if (name.isEmpty()) continue;
                    TEAM_SET.add(name);
                }
            }
            catch (IOException e) {
                System.err.println("[TeamTagger] Failed to load team-list.txt : " + e.getMessage());
            }
        }
    }

    private static void save() {
        Path path = TeamListManager.getFilePath();
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, TEAM_SET, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            System.err.println("[TeamTagger] Failed to save team-list.txt : " + e.getMessage());
        }
    }

    public static boolean addPlayer(String name) {
        boolean added = TEAM_SET.add(name);
        if (added) {
            TeamListManager.save();
        }
        return added;
    }

    public static boolean removePlayer(String name) {
        boolean removed = TEAM_SET.remove(name);
        if (removed) {
            TeamListManager.save();
        }
        return removed;
    }

    public static boolean isTeammate(String name) {
        return TEAM_SET.contains(name);
    }

    public static Set<String> getAll() {
        return Collections.unmodifiableSet(TEAM_SET);
    }
}

