/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.teamtagger.manager;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_310;
import net.minecraft.class_5251;

public class ColorConfigManager {
    private static final String FILE_NAME = "config/team_tagger.json";
    private static class_5251 teamColor = class_5251.method_27717((int)65280);
    private static class_5251 enemyColor = class_5251.method_27717((int)0xFF0000);
    private static boolean teamEnabled = true;
    private static boolean enemyEnabled = true;
    private static final Gson GSON = new Gson();

    private static Path getFilePath() {
        Path gameDir = class_310.method_1551().field_1697.toPath();
        return gameDir.resolve(FILE_NAME);
    }

    public static void load() {
        Path path = ColorConfigManager.getFilePath();
        if (!Files.exists(path, new LinkOption[0])) {
            ColorConfigManager.save();
            return;
        }
        try {
            String json = Files.readString(path);
            JsonObject obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (obj.has("teamColor")) {
                teamColor = class_5251.method_27717((int)((int)Long.parseLong(obj.get("teamColor").getAsString(), 16)));
            }
            if (obj.has("enemyColor")) {
                enemyColor = class_5251.method_27717((int)((int)Long.parseLong(obj.get("enemyColor").getAsString(), 16)));
            }
            if (obj.has("teamEnabled")) {
                teamEnabled = obj.get("teamEnabled").getAsBoolean();
            }
            if (obj.has("enemyEnabled")) {
                enemyEnabled = obj.get("enemyEnabled").getAsBoolean();
            }
        }
        catch (Exception e) {
            System.err.println("[TeamTagger] Failed to load color config : " + e.getMessage());
        }
    }

    private static void save() {
        Path path = ColorConfigManager.getFilePath();
        try {
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("teamColor", String.format("%06X", teamColor.method_27716() & 0xFFFFFF));
            obj.addProperty("enemyColor", String.format("%06X", enemyColor.method_27716() & 0xFFFFFF));
            obj.addProperty("teamEnabled", Boolean.valueOf(teamEnabled));
            obj.addProperty("enemyEnabled", Boolean.valueOf(enemyEnabled));
            Files.writeString(path, (CharSequence)GSON.toJson((JsonElement)obj), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("[TeamTagger] Failed to save color config : " + e.getMessage());
        }
    }

    public static void setTeamColor(class_5251 color) {
        teamColor = color;
        ColorConfigManager.save();
    }

    public static void setEnemyColor(class_5251 color) {
        enemyColor = color;
        ColorConfigManager.save();
    }

    public static class_5251 getTeamColor() {
        return teamColor;
    }

    public static class_5251 getEnemyColor() {
        return enemyColor;
    }

    public static boolean isTeamEnabled() {
        return teamEnabled;
    }

    public static boolean isEnemyEnabled() {
        return enemyEnabled;
    }

    public static void setTeamEnabled(boolean enabled) {
        teamEnabled = enabled;
        ColorConfigManager.save();
    }

    public static void setEnemyEnabled(boolean enabled) {
        enemyEnabled = enabled;
        ColorConfigManager.save();
    }
}

