package com.chyzman.dontdothat.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.fabricmc.fabric.impl.resource.loader.FabricResourcePackProfile;
import net.minecraft.class_2487;
import net.minecraft.class_315;
import net.minecraft.class_3288;
import net.minecraft.class_7172;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@Mixin(class_315.class)
public abstract class GameOptionsMixin {
    @Unique private final Map<String, String> unknown = new HashMap<>();

    @Shadow
    protected abstract void accept(class_315.class_5823 visitor);

    @Inject(
        method = "load",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/option/GameOptions;update(Lnet/minecraft/nbt/NbtCompound;)Lnet/minecraft/nbt/NbtCompound;"
        )
    )
    private void rememberThatCompoundPls(
        CallbackInfo ci,
        @Local() class_2487 compound,
        @Share("data") LocalRef<class_2487> data
    ) {
        data.set(compound);
    }

    @Inject(method = "load", at = @At("TAIL"))
    private void removeTheRealOptionsFromThatCompoundFromEarlier(
        CallbackInfo ci,
        @Share("data") LocalRef<class_2487> data
    ) {
        var keys = data.get().method_10541();
        keys.remove("version");
        this.accept(new class_315.class_5823() {

            @Override
            public <T> void method_42570(String key, class_7172<T> option) {
                keys.remove(key);
            }

            @Override
            public int method_33680(String key, int current) {
                keys.remove(key);
                return current;
            }

            @Override
            public boolean method_33684(String key, boolean current) {
                keys.remove(key);
                return current;
            }

            @Override
            public String method_33683(String key, String current) {
                keys.remove(key);
                return current;
            }

            @Override
            public float method_33679(String key, float current) {
                keys.remove(key);
                return current;
            }

            @Override
            public <T> T method_33681(String key, T current, Function<String, T> decoder, Function<T, String> encoder) {
                keys.remove(key);
                return current;
            }
        });
        keys.forEach(s -> unknown.put(s, data.get().method_10558(s).orElse("")));
    }

    @WrapOperation(
        method = "write",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/option/GameOptions;accept(Lnet/minecraft/client/option/GameOptions$Visitor;)V"
        )
    )
    private void putTheOptionsBackInTheFile(
        class_315 instance,
        class_315.class_5823 visitor,
        Operation<Void> original,
        @Local() PrintWriter writer
    ) {
        original.call(instance, visitor);
        writer.println();
        unknown
            .entrySet()
            .stream()
            .sorted(Map.Entry.comparingByKey())
            .forEach(entry -> writer.println(entry.getKey() + ":" + entry.getValue()));
    }

    @SuppressWarnings("UnstableApiUsage")
    @ModifyExpressionValue(
        method = "refreshResourcePacks",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/resource/ResourcePackProfile;isPinned()Z")
    )
    private boolean excludeFabricInternalResourcePacksFromResourceRefreshCheck(
        boolean original,
        @Local() class_3288 resourcePackProfile
    ) {
        return original || ((FabricResourcePackProfile) resourcePackProfile).fabric_isHidden();
    }
}
