package com.chyzman.dontdothat.mixin;

import com.chyzman.dontdothat.mixin.accessor.KeyBindingAccessor;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_304;
import net.minecraft.class_3675;

@Mixin(class_304.class)
public class KeyBindingMixin {
    @Unique private static final Multimap<class_3675.class_306, class_304> REAL_KEYS_MAP = HashMultimap.create();

    @Shadow private class_3675.class_306 boundKey;

    @Shadow @Final private static Map<String, class_304> KEYS_BY_ID;

    @Inject(method = "onKeyPressed", at = @At(value = "HEAD"), cancellable = true)
    private static void forwardOnKeyPressedToTheMultiMap(
            class_3675.class_306 key,
            CallbackInfo ci
    ) {
        REAL_KEYS_MAP.get(key).forEach(keyBinding -> ((KeyBindingAccessor) keyBinding).dontDoThat$setTimesPressed(((KeyBindingAccessor) keyBinding).dontDoThat$getTimesPressed() + 1));
        ci.cancel();
    }

    @Inject(method = "setKeyPressed", at = @At(value = "HEAD"), cancellable = true)
    private static void forwardSetKeyPressedToTheMultiMap(
            class_3675.class_306 key,
            boolean pressed,
            CallbackInfo ci
    ) {
        REAL_KEYS_MAP.get(key).forEach(keyBinding -> keyBinding.method_23481(pressed));
        ci.cancel();
    }

    @Inject(method = "updateKeysByCode", at = @At(value = "TAIL"))
    private static void forwardUpdateByCodeToMultiMap(CallbackInfo ci) {
        REAL_KEYS_MAP.clear();
        for (class_304 keyBinding : KEYS_BY_ID.values()) {
            REAL_KEYS_MAP.put(((KeyBindingAccessor)keyBinding).dontDoThat$getBoundKey(), keyBinding);
        }
    }

    @Inject(method = "<init>(Ljava/lang/String;Lnet/minecraft/client/util/InputUtil$Type;ILjava/lang/String;)V", at = @At(value = "TAIL"))
    private void forwardPutToMultiMap(
            String translationKey,
            class_3675.class_307 type,
            int code,
            String category,
            CallbackInfo ci
    ) {
        REAL_KEYS_MAP.put(boundKey, (class_304) (Object) this);
    }
}
