package com.chyzman.dontdothat.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.sun.jna.platform.FileUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import net.minecraft.class_32;

@Mixin(class_32.class_5143.class)
public abstract class LevelStorageSessionMixin {
    @Shadow
    public abstract void close() throws IOException;

    @WrapWithCondition(method = "deleteSessionLock", at = @At(value = "INVOKE", target = "Ljava/nio/file/Files;walkFileTree(Ljava/nio/file/Path;Ljava/nio/file/FileVisitor;)Ljava/nio/file/Path;"))
    private boolean rememberThatCompoundPls(
        Path path, FileVisitor<? super Path> visitor
    ) {
        try {
            close();
            FileUtils.getInstance().moveToTrash(path.toFile());
            return false;
        } catch (IOException e) {
            return true;
        }
    }
}
