/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.api.DynamicModification;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=1100)
public abstract class PlayerEntityMixin {
    private static final double VANILLA_KNOCKBACK = 0.4;

    @ModifyExpressionValue(method={"createPlayerAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;createLivingAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;")})
    private static AttributeSupplier.Builder modifyExpressionValueAtCreateLivingAttributes(AttributeSupplier.Builder builder) {
        return builder.m_22266_(AttributesMod.STAMINA).m_22266_(AttributesMod.FORTUNE).m_22266_(AttributesMod.MINING_SPEED).m_22266_(AttributesMod.PICKAXE_SPEED).m_22266_(AttributesMod.AXE_SPEED).m_22266_(AttributesMod.SHOVEL_SPEED).m_22266_(AttributesMod.SPRINTING_SPEED).m_22266_(AttributesMod.KNOCKBACK).m_22266_(AttributesMod.REPAIR_COST).m_22266_(AttributesMod.NATURAL_REGENERATION).m_22266_(AttributesMod.TAMED_DAMAGE).m_22266_(AttributesMod.TAMED_RESISTANCE).m_22266_(AttributesMod.EXPERIENCE);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;onTargetDamaged(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/Entity;)V")})
    private void injectAtAttack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        double knockback = DynamicModification.create().withPositive(AttributesMod.KNOCKBACK, (LivingEntity)player).applyTo(0.4) - 0.4;
        float yaw = player.m_146908_() * ((float)Math.PI / 180);
        float sin = Mth.m_14031_((float)yaw);
        float cos = Mth.m_14089_((float)yaw);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.m_147240_(knockback, (double)sin, (double)(-cos));
        } else {
            target.m_5997_((double)(-sin) * knockback, 0.0, (double)cos * knockback);
        }
    }

    @ModifyReturnValue(method={"getMovementSpeed()F"}, at={@At(value="RETURN")})
    private float injectAtGetMovementSpeed(float speed) {
        Player player = (Player)this;
        if (!player.m_20142_()) {
            return speed;
        }
        return DynamicModification.create().withPositive(AttributesMod.SPRINTING_SPEED, (LivingEntity)player).applyTo(speed);
    }
}

