/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.puffish.attributesmod.api.DynamicEntityAttribute;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.mixin.EntityAttributeInstanceInvoker;
import net.puffish.attributesmod.util.Sign;
import net.puffish.attributesmod.util.Signed;

public class DynamicModificationImpl
implements DynamicModification {
    private final List<Signed<AttributeInstance>> attributes = new ArrayList<Signed<AttributeInstance>>();

    @Override
    public DynamicModification withPositive(Holder<Attribute> attribute, LivingEntity entity) {
        return this.with(Sign.POSITIVE, attribute, entity);
    }

    @Override
    public DynamicModification withNegative(Holder<Attribute> attribute, LivingEntity entity) {
        return this.with(Sign.NEGATIVE, attribute, entity);
    }

    public DynamicModification with(Sign sign, Holder<Attribute> attribute, LivingEntity entity) {
        if (!(attribute.value() instanceof DynamicEntityAttribute)) {
            throw new IllegalArgumentException();
        }
        return this.with(sign.wrap(entity.getAttribute(attribute)));
    }

    public DynamicModification with(Signed<AttributeInstance> signed) {
        this.attributes.add(signed);
        return this;
    }

    @Override
    public double applyTo(double initial) {
        for (Signed<AttributeInstance> signedAttribute : this.attributes) {
            if (signedAttribute.value() == null) continue;
            block13: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.ADD_VALUE)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        initial += modifier.amount();
                        continue block13;
                    }
                    case NEGATIVE: {
                        initial -= modifier.amount();
                        continue block13;
                    }
                }
                throw new IllegalStateException();
            }
        }
        double result = initial;
        for (Signed<AttributeInstance> signedAttribute : this.attributes) {
            if (signedAttribute.value() == null) continue;
            block15: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        result += initial * modifier.amount();
                        continue block15;
                    }
                    case NEGATIVE: {
                        result -= initial * modifier.amount();
                        continue block15;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (Signed<AttributeInstance> signedAttribute : this.attributes) {
            if (signedAttribute.value() == null) continue;
            block17: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        result *= 1.0 + modifier.amount();
                        continue block17;
                    }
                    case NEGATIVE: {
                        result *= 1.0 - modifier.amount();
                        continue block17;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (Signed<AttributeInstance> signedAttribute : this.attributes) {
            if (signedAttribute.value() == null) continue;
            result = ((Attribute)signedAttribute.value().getAttribute().value()).sanitizeValue(result);
        }
        return result;
    }

    @Override
    public float applyTo(float initial) {
        return (float)this.applyTo((double)initial);
    }

    @Override
    public double relativeTo(double initial) {
        return this.applyTo(initial) - initial;
    }

    @Override
    public float relativeTo(float initial) {
        return (float)this.relativeTo((double)initial);
    }
}

