/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.TridentItem;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.api.PuffishAttributes;
import net.puffish.attributesmod.util.DamageKind;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class}, priority=1100)
public abstract class LivingEntityMixin {
    @ModifyExpressionValue(method={"createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier;builder()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;")})
    private static AttributeSupplier.Builder modifyExpressionValueAtBuilder(AttributeSupplier.Builder builder) {
        return builder.add(PuffishAttributes.MAGIC_DAMAGE).add(PuffishAttributes.MELEE_DAMAGE).add(PuffishAttributes.RANGED_DAMAGE).add(PuffishAttributes.SWORD_DAMAGE).add(PuffishAttributes.AXE_DAMAGE).add(PuffishAttributes.TRIDENT_DAMAGE).add(PuffishAttributes.MACE_DAMAGE).add(PuffishAttributes.HEALING).add(PuffishAttributes.JUMP).add(PuffishAttributes.RESISTANCE).add(PuffishAttributes.MAGIC_RESISTANCE).add(PuffishAttributes.MELEE_RESISTANCE).add(PuffishAttributes.RANGED_RESISTANCE).add(PuffishAttributes.ARMOR_SHRED).add(PuffishAttributes.TOUGHNESS_SHRED).add(PuffishAttributes.PROTECTION_SHRED).add(PuffishAttributes.RESISTANCE_SHRED).add(PuffishAttributes.MAGIC_RESISTANCE_SHRED).add(PuffishAttributes.MELEE_RESISTANCE_SHRED).add(PuffishAttributes.RANGED_RESISTANCE_SHRED).add(PuffishAttributes.STEALTH).add(PuffishAttributes.LIFE_STEAL).add(PuffishAttributes.FALL_REDUCTION).add(PuffishAttributes.BOW_PROJECTILE_SPEED).add(PuffishAttributes.CROSSBOW_PROJECTILE_SPEED).add(PuffishAttributes.KNOCKBACK);
    }

    @ModifyReturnValue(method={"getKnockback(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;)F"}, at={@At(value="RETURN")})
    private float modifyReturnValueAtGetAttackKnockbackAgainst(float knockback) {
        return DynamicModification.create().withPositive(PuffishAttributes.KNOCKBACK, (LivingEntity)this).applyTo(knockback);
    }

    @ModifyVariable(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtDamage(float damage, ServerLevel world, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            OwnableEntity tameable;
            LivingEntity owner;
            DamageKind kind;
            LivingEntity attacker = (LivingEntity)entity;
            DynamicModification dm = DynamicModification.create();
            ItemStack itemStack = attacker.getMainHandItem();
            Item item = itemStack.getItem();
            if (itemStack.is(ItemTags.SWORDS)) {
                dm.withPositive(PuffishAttributes.SWORD_DAMAGE, attacker);
            }
            if (itemStack.is(ItemTags.AXES)) {
                dm.withPositive(PuffishAttributes.AXE_DAMAGE, attacker);
            }
            if (item instanceof TridentItem) {
                dm.withPositive(PuffishAttributes.TRIDENT_DAMAGE, attacker);
            }
            if (item instanceof MaceItem) {
                dm.withPositive(PuffishAttributes.MACE_DAMAGE, attacker);
            }
            if ((kind = DamageKind.of(source)).isMagic()) {
                dm.withPositive(PuffishAttributes.MAGIC_DAMAGE, attacker);
            } else {
                if (kind.isProjectile()) {
                    dm.withPositive(PuffishAttributes.RANGED_DAMAGE, attacker);
                }
                if (kind.isMelee()) {
                    dm.withPositive(PuffishAttributes.MELEE_DAMAGE, attacker);
                }
            }
            if (attacker instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)attacker).getOwner()) != null) {
                dm.withPositive(PuffishAttributes.TAMED_DAMAGE, owner);
            }
            damage = dm.applyTo(damage);
        }
        return damage;
    }

    @WrapOperation(method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterAbsorb(Lnet/minecraft/world/entity/LivingEntity;FLnet/minecraft/world/damagesource/DamageSource;FF)F")})
    private float wrapOperationAtApplyArmorToDamage(LivingEntity entity, float damage, DamageSource source, float armor, float toughness, Operation<Float> operation) {
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            armor = Math.max(0.0f, DynamicModification.create().withNegative(PuffishAttributes.ARMOR_SHRED, attacker).applyTo(armor));
            toughness = Math.max(0.0f, DynamicModification.create().withNegative(PuffishAttributes.TOUGHNESS_SHRED, attacker).applyTo(toughness));
        }
        return ((Float)operation.call(new Object[]{entity, Float.valueOf(damage), source, Float.valueOf(armor), Float.valueOf(toughness)})).floatValue();
    }

    @WrapOperation(method={"getDamageAfterMagicAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterMagicAbsorb(FF)F")})
    private float wrapOperationAtModifyAppliedDamage(float damageDealt, float protection, Operation<Float> original, @Local(argsOnly=true) DamageSource source) {
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            protection = Math.max(0.0f, DynamicModification.create().withNegative(PuffishAttributes.PROTECTION_SHRED, attacker).applyTo(protection));
        }
        return ((Float)original.call(new Object[]{Float.valueOf(damageDealt), Float.valueOf(protection)})).floatValue();
    }

    @ModifyVariable(method={"heal(F)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        return DynamicModification.create().withPositive(PuffishAttributes.HEALING, (LivingEntity)this).applyTo(amount);
    }

    @ModifyReturnValue(method={"getJumpPower()F"}, at={@At(value="RETURN")})
    private float injectAtGetJumpVelocity(float jump) {
        return DynamicModification.create().withPositive(PuffishAttributes.JUMP, (LivingEntity)this).applyTo(jump);
    }

    @ModifyVariable(method={"calculateFallDamage(DF)I"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private double modifyVariableAtComputeFallDamage(double fallDistance) {
        return DynamicModification.create().withNegative(PuffishAttributes.FALL_REDUCTION, (LivingEntity)this).applyTo(fallDistance) - (double)(DynamicModification.create().withPositive(PuffishAttributes.JUMP, (LivingEntity)this).relativeTo(1.0f) * 10.0f);
    }

    @WrapMethod(method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"})
    private float wrapMethodApplyArmorToDamage(DamageSource source, float amount, Operation<Float> original) {
        OwnableEntity tameable;
        LivingEntity owner;
        Float damage = (Float)original.call(new Object[]{source, Float.valueOf(amount)});
        if (source.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return damage.floatValue();
        }
        if (damage.floatValue() > 1.1342745E38f) {
            return damage.floatValue();
        }
        LivingEntity entity = (LivingEntity)this;
        DamageKind kind = DamageKind.of(source);
        DynamicModification dmResistance = DynamicModification.create();
        dmResistance.withNegative(PuffishAttributes.RESISTANCE, entity);
        if (kind.isMagic()) {
            dmResistance.withNegative(PuffishAttributes.MAGIC_RESISTANCE, entity);
        } else {
            if (kind.isProjectile()) {
                dmResistance.withNegative(PuffishAttributes.RANGED_RESISTANCE, entity);
            }
            if (kind.isMelee()) {
                dmResistance.withNegative(PuffishAttributes.MELEE_RESISTANCE, entity);
            }
        }
        if (entity instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)entity).getOwner()) != null) {
            dmResistance.withNegative(PuffishAttributes.TAMED_RESISTANCE, owner);
        }
        float resistance = damage.floatValue() - dmResistance.applyTo(damage.floatValue());
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            DynamicModification dmShred = DynamicModification.create();
            dmShred.withNegative(PuffishAttributes.RESISTANCE_SHRED, attacker);
            if (kind.isMagic()) {
                dmShred.withNegative(PuffishAttributes.MAGIC_RESISTANCE_SHRED, attacker);
            } else {
                if (kind.isProjectile()) {
                    dmShred.withNegative(PuffishAttributes.RANGED_RESISTANCE_SHRED, attacker);
                }
                if (kind.isMelee()) {
                    dmShred.withNegative(PuffishAttributes.MELEE_RESISTANCE_SHRED, attacker);
                }
            }
            resistance = Math.max(0.0f, dmShred.applyTo(resistance));
        }
        return Math.max(0.0f, damage.floatValue() - resistance);
    }
}

