/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.main;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.util.Registrar;

@Mod(value="puffish_attributes")
public class ForgeMain {
    private final List<RegistryAlias<?>> registryAliases = new ArrayList();

    public ForgeMain() {
        AttributesMod.setup(new RegistrarImpl());
        MinecraftForge.EVENT_BUS.addListener(this::onIdMapping);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEntityAttributeCreation);
    }

    private void onIdMapping(RegistryEvent.IdMappingEvent event) {
        this.registryAliases.forEach(RegistryAlias::apply);
    }

    private void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        this.registryAliases.forEach(RegistryAlias::apply);
    }

    private class RegistrarImpl
    implements Registrar {
        private RegistrarImpl() {
        }

        @Override
        public <V, T extends V> void register(Registry<V> registry, ResourceLocation id, T entry) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.m_123023_(), (String)id.m_135827_());
            deferredRegister.register(id.m_135815_(), () -> entry);
            deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        }

        @Override
        public <V> void registerAlias(Registry<V> registry, ResourceLocation aliasId, ResourceLocation id) {
            ForgeMain.this.registryAliases.add(new RegistryAlias<V>(registry, aliasId, id));
        }
    }

    private record RegistryAlias<V>(Registry<V> registry, ResourceLocation aliasId, ResourceLocation id) {
        public void apply() {
            try {
                Class<?> namespacedWrapperClass = Class.forName("net.minecraftforge.registries.NamespacedWrapper");
                Class<?> namespacedHolderHelperClass = Class.forName("net.minecraftforge.registries.NamespacedHolderHelper");
                Class<ForgeRegistry> forgeRegistryClass = ForgeRegistry.class;
                Field delegateField = namespacedWrapperClass.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Field holdersField = namespacedWrapperClass.getDeclaredField("holders");
                holdersField.setAccessible(true);
                Field holdersByNameField = namespacedHolderHelperClass.getDeclaredField("holdersByName");
                holdersByNameField.setAccessible(true);
                Method addAliasMethod = forgeRegistryClass.getDeclaredMethod("addAlias", ResourceLocation.class, ResourceLocation.class);
                addAliasMethod.setAccessible(true);
                ForgeRegistry delegate = (ForgeRegistry)delegateField.get(this.registry);
                boolean locked = delegate.isLocked();
                if (locked) {
                    delegate.unfreeze();
                }
                addAliasMethod.invoke((Object)delegate, this.aliasId, this.id);
                if (locked) {
                    delegate.freeze();
                }
                Object holders = holdersField.get(this.registry);
                Map holdersByName = (Map)holdersByNameField.get(holders);
                holdersByName.put(this.aliasId, (Holder.Reference)holdersByName.get(this.id));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

