/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.main;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.mixin.SimpleRegistryAccessor;
import net.puffish.attributesmod.util.Registrar;

@Mod(value="puffish_attributes")
public class NeoForgeMain {
    private final List<RegistryAlias<?>> registryAliases = new ArrayList();

    public NeoForgeMain(IEventBus modEventBus) {
        AttributesMod.setup(new RegistrarImpl(modEventBus));
        modEventBus.addListener(EventPriority.LOW, this::onRegister);
    }

    private void onRegister(RegisterEvent event) {
        this.registryAliases.forEach(registryAlias -> registryAlias.apply(event.getRegistry()));
    }

    private class RegistrarImpl
    implements Registrar {
        private final IEventBus modEventBus;

        public RegistrarImpl(IEventBus modEventBus) {
            this.modEventBus = modEventBus;
        }

        @Override
        public <V, T extends V> void register(Registry<V> registry, ResourceLocation id, T entry) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.key(), (String)id.getNamespace());
            deferredRegister.register(id.getPath(), () -> entry);
            deferredRegister.register(this.modEventBus);
        }

        @Override
        public <V> void registerAlias(Registry<V> registry, ResourceLocation aliasId, ResourceLocation id) {
            NeoForgeMain.this.registryAliases.add(new RegistryAlias<V>(registry, aliasId, id));
        }
    }

    private record RegistryAlias<V>(Registry<V> registry, ResourceLocation aliasId, ResourceLocation id) {
        public void apply(Registry<?> registry) {
            if (registry == this.registry) {
                SimpleRegistryAccessor accessor = (SimpleRegistryAccessor)this.registry;
                Holder.Reference entry = accessor.getIdToEntry().get(this.id);
                accessor.getIdToEntry().put(this.aliasId, entry);
                accessor.getKeyToEntry().put(ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)this.aliasId), entry);
            }
        }
    }
}

