/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.main;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.mixin.SimpleRegistryAccessor;

@Mod(value="puffish_attributes")
public class NeoForgeMain {
    public static final List<DeferredRegister<?>> DEFERRED_REGISTERS = new ArrayList();
    public static final List<RegistryAlias<?>> REGISTRY_ALIASES = new ArrayList();

    public NeoForgeMain(IEventBus modEventBus) {
        AttributesMod.setup();
        modEventBus.addListener(EventPriority.LOW, this::onRegister);
        for (DeferredRegister<?> deferredRegister : DEFERRED_REGISTERS) {
            deferredRegister.register(modEventBus);
        }
    }

    private void onRegister(RegisterEvent event) {
        REGISTRY_ALIASES.forEach(registryAlias -> registryAlias.apply(event.getRegistry()));
    }

    public record RegistryAlias<V>(Registry<V> registry, ResourceLocation aliasId, ResourceLocation id) {
        public void apply(Registry<?> registry) {
            if (registry == this.registry) {
                SimpleRegistryAccessor accessor = (SimpleRegistryAccessor)this.registry;
                Holder.Reference entry = accessor.getIdToEntry().get(this.id);
                accessor.getIdToEntry().put(this.aliasId, entry);
                accessor.getKeyToEntry().put(ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)this.aliasId), entry);
            }
        }
    }
}

