/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.util.DamageKind;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class}, priority=1100)
public abstract class LivingEntityMixin {
    @ModifyExpressionValue(method={"createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier;builder()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;")})
    private static AttributeSupplier.Builder modifyExpressionValueAtBuilder(AttributeSupplier.Builder builder) {
        return builder.add(AttributesMod.MAGIC_DAMAGE).add(AttributesMod.MELEE_DAMAGE).add(AttributesMod.RANGED_DAMAGE).add(AttributesMod.HEALING).add(AttributesMod.JUMP).add(AttributesMod.RESISTANCE).add(AttributesMod.MAGIC_RESISTANCE).add(AttributesMod.MELEE_RESISTANCE).add(AttributesMod.RANGED_RESISTANCE).add(AttributesMod.ARMOR_SHRED).add(AttributesMod.TOUGHNESS_SHRED).add(AttributesMod.PROTECTION_SHRED).add(AttributesMod.RESISTANCE_SHRED).add(AttributesMod.MAGIC_RESISTANCE_SHRED).add(AttributesMod.MELEE_RESISTANCE_SHRED).add(AttributesMod.RANGED_RESISTANCE_SHRED).add(AttributesMod.STEALTH).add(AttributesMod.LIFE_STEAL).add(AttributesMod.FALL_REDUCTION).add(AttributesMod.BOW_PROJECTILE_SPEED).add(AttributesMod.CROSSBOW_PROJECTILE_SPEED);
    }

    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtDamage(float damage, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            OwnableEntity tameable;
            LivingEntity owner;
            LivingEntity attacker = (LivingEntity)entity;
            DynamicModification dm = DynamicModification.create();
            DamageKind kind = DamageKind.of(source);
            if (kind.isMagic()) {
                dm.withPositive(AttributesMod.MAGIC_DAMAGE, attacker);
            } else {
                if (kind.isProjectile()) {
                    dm.withPositive(AttributesMod.RANGED_DAMAGE, attacker);
                }
                if (kind.isMelee()) {
                    dm.withPositive(AttributesMod.MELEE_DAMAGE, attacker);
                }
            }
            if (attacker instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)attacker).getOwner()) != null) {
                dm.withPositive(AttributesMod.TAMED_DAMAGE, owner);
            }
            damage = dm.applyTo(damage);
        }
        return damage;
    }

    @WrapOperation(method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterAbsorb(Lnet/minecraft/world/entity/LivingEntity;FLnet/minecraft/world/damagesource/DamageSource;FF)F")})
    private float wrapOperationAtApplyArmorToDamage(LivingEntity entity, float damage, DamageSource source, float armor, float toughness, Operation<Float> operation) {
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            armor = Math.max(0.0f, DynamicModification.create().withNegative(AttributesMod.ARMOR_SHRED, attacker).applyTo(armor));
            toughness = Math.max(0.0f, DynamicModification.create().withNegative(AttributesMod.TOUGHNESS_SHRED, attacker).applyTo(toughness));
        }
        return ((Float)operation.call(new Object[]{entity, Float.valueOf(damage), source, Float.valueOf(armor), Float.valueOf(toughness)})).floatValue();
    }

    @WrapOperation(method={"getDamageAfterMagicAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterMagicAbsorb(FF)F")})
    private float wrapOperationAtModifyAppliedDamage(float damageDealt, float protection, Operation<Float> original, @Local(argsOnly=true) DamageSource source) {
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            protection = Math.max(0.0f, DynamicModification.create().withNegative(AttributesMod.PROTECTION_SHRED, attacker).applyTo(protection));
        }
        return ((Float)original.call(new Object[]{Float.valueOf(damageDealt), Float.valueOf(protection)})).floatValue();
    }

    @ModifyVariable(method={"heal(F)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        return DynamicModification.create().withPositive(AttributesMod.HEALING, (LivingEntity)this).applyTo(amount);
    }

    @ModifyReturnValue(method={"getJumpPower()F"}, at={@At(value="RETURN")})
    private float injectAtGetJumpVelocity(float jump) {
        return DynamicModification.create().withPositive(AttributesMod.JUMP, (LivingEntity)this).applyTo(jump);
    }

    @ModifyVariable(method={"calculateFallDamage(FF)I"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtComputeFallDamage(float fallDistance) {
        return DynamicModification.create().withNegative(AttributesMod.FALL_REDUCTION, (LivingEntity)this).applyTo(fallDistance) - DynamicModification.create().withPositive(AttributesMod.JUMP, (LivingEntity)this).relativeTo(1.0f) * 10.0f;
    }

    @WrapMethod(method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"})
    private float wrapMethodApplyArmorToDamage(DamageSource source, float amount, Operation<Float> original) {
        OwnableEntity tameable;
        LivingEntity owner;
        Float damage = (Float)original.call(new Object[]{source, Float.valueOf(amount)});
        if (source.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return damage.floatValue();
        }
        if (damage.floatValue() > 1.1342745E38f) {
            return damage.floatValue();
        }
        LivingEntity entity = (LivingEntity)this;
        DamageKind kind = DamageKind.of(source);
        DynamicModification dmResistance = DynamicModification.create();
        dmResistance.withNegative(AttributesMod.RESISTANCE, entity);
        if (kind.isMagic()) {
            dmResistance.withNegative(AttributesMod.MAGIC_RESISTANCE, entity);
        } else {
            if (kind.isProjectile()) {
                dmResistance.withNegative(AttributesMod.RANGED_RESISTANCE, entity);
            }
            if (kind.isMelee()) {
                dmResistance.withNegative(AttributesMod.MELEE_RESISTANCE, entity);
            }
        }
        if (entity instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)entity).getOwner()) != null) {
            dmResistance.withNegative(AttributesMod.TAMED_RESISTANCE, owner);
        }
        float resistance = damage.floatValue() - dmResistance.applyTo(damage.floatValue());
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            DynamicModification dmShred = DynamicModification.create();
            dmShred.withNegative(AttributesMod.RESISTANCE_SHRED, attacker);
            if (kind.isMagic()) {
                dmShred.withNegative(AttributesMod.MAGIC_RESISTANCE_SHRED, attacker);
            } else {
                if (kind.isProjectile()) {
                    dmShred.withNegative(AttributesMod.RANGED_RESISTANCE_SHRED, attacker);
                }
                if (kind.isMelee()) {
                    dmShred.withNegative(AttributesMod.MELEE_RESISTANCE_SHRED, attacker);
                }
            }
            resistance = Math.max(0.0f, dmShred.applyTo(resistance));
        }
        return Math.max(0.0f, damage.floatValue() - resistance);
    }
}

