/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import java.util.UUID;
import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateCommissionCommand
implements CommandExecutor {
    private final EasyBuildPlugin plugin;

    public CreateCommissionCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block14: {
            try {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
                    return true;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("easybuild.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6b64\u547d\u4ee4\uff01");
                    return true;
                }
                if (args.length < 6) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /wtcj <x1,y1,z1> <x2,y2,z2> <\u59d4\u6258\u540d\u79f0> <\u59d4\u6258\u5de5\u671f> <\u59d4\u6258\u62a5\u916c> <\u59d4\u6258\u63cf\u8ff0>");
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u793a\u4f8b: /wtcj 100,64,200 150,100,250 \u5c0f\u5e97\u5efa\u8bbe 7 1000 \u8bf7\u5efa\u9020\u4e00\u4e2a\u5c0f\u5546\u5e97");
                    return true;
                }
                String[] pos1Parts = args[0].split(",");
                if (pos1Parts.length != 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f4d\u7f6e1\u683c\u5f0f\u9519\u8bef\uff01\u5e94\u4e3a: x,y,z");
                    return true;
                }
                Location pos1 = new Location(player.getWorld(), Double.parseDouble(pos1Parts[0]), Double.parseDouble(pos1Parts[1]), Double.parseDouble(pos1Parts[2]));
                String[] pos2Parts = args[1].split(",");
                if (pos2Parts.length != 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f4d\u7f6e2\u683c\u5f0f\u9519\u8bef\uff01\u5e94\u4e3a: x,y,z");
                    return true;
                }
                Location pos2 = new Location(player.getWorld(), Double.parseDouble(pos2Parts[0]), Double.parseDouble(pos2Parts[1]), Double.parseDouble(pos2Parts[2]));
                String name = args[2];
                int duration = Integer.parseInt(args[3]);
                double reward = Double.parseDouble(args[4]);
                StringBuilder descriptionBuilder = new StringBuilder();
                for (int i = 5; i < args.length; ++i) {
                    if (i > 5) {
                        descriptionBuilder.append(" ");
                    }
                    descriptionBuilder.append(args[i]);
                }
                String description = descriptionBuilder.toString();
                if (duration <= 0) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u59d4\u6258\u5de5\u671f\u5fc5\u987b\u5927\u4e8e0\u5929\uff01");
                    return true;
                }
                if (reward <= 0.0) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u59d4\u6258\u62a5\u916c\u5fc5\u987b\u5927\u4e8e0\uff01");
                    return true;
                }
                for (Commission existingCommission : this.plugin.getDataManager().getAllCommissions()) {
                    if (!existingCommission.getName().equals(name)) continue;
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u5df2\u5b58\u5728\u540d\u4e3a \"" + name + "\" \u7684\u59d4\u6258\uff01");
                    return true;
                }
                Commission commission = new Commission(UUID.randomUUID().toString(), name, description, pos1, pos2, duration, reward);
                this.plugin.getDataManager().addCommission(commission);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u59d4\u6258 \"" + name + "\" \u521b\u5efa\u6210\u529f\uff01");
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u4f4d\u7f6e: " + this.formatLocation(pos1) + " \u5230 " + this.formatLocation(pos2));
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5de5\u671f: " + duration + " \u5929");
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u62a5\u916c: " + this.plugin.getEconomyManager().format(reward));
            }
            catch (NumberFormatException e) {
                if (sender instanceof Player) {
                    ((Player)sender).sendMessage(String.valueOf(ChatColor.RED) + "\u6570\u5b57\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u5750\u6807\u3001\u5de5\u671f\u548c\u62a5\u916c\u662f\u5426\u4e3a\u6709\u6548\u6570\u5b57\u3002");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("\u521b\u5efa\u59d4\u6258\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                e.printStackTrace();
                if (!(sender instanceof Player)) break block14;
                ((Player)sender).sendMessage(String.valueOf(ChatColor.RED) + "\u521b\u5efa\u59d4\u6258\u65f6\u53d1\u751f\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        return true;
    }

    private boolean isRegionOverlapping(Location pos1, Location pos2) {
        double minX1 = Math.min(pos1.getX(), pos2.getX());
        double maxX1 = Math.max(pos1.getX(), pos2.getX());
        double minZ1 = Math.min(pos1.getZ(), pos2.getZ());
        double maxZ1 = Math.max(pos1.getZ(), pos2.getZ());
        for (Commission existing : this.plugin.getDataManager().getAllCommissions()) {
            if (!existing.getPos1().getWorld().equals((Object)pos1.getWorld())) continue;
            double minX2 = Math.min(existing.getPos1().getX(), existing.getPos2().getX());
            double maxX2 = Math.max(existing.getPos1().getX(), existing.getPos2().getX());
            double minZ2 = Math.min(existing.getPos1().getZ(), existing.getPos2().getZ());
            double maxZ2 = Math.max(existing.getPos1().getZ(), existing.getPos2().getZ());
            if (maxX1 < minX2 || minX1 > maxX2 || maxZ1 < minZ2 || minZ1 > maxZ2) continue;
            return true;
        }
        return false;
    }

    private String formatLocation(Location loc) {
        return "(" + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ() + ")";
    }
}

