/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListCommissionsCommand
implements CommandExecutor {
    private final EasyBuildPlugin plugin;

    public ListCommissionsCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        List commissions = this.plugin.getDataManager().getAllCommissions().stream().filter(c -> c.getStatus() != Commission.Status.COMPLETED || c.getStatus() == Commission.Status.COMPLETED && c.getContractor() != null && c.getContractor().equals(player.getName())).collect(Collectors.toList());
        if (commissions.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u59d4\u6258\u3002");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "========== \u59d4\u6258\u5217\u8868 ==========");
        int index = 1;
        for (Commission commission : commissions) {
            ChatColor statusColor = this.getStatusColor(commission.getStatus());
            String statusText = commission.getStatus().getDisplayName();
            TextComponent nameComponent = new TextComponent(index + ". " + commission.getName());
            nameComponent.setColor(statusColor.asBungee());
            ComponentBuilder hoverBuilder = new ComponentBuilder("\u59d4\u6258\u4fe1\u606f:").color(net.md_5.bungee.api.ChatColor.YELLOW).append("\n\u540d\u79f0: " + commission.getName()).color(net.md_5.bungee.api.ChatColor.WHITE).append("\n\u72b6\u6001: " + statusText).color(statusColor.asBungee()).append("\n\u62a5\u916c: " + this.plugin.getEconomyManager().format(commission.getReward())).color(net.md_5.bungee.api.ChatColor.GREEN).append("\n\u5de5\u671f: " + commission.getDuration() + " \u5929").color(net.md_5.bungee.api.ChatColor.AQUA).append("\n\u63cf\u8ff0: " + commission.getDescription()).color(net.md_5.bungee.api.ChatColor.GRAY);
            if (commission.getContractor() != null) {
                String contractorName = Bukkit.getOfflinePlayer((String)commission.getContractor()).getName();
                hoverBuilder.append("\n\u627f\u5305\u4eba: " + contractorName).color(net.md_5.bungee.api.ChatColor.LIGHT_PURPLE);
                if (!commission.getPartners().isEmpty()) {
                    StringBuilder partners = new StringBuilder();
                    for (int i = 0; i < commission.getPartners().size(); ++i) {
                        if (i > 0) {
                            partners.append(", ");
                        }
                        partners.append(Bukkit.getOfflinePlayer((String)commission.getPartners().get(i)).getName());
                    }
                    hoverBuilder.append("\n\u5408\u4f5c\u4f19\u4f34: " + partners.toString()).color(net.md_5.bungee.api.ChatColor.LIGHT_PURPLE);
                }
            }
            hoverBuilder.append("\n\n\u70b9\u51fb\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f").color(net.md_5.bungee.api.ChatColor.YELLOW);
            nameComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverBuilder.create()));
            nameComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wtinfo " + commission.getId()));
            player.spigot().sendMessage((BaseComponent)nameComponent);
            ++index;
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "============================");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u59d4\u6258\u540d\u79f0\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f");
        return true;
    }

    private ChatColor getStatusColor(Commission.Status status) {
        switch (status) {
            case UNCONTRACTED: {
                return ChatColor.BLUE;
            }
            case IN_PROGRESS: {
                return ChatColor.YELLOW;
            }
            case COMPLETED: {
                return ChatColor.GREEN;
            }
        }
        return ChatColor.WHITE;
    }
}

