/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import java.util.ArrayList;
import java.util.List;
import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import ocean.easybuild.utils.InteractiveSession;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PermissionCommand
implements CommandExecutor,
Listener {
    private final EasyBuildPlugin plugin;

    public PermissionCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        Commission commission = this.plugin.getDataManager().getCommissionAtLocation(player.getLocation());
        if (commission == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u59d4\u6258\u533a\u57df\u5185\uff01");
            return true;
        }
        if (commission.getStatus() == Commission.Status.UNCONTRACTED || commission.getStatus() == Commission.Status.COMPLETED) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u672a\u627f\u5305\u6216\u5df2\u5b8c\u5de5\u72b6\u6001\u4e0d\u53d7\u9650\u5236\uff0c\u65e0\u9700\u8bbe\u7f6e\u6743\u9650\u3002");
            return true;
        }
        if (!commission.isBuilder(player.getName())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u53ea\u6709\u5efa\u8bbe\u8005\u53ef\u7ba1\u7406\u6b64\u59d4\u6258\u7684\u6743\u9650\uff01");
            return true;
        }
        this.openMainMenu(player, commission);
        return true;
    }

    private void openMainMenu(Player player, Commission commission) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)("\u6743\u9650\u7ba1\u7406 - " + commission.getName()));
        inv.setItem(11, this.createMenuItem(Material.OAK_DOOR, String.valueOf(ChatColor.AQUA) + "\u8fdb\u5165\u59d4\u6258\u5730", this.getModeLore(commission.getEntryPermissionMode())));
        inv.setItem(15, this.createMenuItem(Material.IRON_PICKAXE, String.valueOf(ChatColor.GREEN) + "\u5728\u59d4\u6258\u5730\u653e\u7f6e/\u6d88\u9664", this.getModeLore(commission.getBuildPermissionMode())));
        player.openInventory(inv);
        InteractiveSession.startSession(player, InteractiveSession.SessionType.SET_STATUS, input -> {}, commission.getId());
    }

    private ItemStack createMenuItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private List<String> getModeLore(Commission.PermissionMode mode) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.YELLOW) + "\u5f53\u524d: " + String.valueOf(ChatColor.WHITE) + mode.name());
        lore.add(String.valueOf(ChatColor.GRAY) + "\u70b9\u51fb\u8fdb\u5165\u4e8c\u7ea7\u83dc\u5355\u8fdb\u884c\u8bbe\u7f6e");
        return lore;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Commission commission;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.startsWith("\u6743\u9650\u7ba1\u7406 - ")) {
            return;
        }
        event.setCancelled(true);
        InteractiveSession.SessionData session = InteractiveSession.getSession(player.getName());
        String commissionId = session != null ? session.getCommissionId() : null;
        Commission commission2 = commission = commissionId != null ? this.plugin.getDataManager().getCommission(commissionId) : null;
        if (commission == null) {
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u5bf9\u5e94\u59d4\u6258\u3002");
            return;
        }
        int slot = event.getRawSlot();
        if (slot == 11) {
            this.openSubMenu(player, commission, true);
        } else if (slot == 15) {
            this.openSubMenu(player, commission, false);
        }
    }

    private void openSubMenu(Player player, Commission commission, boolean entry) {
        String name = entry ? "\u8fdb\u5165\u59d4\u6258\u5730\u6743\u9650" : "\u5efa\u9020/\u7834\u574f\u6743\u9650";
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)(name + " - " + commission.getName()));
        inv.setItem(10, this.createMenuItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "1. \u5173\u95ed\uff08\u4ec5\u5efa\u8bbe\u8005\uff09", null));
        inv.setItem(13, this.createMenuItem(Material.LIME_DYE, String.valueOf(ChatColor.GREEN) + "2. \u5f00\u542f\uff08\u6240\u6709\u4eba\uff09", null));
        inv.setItem(16, this.createMenuItem(Material.NAME_TAG, String.valueOf(ChatColor.AQUA) + "3. \u81ea\u5b9a\u4e49\uff08\u8f93\u5165\u73a9\u5bb6\u540d\uff09", null));
        player.openInventory(inv);
        InteractiveSession.startSession(player, InteractiveSession.SessionType.SET_STATUS, input -> {}, commission.getId());
    }

    @EventHandler
    public void onSubMenuClick(InventoryClickEvent event) {
        Commission commission;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        boolean isEntry = title.startsWith("\u8fdb\u5165\u59d4\u6258\u5730\u6743\u9650 - ");
        if (!isEntry && !title.startsWith("\u5efa\u9020/\u7834\u574f\u6743\u9650 - ")) {
            return;
        }
        event.setCancelled(true);
        InteractiveSession.SessionData session = InteractiveSession.getSession(player.getName());
        String commissionId = session != null ? session.getCommissionId() : null;
        Commission commission2 = commission = commissionId != null ? this.plugin.getDataManager().getCommission(commissionId) : null;
        if (commission == null) {
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u5bf9\u5e94\u59d4\u6258\u3002");
            return;
        }
        int slot = event.getRawSlot();
        if (slot == 10) {
            if (isEntry) {
                commission.setEntryPermissionMode(Commission.PermissionMode.CLOSED);
            } else {
                commission.setBuildPermissionMode(Commission.PermissionMode.CLOSED);
            }
            this.plugin.getDataManager().updateCommission(commission);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u5df2\u8bbe\u7f6e\u4e3a\u5173\u95ed\uff08\u4ec5\u5efa\u8bbe\u8005\uff09");
        } else if (slot == 13) {
            if (isEntry) {
                commission.setEntryPermissionMode(Commission.PermissionMode.OPEN);
            } else {
                commission.setBuildPermissionMode(Commission.PermissionMode.OPEN);
            }
            this.plugin.getDataManager().updateCommission(commission);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u5df2\u8bbe\u7f6e\u4e3a\u5f00\u542f\uff08\u6240\u6709\u4eba\uff09");
        } else if (slot == 16) {
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u8bf7\u8f93\u5165\u73a9\u5bb6\u540d\uff0c\u652f\u6301\u591a\u4e2a\uff0c\u7528\u7a7a\u683c\u5206\u9694\uff1a");
            InteractiveSession.startSession(player, InteractiveSession.SessionType.MODIFY_REWARD, input -> {
                String[] names = input.split("\\s+");
                ArrayList<String> list = new ArrayList<String>();
                for (String n : names) {
                    if (n.isEmpty()) continue;
                    list.add(n);
                }
                if (isEntry) {
                    commission.setEntryPermissionMode(Commission.PermissionMode.CUSTOM);
                    commission.setEntryWhitelist(list);
                } else {
                    commission.setBuildPermissionMode(Commission.PermissionMode.CUSTOM);
                    commission.setBuildWhitelist(list);
                }
                this.plugin.getDataManager().updateCommission(commission);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u5df2\u66f4\u65b0\u81ea\u5b9a\u4e49\u540d\u5355\uff1a" + String.join((CharSequence)", ", list));
            }, commission.getId());
        }
    }
}

