/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import ocean.easybuild.utils.InteractiveSession;
import ocean.easybuild.utils.LangManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReviewCommissionCommand
implements CommandExecutor {
    private final EasyBuildPlugin plugin;

    public ReviewCommissionCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block10: {
            try {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7c" + LangManager.tr("error.player_only", new Object[0]));
                    return true;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("easybuild.admin")) {
                    player.sendMessage("\u00a7c" + LangManager.tr("error.no_permission", new Object[0]));
                    return true;
                }
                if (args.length != 1) {
                    player.sendMessage("\u00a7c" + LangManager.tr("usage.yswt", new Object[0]));
                    return true;
                }
                String decision = args[0].toLowerCase();
                if (!decision.equals("y") && !decision.equals("n")) {
                    player.sendMessage("\u00a7c" + LangManager.tr("error.invalid_input_yn", new Object[0]));
                    return true;
                }
                Commission commission = this.plugin.getDataManager().getCommissionAtLocation(player.getLocation());
                if (commission == null) {
                    player.sendMessage("\u00a7c" + LangManager.tr("error.not_in_commission_region", new Object[0]));
                    return true;
                }
                if (commission.getStatus() != Commission.Status.COMPLETED) {
                    player.sendMessage("\u00a7c" + LangManager.tr("error.not_review_status", new Object[0]));
                    return true;
                }
                if (decision.equals("y")) {
                    this.handleApproval(player, commission);
                } else {
                    this.handleRejection(player, commission);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("\u6267\u884c\u5ba1\u6838\u547d\u4ee4\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                e.printStackTrace();
                if (!(sender instanceof Player)) break block10;
                ((Player)sender).sendMessage("\u00a7c\u547d\u4ee4\u6267\u884c\u65f6\u53d1\u751f\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        return true;
    }

    private void handleApproval(Player player, Commission commission) {
        TextComponent confirmButton = new TextComponent("\u00a7a" + LangManager.tr("review.approved.button.confirm", new Object[0]));
        confirmButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/confirm_review " + commission.getId()));
        confirmButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LangManager.tr("review.approved.button.confirm.hover", new Object[0])).create()));
        TextComponent modifyButton = new TextComponent("\u00a7e" + LangManager.tr("review.approved.button.modify", new Object[0]));
        modifyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/modify_reward " + commission.getId()));
        modifyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LangManager.tr("review.approved.button.modify.hover", new Object[0])).create()));
        TextComponent setMsgButton = new TextComponent("\u00a7b" + LangManager.tr("review.approved.button.setmsg", new Object[0]));
        setMsgButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/set_approval_message " + commission.getId()));
        setMsgButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LangManager.tr("review.approved.button.setmsg.hover", new Object[0])).create()));
        player.sendMessage("\u00a7a" + LangManager.tr("review.approved.title", new Object[0]));
        player.spigot().sendMessage(new BaseComponent[]{confirmButton, new TextComponent(" "), modifyButton, new TextComponent(" "), setMsgButton});
    }

    private void handleRejection(Player player, Commission commission) {
        TextComponent terminateButton = new TextComponent("\u00a7c" + LangManager.tr("review.rejected.button.terminate", new Object[0]));
        terminateButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/terminate_commission " + commission.getId()));
        terminateButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LangManager.tr("review.rejected.button.terminate.hover", new Object[0])).create()));
        TextComponent extendButton = new TextComponent("\u00a76" + LangManager.tr("review.rejected.button.extend", new Object[0]));
        extendButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/extend_commission " + commission.getId()));
        extendButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LangManager.tr("review.rejected.button.extend.hover", new Object[0])).create()));
        TextComponent setMsgButton = new TextComponent("\u00a7b" + LangManager.tr("review.rejected.button.setmsg", new Object[0]));
        setMsgButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/set_rejection_message " + commission.getId()));
        setMsgButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LangManager.tr("review.rejected.button.setmsg.hover", new Object[0])).create()));
        player.sendMessage("\u00a7c" + LangManager.tr("review.rejected.title", new Object[0]));
        player.spigot().sendMessage(new BaseComponent[]{terminateButton, new TextComponent(" "), extendButton, new TextComponent(" "), setMsgButton});
    }

    public void confirmReview(Player player, String commissionId) {
        Commission commission = this.plugin.getDataManager().getCommission(commissionId);
        if (commission == null) {
            player.sendMessage("\u00a7c\u59d4\u6258\u4e0d\u5b58\u5728\uff01");
            return;
        }
        double reward = commission.getReward();
        if (commission.getPartners().size() > 0) {
            reward /= (double)(commission.getPartners().size() + 1);
        }
        this.plugin.getEconomyManager().deposit(commission.getContractor(), reward);
        for (String partner : commission.getPartners()) {
            this.plugin.getEconomyManager().deposit(partner, reward);
        }
        String message = commission.getApprovalMessage();
        this.plugin.getDataManager().addPlayerMessage(commission.getContractor(), message);
        for (String partner : commission.getPartners()) {
            this.plugin.getDataManager().addPlayerMessage(partner, message);
        }
        this.plugin.getDataManager().removeCommission(commissionId);
        player.sendMessage("\u00a7a" + LangManager.tr("confirm.complete.normal", message));
    }

    public void modifyReward(Player player, String commissionId) {
        Commission commission = this.plugin.getDataManager().getCommission(commissionId);
        if (commission == null) {
            player.sendMessage("\u00a7c\u59d4\u6258\u4e0d\u5b58\u5728\uff01");
            return;
        }
        player.sendMessage("\u00a7e\u8bf7\u8f93\u5165\u5e0c\u671b\u4fee\u6539\u7684\u91d1\u989d\uff08\u539f\u672c\u5956\u91d1: " + commission.getReward() + ")\uff1a");
        InteractiveSession.startSession(player, InteractiveSession.SessionType.MODIFY_REWARD, input -> {
            try {
                double newReward = Double.parseDouble(input);
                if (newReward < 0.0) {
                    player.sendMessage("\u00a7c" + LangManager.tr("error.negative_reward", new Object[0]));
                    return;
                }
                double reward = newReward;
                if (commission.getPartners().size() > 0) {
                    reward /= (double)(commission.getPartners().size() + 1);
                }
                this.plugin.getEconomyManager().deposit(commission.getContractor(), reward);
                for (String partner : commission.getPartners()) {
                    this.plugin.getEconomyManager().deposit(partner, reward);
                }
                String message = commission.getApprovalMessage();
                this.plugin.getDataManager().addPlayerMessage(commission.getContractor(), message);
                for (String partner : commission.getPartners()) {
                    this.plugin.getDataManager().addPlayerMessage(partner, message);
                }
                this.plugin.getDataManager().removeCommission(commissionId);
                player.sendMessage("\u00a7a" + LangManager.tr("confirm.complete.modified", message));
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7c" + LangManager.tr("error.invalid_number", new Object[0]));
            }
        }, commissionId);
    }

    public void terminateCommission(Player player, String commissionId) {
        Commission commission = this.plugin.getDataManager().getCommission(commissionId);
        if (commission == null) {
            player.sendMessage("\u00a7c\u59d4\u6258\u4e0d\u5b58\u5728\uff01");
            return;
        }
        player.sendMessage("\u00a7e" + LangManager.tr("terminate.prompt.reason", new Object[0]));
        InteractiveSession.startSession(player, InteractiveSession.SessionType.TERMINATION_REASON, reason -> {
            String base = commission.getRejectionMessage();
            String message = base + " \u539f\u56e0\uff1a" + reason;
            this.plugin.getDataManager().addPlayerMessage(commission.getContractor(), message);
            for (String partner : commission.getPartners()) {
                this.plugin.getDataManager().addPlayerMessage(partner, message);
            }
            commission.setStatus(Commission.Status.UNCONTRACTED);
            commission.setContractor(null);
            commission.getPartners().clear();
            commission.setStartTime(0L);
            this.plugin.getDataManager().updateCommission(commission);
            player.sendMessage("\u00a7a" + LangManager.tr("terminate.done", base));
        }, commissionId);
    }

    public void extendCommission(Player player, String commissionId) {
        Commission commission = this.plugin.getDataManager().getCommission(commissionId);
        if (commission == null) {
            player.sendMessage("\u00a7c\u59d4\u6258\u4e0d\u5b58\u5728\uff01");
            return;
        }
        player.sendMessage("\u00a7e" + LangManager.tr("extend.prompt.reason", new Object[0]));
        InteractiveSession.startSession(player, InteractiveSession.SessionType.EXTENSION_REASON, reason -> {
            player.sendMessage("\u00a7e" + LangManager.tr("extend.prompt.days", new Object[0]));
            InteractiveSession.startSession(player, InteractiveSession.SessionType.EXTENSION_DAYS, daysInput -> {
                try {
                    int days = Integer.parseInt(daysInput);
                    if (days <= 0) {
                        player.sendMessage("\u00a7c" + LangManager.tr("error.invalid_days", new Object[0]));
                        return;
                    }
                    commission.setDuration(commission.getDuration() + days);
                    commission.setStatus(Commission.Status.IN_PROGRESS);
                    this.plugin.getDataManager().updateCommission(commission);
                    String base = commission.getRejectionMessage();
                    String message = base + " \u5efa\u8bae\uff1a" + reason + " \u5ef6\u957f\u5929\u6570\uff1a" + days;
                    this.plugin.getDataManager().addPlayerMessage(commission.getContractor(), message);
                    for (String partner : commission.getPartners()) {
                        this.plugin.getDataManager().addPlayerMessage(partner, message);
                    }
                    player.sendMessage("\u00a7a" + LangManager.tr("extend.done", days, base));
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7c" + LangManager.tr("error.invalid_days", new Object[0]));
                }
            }, commissionId);
        }, commissionId);
    }

    public void setApprovalMessage(Player player, String commissionId) {
        Commission commission = this.plugin.getDataManager().getCommission(commissionId);
        if (commission == null) {
            player.sendMessage("\u00a7c\u59d4\u6258\u4e0d\u5b58\u5728\uff01");
            return;
        }
        player.sendMessage("\u00a7e" + LangManager.tr("prompt.enter_approval_msg", new Object[0]));
        InteractiveSession.startSession(player, InteractiveSession.SessionType.APPROVAL_MESSAGE, input -> {
            String msg;
            String defaultMsg = LangManager.tr("approval_msg.default", new Object[0]);
            String string = msg = input == null ? defaultMsg : input.trim();
            if (msg.isEmpty()) {
                msg = defaultMsg;
            }
            commission.setApprovalMessage(msg);
            this.plugin.getDataManager().updateCommission(commission);
            player.sendMessage("\u00a7a\u5df2\u8bbe\u7f6e\u9a8c\u6536\u6210\u529f\u663e\u793a\u8bed\u53e5\u4e3a\uff1a" + msg);
            this.handleApproval(player, commission);
        }, commissionId);
    }

    public void setRejectionMessage(Player player, String commissionId) {
        Commission commission = this.plugin.getDataManager().getCommission(commissionId);
        if (commission == null) {
            player.sendMessage("\u00a7c\u59d4\u6258\u4e0d\u5b58\u5728\uff01");
            return;
        }
        player.sendMessage("\u00a7e" + LangManager.tr("prompt.enter_rejection_msg", new Object[0]));
        InteractiveSession.startSession(player, InteractiveSession.SessionType.REJECTION_MESSAGE, input -> {
            String msg;
            String defaultMsg = LangManager.tr("rejection_msg.default", new Object[0]);
            String string = msg = input == null ? defaultMsg : input.trim();
            if (msg.isEmpty()) {
                msg = defaultMsg;
            }
            commission.setRejectionMessage(msg);
            this.plugin.getDataManager().updateCommission(commission);
            player.sendMessage("\u00a7a\u5df2\u8bbe\u7f6e\u9a8c\u6536\u672a\u901a\u8fc7\u663e\u793a\u8bed\u53e5\u4e3a\uff1a" + msg);
            this.handleRejection(player, commission);
        }, commissionId);
    }
}

