/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeleportCommissionCommand
implements CommandExecutor {
    private final EasyBuildPlugin plugin;

    public TeleportCommissionCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /wttp <\u59d4\u6258ID>");
            return true;
        }
        String commissionId = args[0];
        Commission commission = this.plugin.getDataManager().getCommission(commissionId);
        if (commission == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u6307\u5b9a\u7684\u59d4\u6258\uff01");
            return true;
        }
        Location pos1 = commission.getPos1();
        Location pos2 = commission.getPos2();
        double centerX = (pos1.getX() + pos2.getX()) / 2.0;
        double centerZ = (pos1.getZ() + pos2.getZ()) / 2.0;
        int highestY = pos1.getWorld().getHighestBlockYAt((int)Math.floor(centerX), (int)Math.floor(centerZ));
        double centerY = highestY + 1;
        Location teleportLocation = new Location(pos1.getWorld(), Math.floor(centerX) + 0.5, centerY, Math.floor(centerZ) + 0.5);
        while (teleportLocation.getBlock().getType().isSolid() || teleportLocation.clone().add(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
            teleportLocation.add(0.0, 1.0, 0.0);
            if (!(teleportLocation.getY() > 320.0)) continue;
            teleportLocation.setY((double)(pos1.getWorld().getHighestBlockYAt(teleportLocation) + 2));
            break;
        }
        player.teleport(teleportLocation);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u5df2\u4f20\u9001\u5230\u59d4\u6258 \"" + commission.getName() + "\" \u7684\u4f4d\u7f6e\uff01");
        return true;
    }
}

