/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.listeners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import ocean.easybuild.model.PlayerMessage;
import ocean.easybuild.utils.InteractiveSession;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final EasyBuildPlugin plugin;
    private final Map<String, String> playerLastCommission = new HashMap<String, String>();

    public PlayerListener(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        List<PlayerMessage> unreadMessages = this.plugin.getDataManager().getUnreadMessages(player.getName());
        if (!unreadMessages.isEmpty()) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                for (PlayerMessage message : unreadMessages) {
                    player.sendMessage("\u00a7e[\u7cfb\u7edf\u6d88\u606f] " + message.getContent());
                    this.plugin.getDataManager().markMessageAsRead(message.getId());
                }
            }, 20L);
        }
        if (player.hasPermission("easybuild.admin")) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                List<Commission> completedCommissions = this.plugin.getDataManager().getCommissionsByStatus(Commission.Status.COMPLETED);
                if (!completedCommissions.isEmpty()) {
                    player.sendMessage("\u00a7e=== \u5f85\u9a8c\u6536\u59d4\u6258\u5217\u8868 ===");
                    for (int i = 0; i < completedCommissions.size(); ++i) {
                        Commission commission = completedCommissions.get(i);
                        player.sendMessage("\u00a7a" + (i + 1) + ". \u00a7e" + commission.getName());
                    }
                }
            }, 40L);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Commission commission = this.plugin.getDataManager().getCommissionAtLocation(player.getLocation());
        String currentCommissionId = commission != null ? commission.getId() : null;
        String lastCommissionId = this.playerLastCommission.get(player.getName());
        if (currentCommissionId != null && !currentCommissionId.equals(lastCommissionId)) {
            this.playerLastCommission.put(player.getName(), currentCommissionId);
            if (commission.getStatus() == Commission.Status.UNCONTRACTED) {
                player.sendMessage("\u00a7b" + commission.getName());
                player.sendMessage("\u00a77/cbwt\u5373\u53ef\u5f00\u59cb\u5efa\u9020\uff01");
            } else if (commission.getStatus() == Commission.Status.IN_PROGRESS) {
                String contractorName = commission.getContractor();
                Object partnersText = "";
                if (!commission.getPartners().isEmpty()) {
                    partnersText = "\u3001" + String.join((CharSequence)"\u3001", commission.getPartners());
                }
                player.sendMessage("\u00a7e\u8fdb\u5165" + commission.getName() + "\u5de5\u5730 \uff08\u5efa\u8bbe\u8005\uff1a" + contractorName + (String)partnersText + "\uff09");
            }
        }
        if (currentCommissionId == null && lastCommissionId != null) {
            this.playerLastCommission.remove(player.getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (InteractiveSession.isInSession(player.getName())) {
            event.setCancelled(true);
            event.getRecipients().clear();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> InteractiveSession.handleInput(player, event.getMessage()));
        }
    }
}

