/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ocean.easybuild.model.Commission;
import ocean.easybuild.model.PlayerMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DataManager {
    private final Plugin plugin;
    private final Map<String, Commission> commissions;
    private final Map<String, List<PlayerMessage>> playerMessages;
    private File commissionsFile;
    private File messagesFile;
    private FileConfiguration commissionsConfig;
    private FileConfiguration messagesConfig;

    public DataManager(Plugin plugin) {
        this.plugin = plugin;
        this.commissions = new ConcurrentHashMap<String, Commission>();
        this.playerMessages = new ConcurrentHashMap<String, List<PlayerMessage>>();
        this.initFiles();
        this.loadData();
    }

    private void initFiles() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.commissionsFile = new File(this.plugin.getDataFolder(), "commissions.yml");
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.commissionsFile.exists()) {
            try {
                this.commissionsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("\u65e0\u6cd5\u521b\u5efa\u59d4\u6258\u6570\u636e\u6587\u4ef6: " + e.getMessage());
            }
        }
        if (!this.messagesFile.exists()) {
            try {
                this.messagesFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("\u65e0\u6cd5\u521b\u5efa\u6d88\u606f\u6570\u636e\u6587\u4ef6: " + e.getMessage());
            }
        }
        this.commissionsConfig = YamlConfiguration.loadConfiguration((File)this.commissionsFile);
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void loadData() {
        this.loadCommissions();
        this.loadMessages();
    }

    private void loadCommissions() {
        ConfigurationSection section = this.commissionsConfig.getConfigurationSection("commissions");
        if (section == null) {
            return;
        }
        for (String id : section.getKeys(false)) {
            try {
                ConfigurationSection msgSec;
                ConfigurationSection commissionSection = section.getConfigurationSection(id);
                if (commissionSection == null) continue;
                String name = commissionSection.getString("name");
                String description = commissionSection.getString("description");
                int duration = commissionSection.getInt("duration");
                double reward = commissionSection.getDouble("reward");
                Location pos1 = this.loadLocation(commissionSection.getConfigurationSection("pos1"));
                Location pos2 = this.loadLocation(commissionSection.getConfigurationSection("pos2"));
                Commission commission = new Commission(id, name, description, pos1, pos2, duration, reward);
                String statusStr = commissionSection.getString("status", "UNCONTRACTED");
                commission.setStatus(Commission.Status.valueOf(statusStr));
                String contractorStr = commissionSection.getString("contractor");
                if (contractorStr != null && !contractorStr.isEmpty()) {
                    commission.setContractor(contractorStr);
                }
                List partnerStrs = commissionSection.getStringList("partners");
                commission.setPartners(partnerStrs);
                commission.setStartTime(commissionSection.getLong("startTime"));
                commission.setCreateTime(commissionSection.getLong("createTime"));
                ConfigurationSection permSec = commissionSection.getConfigurationSection("permissions");
                if (permSec != null) {
                    String entryMode = permSec.getString("entry.mode", Commission.PermissionMode.OPEN.name());
                    String buildMode = permSec.getString("build.mode", Commission.PermissionMode.CLOSED.name());
                    commission.setEntryPermissionMode(Commission.PermissionMode.valueOf(entryMode));
                    commission.setBuildPermissionMode(Commission.PermissionMode.valueOf(buildMode));
                    commission.setEntryWhitelist(permSec.getStringList("entry.whitelist"));
                    commission.setBuildWhitelist(permSec.getStringList("build.whitelist"));
                }
                if ((msgSec = commissionSection.getConfigurationSection("messages")) != null) {
                    String approval = msgSec.getString("approval", commission.getApprovalMessage());
                    String rejection = msgSec.getString("rejection", commission.getRejectionMessage());
                    commission.setApprovalMessage(approval);
                    commission.setRejectionMessage(rejection);
                }
                this.commissions.put(id, commission);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u52a0\u8f7d\u59d4\u6258 " + id + " \u65f6\u51fa\u9519: " + e.getMessage());
            }
        }
    }

    private void loadMessages() {
        ConfigurationSection messagesSection;
        if (this.messagesConfig.contains("messages") && (messagesSection = this.messagesConfig.getConfigurationSection("messages")) != null) {
            for (String playerName : messagesSection.getKeys(false)) {
                ConfigurationSection playerSection = messagesSection.getConfigurationSection(playerName);
                if (playerSection == null) continue;
                ArrayList<PlayerMessage> messages = new ArrayList<PlayerMessage>();
                for (String messageId : playerSection.getKeys(false)) {
                    ConfigurationSection messageSection = playerSection.getConfigurationSection(messageId);
                    if (messageSection == null) continue;
                    String content = messageSection.getString("content");
                    String timestamp = messageSection.getString("timestamp");
                    boolean read = messageSection.getBoolean("read", false);
                    PlayerMessage message = new PlayerMessage(playerName, content);
                    message.setRead(read);
                    messages.add(message);
                }
                this.playerMessages.put(playerName, messages);
            }
        }
    }

    private Location loadLocation(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        String worldName = section.getString("world");
        double x = section.getDouble("x");
        double y = section.getDouble("y");
        double z = section.getDouble("z");
        return new Location(Bukkit.getWorld((String)worldName), x, y, z);
    }

    public void saveData() {
        this.saveCommissions();
        this.saveMessages();
    }

    private void saveCommissions() {
        this.commissionsConfig.set("commissions", null);
        for (Commission commission : this.commissions.values()) {
            String path = "commissions." + commission.getId();
            this.commissionsConfig.set(path + ".name", (Object)commission.getName());
            this.commissionsConfig.set(path + ".description", (Object)commission.getDescription());
            this.commissionsConfig.set(path + ".duration", (Object)commission.getDuration());
            this.commissionsConfig.set(path + ".reward", (Object)commission.getReward());
            this.commissionsConfig.set(path + ".status", (Object)commission.getStatus().name());
            this.saveLocation(this.commissionsConfig, path + ".pos1", commission.getPos1());
            this.saveLocation(this.commissionsConfig, path + ".pos2", commission.getPos2());
            if (commission.getContractor() != null) {
                this.commissionsConfig.set(path + ".contractor", (Object)commission.getContractor().toString());
            }
            this.commissionsConfig.set(path + ".partners", commission.getPartners());
            this.commissionsConfig.set(path + ".startTime", (Object)commission.getStartTime());
            this.commissionsConfig.set(path + ".createTime", (Object)commission.getCreateTime());
            String permBase = path + ".permissions";
            this.commissionsConfig.set(permBase + ".entry.mode", (Object)commission.getEntryPermissionMode().name());
            this.commissionsConfig.set(permBase + ".entry.whitelist", commission.getEntryWhitelist());
            this.commissionsConfig.set(permBase + ".build.mode", (Object)commission.getBuildPermissionMode().name());
            this.commissionsConfig.set(permBase + ".build.whitelist", commission.getBuildWhitelist());
            this.commissionsConfig.set(path + ".messages.approval", (Object)commission.getApprovalMessage());
            this.commissionsConfig.set(path + ".messages.rejection", (Object)commission.getRejectionMessage());
        }
        try {
            this.commissionsConfig.save(this.commissionsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u4fdd\u5b58\u59d4\u6258\u6570\u636e\u5931\u8d25: " + e.getMessage());
        }
    }

    private void saveMessages() {
        this.messagesConfig.set("messages", null);
        for (Map.Entry<String, List<PlayerMessage>> entry : this.playerMessages.entrySet()) {
            String playerName = entry.getKey();
            List<PlayerMessage> messages = entry.getValue();
            for (int i = 0; i < messages.size(); ++i) {
                PlayerMessage message = messages.get(i);
                String path = "messages." + playerName + "." + message.getId();
                this.messagesConfig.set(path + ".content", (Object)message.getContent());
                this.messagesConfig.set(path + ".timestamp", (Object)message.getTimestamp());
                this.messagesConfig.set(path + ".read", (Object)message.isRead());
            }
        }
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u4fdd\u5b58\u6d88\u606f\u6570\u636e\u5931\u8d25: " + e.getMessage());
        }
    }

    private void saveLocation(FileConfiguration config, String path, Location location) {
        if (location == null) {
            return;
        }
        config.set(path + ".world", (Object)location.getWorld().getName());
        config.set(path + ".x", (Object)location.getX());
        config.set(path + ".y", (Object)location.getY());
        config.set(path + ".z", (Object)location.getZ());
    }

    public void addCommission(Commission commission) {
        this.commissions.put(commission.getId(), commission);
        this.saveCommissions();
    }

    public Commission getCommission(String id) {
        return this.commissions.get(id);
    }

    public Commission getCommissionByName(String name) {
        return this.commissions.values().stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
    }

    public void updateCommission(Commission commission) {
        this.commissions.put(commission.getId(), commission);
        this.saveCommissions();
    }

    public void removeCommission(String id) {
        this.commissions.remove(id);
        this.saveCommissions();
    }

    public Collection<Commission> getAllCommissions() {
        return this.commissions.values();
    }

    public List<Commission> getCommissionsByStatus(Commission.Status status) {
        return this.commissions.values().stream().filter(c -> c.getStatus() == status).collect(ArrayList::new, (list, item) -> list.add(item), ArrayList::addAll);
    }

    public Commission getCommissionAtLocation(Location location) {
        return this.commissions.values().stream().filter(c -> c.isInRegion(location)).findFirst().orElse(null);
    }

    public void addPlayerMessage(String playerName, String message) {
        Player online = Bukkit.getPlayerExact((String)playerName);
        PlayerMessage playerMessage = new PlayerMessage(playerName, message);
        if (online != null && online.isOnline()) {
            online.sendMessage("\u00a7e[\u7cfb\u7edf\u6d88\u606f] " + message);
            playerMessage.setRead(true);
        }
        this.playerMessages.computeIfAbsent(playerName, k -> new ArrayList()).add(playerMessage);
        this.saveMessages();
    }

    public List<PlayerMessage> getPlayerMessages(String playerName) {
        return this.playerMessages.getOrDefault(playerName, new ArrayList());
    }

    public List<PlayerMessage> getUnreadMessages(String playerName) {
        return this.getPlayerMessages(playerName).stream().filter(msg -> !msg.isRead()).collect(ArrayList::new, (list, item) -> list.add(item), ArrayList::addAll);
    }

    public void markMessageAsRead(String messageId) {
        for (List<PlayerMessage> messages : this.playerMessages.values()) {
            for (PlayerMessage message : messages) {
                if (!message.getId().equals(messageId)) continue;
                message.setRead(true);
                this.saveMessages();
                return;
            }
        }
    }
}

