/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild;

import net.milkbowl.vault.economy.Economy;
import ocean.easybuild.commands.AbandonCommissionCommand;
import ocean.easybuild.commands.AddPartnerCommand;
import ocean.easybuild.commands.CommissionInfoCommand;
import ocean.easybuild.commands.CompleteCommissionCommand;
import ocean.easybuild.commands.ContractCommissionCommand;
import ocean.easybuild.commands.CreateCommissionCommand;
import ocean.easybuild.commands.DeleteCommissionCommand;
import ocean.easybuild.commands.InternalCommands;
import ocean.easybuild.commands.ListCommissionsCommand;
import ocean.easybuild.commands.PermissionCommand;
import ocean.easybuild.commands.ReviewCommissionCommand;
import ocean.easybuild.commands.SetCommissionCommand;
import ocean.easybuild.commands.TeleportCommissionCommand;
import ocean.easybuild.listeners.PermissionProtectionListener;
import ocean.easybuild.listeners.PlayerListener;
import ocean.easybuild.storage.DataManager;
import ocean.easybuild.utils.EconomyManager;
import ocean.easybuild.utils.LangManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class EasyBuildPlugin
extends JavaPlugin {
    private static EasyBuildPlugin instance;
    private DataManager dataManager;
    private EconomyManager economyManager;
    private Economy economy;

    public void onEnable() {
        instance = this;
        this.setupEconomy();
        LangManager.init((Plugin)this);
        this.dataManager = new DataManager((Plugin)this);
        this.economyManager = new EconomyManager(this.economy);
        if (!this.economyManager.isEconomyAvailable()) {
            this.getLogger().warning("\u672a\u627e\u5230\u7ecf\u6d4e\u63d2\u4ef6 (Vault + \u7ecf\u6d4e\u63d2\u4ef6 \u6216 XConomy)\uff01");
            this.getLogger().warning("\u63d2\u4ef6\u5c06\u7ee7\u7eed\u8fd0\u884c\uff0c\u4f46\u7ecf\u6d4e\u529f\u80fd\u53ef\u80fd\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c\u3002");
        } else {
            this.getLogger().info("\u7ecf\u6d4e\u7cfb\u7edf\u5df2\u6210\u529f\u521d\u59cb\u5316\uff01");
        }
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PermissionProtectionListener(this), (Plugin)this);
        this.getLogger().info("EasyBuild \u63d2\u4ef6\u5df2\u542f\u7528\uff01");
    }

    public void onDisable() {
        if (this.dataManager != null) {
            this.dataManager.saveData();
        }
        this.getLogger().info("EasyBuild \u63d2\u4ef6\u5df2\u7981\u7528\uff01");
    }

    private void setupEconomy() {
        RegisteredServiceProvider rsp;
        if (this.getServer().getPluginManager().getPlugin("Vault") != null && (rsp = this.getServer().getServicesManager().getRegistration(Economy.class)) != null) {
            this.economy = (Economy)rsp.getProvider();
            if (this.economy != null) {
                this.getLogger().info("\u5df2\u8fde\u63a5\u5230Vault\u7ecf\u6d4e\u7cfb\u7edf: " + this.economy.getName());
                return;
            }
        }
        if (this.getServer().getPluginManager().getPlugin("XConomy") != null) {
            this.getLogger().info("\u68c0\u6d4b\u5230XConomy\u63d2\u4ef6\uff0c\u5c06\u4f7f\u7528\u547d\u4ee4\u65b9\u5f0f\u8fdb\u884c\u7ecf\u6d4e\u64cd\u4f5c");
        } else {
            this.getLogger().warning("\u672a\u627e\u5230Vault\u6216XConomy\u63d2\u4ef6\uff01");
        }
    }

    private void registerCommands() {
        try {
            this.registerCommand("wtcj", new CreateCommissionCommand(this));
            this.registerCommand("yswt", new ReviewCommissionCommand(this));
            this.registerCommand("wtset", new SetCommissionCommand(this));
            this.registerCommand("wtdel", new DeleteCommissionCommand(this));
            this.registerCommand("cbwt", new ContractCommissionCommand(this));
            this.registerCommand("wtwg", new CompleteCommissionCommand(this));
            this.registerCommand("fcwt", new AbandonCommissionCommand(this));
            this.registerCommand("wt", new ListCommissionsCommand(this));
            this.registerCommand("wtadd", new AddPartnerCommand(this));
            this.registerCommand("wtinfo", new CommissionInfoCommand(this));
            this.registerCommand("wttp", new TeleportCommissionCommand(this));
            PermissionCommand permissionCommand = new PermissionCommand(this);
            this.registerCommand("wtqx", permissionCommand);
            this.getServer().getPluginManager().registerEvents((Listener)permissionCommand, (Plugin)this);
            InternalCommands internalCommands = new InternalCommands(this);
            this.registerCommand("confirm_review", internalCommands);
            this.registerCommand("modify_reward", internalCommands);
            this.registerCommand("terminate_commission", internalCommands);
            this.registerCommand("extend_commission", internalCommands);
            this.registerCommand("set_approval_message", internalCommands);
            this.registerCommand("set_rejection_message", internalCommands);
            this.getLogger().info("\u6240\u6709\u547d\u4ee4\u6ce8\u518c\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            this.getLogger().severe("\u547d\u4ee4\u6ce8\u518c\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void registerCommand(String commandName, CommandExecutor executor) {
        PluginCommand command = this.getCommand(commandName);
        if (command != null) {
            command.setExecutor(executor);
            this.getLogger().info("\u6210\u529f\u6ce8\u518c\u547d\u4ee4: " + commandName);
        } else {
            this.getLogger().warning("\u65e0\u6cd5\u6ce8\u518c\u547d\u4ee4 '" + commandName + "' - \u547d\u4ee4\u672a\u5728plugin.yml\u4e2d\u5b9a\u4e49\u6216\u83b7\u53d6\u5931\u8d25");
        }
    }

    public static EasyBuildPlugin getInstance() {
        return instance;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

