/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommissionInfoCommand
implements CommandExecutor {
    private final EasyBuildPlugin plugin;

    public CommissionInfoCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /wtinfo <\u59d4\u6258ID>");
            return true;
        }
        String commissionId = args[0];
        Commission commission = this.plugin.getDataManager().getCommission(commissionId);
        if (commission == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u6307\u5b9a\u7684\u59d4\u6258\uff01");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "========== \u59d4\u6258\u8be6\u60c5 ==========");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u540d\u79f0: " + String.valueOf(ChatColor.WHITE) + commission.getName());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u72b6\u6001: " + String.valueOf(this.getStatusColor(commission.getStatus())) + commission.getStatus().getDisplayName());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u62a5\u916c: " + String.valueOf(ChatColor.GREEN) + this.plugin.getEconomyManager().format(commission.getReward()));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5de5\u671f: " + String.valueOf(ChatColor.AQUA) + commission.getDuration() + " \u5929");
        if (commission.getStatus() == Commission.Status.IN_PROGRESS) {
            int remaining = commission.getRemainingDays();
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5269\u4f59\u5de5\u671f: " + String.valueOf(ChatColor.AQUA) + remaining + " \u5929");
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u63cf\u8ff0: " + String.valueOf(ChatColor.GRAY) + commission.getDescription());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u4f4d\u7f6e: " + String.valueOf(ChatColor.WHITE) + "(" + commission.getPos1().getBlockX() + "," + commission.getPos1().getBlockY() + "," + commission.getPos1().getBlockZ() + ") \u5230 (" + commission.getPos2().getBlockX() + "," + commission.getPos2().getBlockY() + "," + commission.getPos2().getBlockZ() + ")");
        if (commission.getContractor() != null) {
            String contractorName = Bukkit.getOfflinePlayer((String)commission.getContractor()).getName();
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u627f\u5305\u4eba: " + String.valueOf(ChatColor.LIGHT_PURPLE) + contractorName);
            if (!commission.getPartners().isEmpty()) {
                StringBuilder partners = new StringBuilder();
                for (int i = 0; i < commission.getPartners().size(); ++i) {
                    if (i > 0) {
                        partners.append(", ");
                    }
                    partners.append(Bukkit.getOfflinePlayer((String)commission.getPartners().get(i)).getName());
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5408\u4f5c\u4f19\u4f34: " + String.valueOf(ChatColor.LIGHT_PURPLE) + partners.toString());
            }
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "============================");
        TextComponent teleportButton = new TextComponent("[\u4f20\u9001\u5230\u6b64\u5904]");
        teleportButton.setColor(net.md_5.bungee.api.ChatColor.GREEN);
        teleportButton.setBold(Boolean.valueOf(true));
        teleportButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wttp " + commission.getId()));
        player.spigot().sendMessage((BaseComponent)teleportButton);
        return true;
    }

    private ChatColor getStatusColor(Commission.Status status) {
        switch (status) {
            case UNCONTRACTED: {
                return ChatColor.BLUE;
            }
            case IN_PROGRESS: {
                return ChatColor.YELLOW;
            }
            case COMPLETED: {
                return ChatColor.GREEN;
            }
        }
        return ChatColor.WHITE;
    }
}

