/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CompleteCommissionCommand
implements CommandExecutor {
    private final EasyBuildPlugin plugin;

    public CompleteCommissionCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        Commission commission = null;
        for (Commission c : this.plugin.getDataManager().getAllCommissions()) {
            if (c.getStatus() != Commission.Status.IN_PROGRESS || c.getContractor() == null || !c.getContractor().equals(player.getName())) continue;
            commission = c;
            break;
        }
        if (commission == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u6b63\u5728\u5efa\u8bbe\u7684\u59d4\u6258\uff01");
            return true;
        }
        commission.setStatus(Commission.Status.COMPLETED);
        this.plugin.getDataManager().updateCommission(commission);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u59d4\u6258 \"" + commission.getName() + "\" \u5df2\u63d0\u4ea4\u5b8c\u5de5\u7533\u8bf7\uff01");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u8bf7\u7b49\u5f85\u7ba1\u7406\u5458\u9a8c\u6536...");
        this.notifyOnlineOPs(commission);
        return true;
    }

    private void notifyOnlineOPs(Commission commission) {
        String message = String.valueOf(ChatColor.GOLD) + "[\u59d4\u6258\u7cfb\u7edf] " + String.valueOf(ChatColor.YELLOW) + "\u59d4\u6258 \"" + commission.getName() + "\" \u5df2\u5b8c\u5de5\uff0c\u7b49\u5f85\u9a8c\u6536\uff01";
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!onlinePlayer.hasPermission("easybuild.admin")) continue;
            onlinePlayer.sendMessage(message);
            onlinePlayer.sendMessage(String.valueOf(ChatColor.GRAY) + "\u4f7f\u7528 /yswt y/n \u8fdb\u884c\u9a8c\u6536\uff08\u9700\u7ad9\u5728\u59d4\u6258\u533a\u57df\u5185\uff09");
        }
    }
}

