/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ContractCommissionCommand
implements CommandExecutor {
    private final EasyBuildPlugin plugin;

    public ContractCommissionCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        Commission commission = this.plugin.getDataManager().getCommissionAtLocation(player.getLocation());
        if (commission == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u4e0d\u5728\u4efb\u4f55\u59d4\u6258\u533a\u57df\u5185\uff01");
            return true;
        }
        if (commission.getStatus() != Commission.Status.UNCONTRACTED) {
            if (commission.getStatus() == Commission.Status.IN_PROGRESS) {
                if (commission.getContractor() != null && commission.getContractor().equals(player.getName()) || commission.getPartners().contains(player.getName())) {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u4f60\u5df2\u7ecf\u662f\u8fd9\u4e2a\u59d4\u6258\u7684\u5efa\u8bbe\u8005\u4e86\uff01");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u8fd9\u4e2a\u59d4\u6258\u5df2\u7ecf\u88ab\u5176\u4ed6\u4eba\u627f\u5305\u4e86\uff01");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "\u8fd9\u4e2a\u59d4\u6258\u5f53\u524d\u4e0d\u53ef\u627f\u5305\uff01");
            }
            return true;
        }
        for (Commission existingCommission : this.plugin.getDataManager().getAllCommissions()) {
            if (existingCommission.getStatus() != Commission.Status.IN_PROGRESS || existingCommission.getContractor() == null || !existingCommission.getContractor().equals(player.getName())) continue;
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u5df2\u7ecf\u627f\u5305\u4e86\u59d4\u6258 \"" + existingCommission.getName() + "\"\uff0c\u8bf7\u5148\u5b8c\u6210\u6216\u653e\u5f03\u5f53\u524d\u59d4\u6258\uff01");
            return true;
        }
        commission.setContractor(player.getName());
        commission.setStatus(Commission.Status.IN_PROGRESS);
        this.plugin.getDataManager().updateCommission(commission);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u627f\u5305\u59d4\u6258 \"" + commission.getName() + "\"\uff01");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u59d4\u6258\u63cf\u8ff0: " + commission.getDescription());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u59d4\u6258\u5de5\u671f: " + commission.getDuration() + " \u5929");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u59d4\u6258\u62a5\u916c: " + this.plugin.getEconomyManager().format(commission.getReward()));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u4f7f\u7528 /wtwg \u5b8c\u6210\u59d4\u6258\uff0c\u4f7f\u7528 /fcwt \u653e\u5f03\u59d4\u6258");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u4f7f\u7528 /wtadd <\u73a9\u5bb6\u540d> \u6dfb\u52a0\u5408\u4f5c\u4f19\u4f34\uff08\u6700\u591a1\u4eba\uff09");
        return true;
    }
}

