/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.commands;

import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import ocean.easybuild.utils.InteractiveSession;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetCommissionCommand
implements CommandExecutor {
    private final EasyBuildPlugin plugin;

    public SetCommissionCommand(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7c\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("easybuild.admin")) {
            player.sendMessage("\u00a7c\u60a8\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6b64\u547d\u4ee4\uff01");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage("\u00a7c\u7528\u6cd5: /wtset <\u59d4\u6258\u540d\u79f0>");
            return true;
        }
        String commissionName = args[0];
        Commission commission = null;
        for (Commission c : this.plugin.getDataManager().getAllCommissions()) {
            if (!c.getName().equals(commissionName)) continue;
            commission = c;
            break;
        }
        if (commission == null) {
            player.sendMessage("\u00a7c\u627e\u4e0d\u5230\u540d\u4e3a '" + commissionName + "' \u7684\u59d4\u6258\uff01");
            return true;
        }
        this.showOptionsMenu(player, commission);
        return true;
    }

    private void showOptionsMenu(Player player, Commission commission) {
        player.sendMessage("\u00a7e=== \u59d4\u6258\u7ba1\u7406: " + commission.getName() + " ===");
        player.sendMessage("\u00a7a1. \u4fee\u6539\u72b6\u6001");
        player.sendMessage("\u00a7b2. \u5ef6\u957f\u5de5\u671f");
        player.sendMessage("\u00a7c0. \u9000\u51fa");
        player.sendMessage("\u00a7e\u8bf7\u8f93\u5165\u9009\u9879\u7f16\u53f7\uff1a");
        InteractiveSession.startSession(player, InteractiveSession.SessionType.SET_STATUS, input -> {
            try {
                int option = Integer.parseInt(input);
                switch (option) {
                    case 1: {
                        this.showStatusMenu(player, commission);
                        break;
                    }
                    case 2: {
                        this.extendDuration(player, commission);
                        break;
                    }
                    case 0: {
                        player.sendMessage("\u00a7a\u5df2\u9000\u51fa\u59d4\u6258\u7ba1\u7406\u3002");
                        break;
                    }
                    default: {
                        player.sendMessage("\u00a7c\u65e0\u6548\u7684\u9009\u9879\uff01");
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7c\u8bf7\u8f93\u5165\u6709\u6548\u7684\u6570\u5b57\uff01");
            }
        }, commission.getId());
    }

    private void showStatusMenu(Player player, Commission commission) {
        player.sendMessage("\u00a7e=== \u4fee\u6539\u59d4\u6258\u72b6\u6001 ===");
        player.sendMessage("\u00a7b1. \u672a\u627f\u5305");
        player.sendMessage("\u00a7e2. \u5efa\u8bbe\u4e2d");
        player.sendMessage("\u00a7a3. \u5df2\u5b8c\u5de5");
        player.sendMessage("\u00a7c0. \u9000\u51fa");
        player.sendMessage("\u00a7e\u8bf7\u8f93\u5165\u72b6\u6001\u7f16\u53f7\uff1a");
        InteractiveSession.startSession(player, InteractiveSession.SessionType.SET_STATUS, input -> {
            try {
                int statusOption = Integer.parseInt(input);
                Commission.Status newStatus = null;
                switch (statusOption) {
                    case 1: {
                        newStatus = Commission.Status.UNCONTRACTED;
                        commission.setContractor(null);
                        commission.getPartners().clear();
                        commission.setStartTime(0L);
                        break;
                    }
                    case 2: {
                        newStatus = Commission.Status.IN_PROGRESS;
                        break;
                    }
                    case 3: {
                        newStatus = Commission.Status.COMPLETED;
                        break;
                    }
                    case 0: {
                        player.sendMessage("\u00a7a\u5df2\u9000\u51fa\u72b6\u6001\u4fee\u6539\u3002");
                        return;
                    }
                    default: {
                        player.sendMessage("\u00a7c\u65e0\u6548\u7684\u72b6\u6001\u7f16\u53f7\uff01");
                        return;
                    }
                }
                commission.setStatus(newStatus);
                this.plugin.getDataManager().updateCommission(commission);
                String statusName = this.getStatusName(newStatus);
                player.sendMessage("\u00a7a\u59d4\u6258 '" + commission.getName() + "' \u7684\u72b6\u6001\u5df2\u4fee\u6539\u4e3a: " + statusName);
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7c\u8bf7\u8f93\u5165\u6709\u6548\u7684\u6570\u5b57\uff01");
            }
        }, commission.getId());
    }

    private void extendDuration(Player player, Commission commission) {
        player.sendMessage("\u00a7e\u8bf7\u8f93\u5165\u8981\u5ef6\u957f\u7684\u5929\u6570\uff1a");
        InteractiveSession.startSession(player, InteractiveSession.SessionType.EXTENSION_DAYS, input -> {
            try {
                int days = Integer.parseInt(input);
                if (days <= 0) {
                    player.sendMessage("\u00a7c\u5ef6\u957f\u5929\u6570\u5fc5\u987b\u5927\u4e8e0\uff01");
                    return;
                }
                commission.setDuration(commission.getDuration() + days);
                this.plugin.getDataManager().updateCommission(commission);
                player.sendMessage("\u00a7a\u59d4\u6258 '" + commission.getName() + "' \u7684\u5de5\u671f\u5df2\u5ef6\u957f " + days + " \u5929\u3002");
                player.sendMessage("\u00a7a\u65b0\u7684\u5de5\u671f\u4e3a: " + commission.getDuration() + " \u5929");
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7c\u8bf7\u8f93\u5165\u6709\u6548\u7684\u5929\u6570\uff01");
            }
        }, commission.getId());
    }

    private String getStatusName(Commission.Status status) {
        switch (status) {
            case UNCONTRACTED: {
                return "\u00a7b\u672a\u627f\u5305";
            }
            case IN_PROGRESS: {
                return "\u00a7e\u5efa\u8bbe\u4e2d";
            }
            case COMPLETED: {
                return "\u00a7a\u5df2\u5b8c\u5de5";
            }
        }
        return "\u00a77\u672a\u77e5";
    }
}

