/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.listeners;

import ocean.easybuild.EasyBuildPlugin;
import ocean.easybuild.model.Commission;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class PermissionProtectionListener
implements Listener {
    private final EasyBuildPlugin plugin;

    public PermissionProtectionListener(EasyBuildPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        Commission commission = this.plugin.getDataManager().getCommissionAtLocation(event.getTo());
        if (commission == null) {
            return;
        }
        if (commission.getStatus() == Commission.Status.UNCONTRACTED || commission.getStatus() == Commission.Status.COMPLETED) {
            return;
        }
        if (!commission.isAllowedToEnter(player.getName())) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u8fdb\u5165\u8be5\u59d4\u6258\u533a\u57df\u7684\u6743\u9650\uff01");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Commission commission = this.plugin.getDataManager().getCommissionAtLocation(event.getBlock().getLocation());
        if (commission == null) {
            return;
        }
        if (commission.getStatus() == Commission.Status.UNCONTRACTED || commission.getStatus() == Commission.Status.COMPLETED) {
            return;
        }
        if (!commission.isAllowedToBuild(player.getName())) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u5728\u8be5\u59d4\u6258\u533a\u57df\u5185\u653e\u7f6e\u65b9\u5757\u7684\u6743\u9650\uff01");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Commission commission = this.plugin.getDataManager().getCommissionAtLocation(event.getBlock().getLocation());
        if (commission == null) {
            return;
        }
        if (commission.getStatus() == Commission.Status.UNCONTRACTED || commission.getStatus() == Commission.Status.COMPLETED) {
            return;
        }
        if (!commission.isAllowedToBuild(player.getName())) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u5728\u8be5\u59d4\u6258\u533a\u57df\u5185\u7834\u574f\u65b9\u5757\u7684\u6743\u9650\uff01");
        }
    }
}

