/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.model;

import java.util.ArrayList;
import java.util.List;
import ocean.easybuild.utils.LangManager;
import org.bukkit.Location;

public class Commission {
    private String id;
    private String name;
    private String description;
    private Location pos1;
    private Location pos2;
    private int duration;
    private double reward;
    private Status status;
    private String contractor;
    private List<String> partners;
    private long startTime;
    private long createTime;
    private PermissionMode entryPermissionMode = PermissionMode.OPEN;
    private PermissionMode buildPermissionMode = PermissionMode.CLOSED;
    private List<String> entryWhitelist = new ArrayList<String>();
    private List<String> buildWhitelist = new ArrayList<String>();
    private String approvalMessage = null;
    private String rejectionMessage = null;

    public Commission(String id, String name, String description, Location pos1, Location pos2, int duration, double reward) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.duration = duration;
        this.reward = reward;
        this.status = Status.UNCONTRACTED;
        this.partners = new ArrayList<String>();
        this.createTime = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Location getPos1() {
        return this.pos1;
    }

    public void setPos1(Location pos1) {
        this.pos1 = pos1;
    }

    public Location getPos2() {
        return this.pos2;
    }

    public void setPos2(Location pos2) {
        this.pos2 = pos2;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public double getReward() {
        return this.reward;
    }

    public void setReward(double reward) {
        this.reward = reward;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getContractor() {
        return this.contractor;
    }

    public void setContractor(String contractor) {
        this.contractor = contractor;
        if (contractor != null && this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public List<String> getPartners() {
        return this.partners;
    }

    public void setPartners(List<String> partners) {
        this.partners = partners;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public PermissionMode getEntryPermissionMode() {
        return this.entryPermissionMode;
    }

    public void setEntryPermissionMode(PermissionMode mode) {
        this.entryPermissionMode = mode;
    }

    public PermissionMode getBuildPermissionMode() {
        return this.buildPermissionMode;
    }

    public void setBuildPermissionMode(PermissionMode mode) {
        this.buildPermissionMode = mode;
    }

    public List<String> getEntryWhitelist() {
        return this.entryWhitelist;
    }

    public void setEntryWhitelist(List<String> whitelist) {
        this.entryWhitelist = whitelist != null ? whitelist : new ArrayList();
    }

    public List<String> getBuildWhitelist() {
        return this.buildWhitelist;
    }

    public void setBuildWhitelist(List<String> whitelist) {
        this.buildWhitelist = whitelist != null ? whitelist : new ArrayList();
    }

    public String getApprovalMessage() {
        return this.approvalMessage == null || this.approvalMessage.trim().isEmpty() ? LangManager.tr("approval_msg.default", new Object[0]) : this.approvalMessage;
    }

    public void setApprovalMessage(String approvalMessage) {
        this.approvalMessage = approvalMessage;
    }

    public String getRejectionMessage() {
        return this.rejectionMessage == null || this.rejectionMessage.trim().isEmpty() ? LangManager.tr("rejection_msg.default", new Object[0]) : this.rejectionMessage;
    }

    public void setRejectionMessage(String rejectionMessage) {
        this.rejectionMessage = rejectionMessage;
    }

    public boolean isInRegion(Location location) {
        if (location.getWorld() != this.pos1.getWorld()) {
            return false;
        }
        double minX = Math.min(this.pos1.getX(), this.pos2.getX());
        double maxX = Math.max(this.pos1.getX(), this.pos2.getX());
        double minZ = Math.min(this.pos1.getZ(), this.pos2.getZ());
        double maxZ = Math.max(this.pos1.getZ(), this.pos2.getZ());
        return location.getX() >= minX && location.getX() <= maxX && location.getZ() >= minZ && location.getZ() <= maxZ;
    }

    public boolean isAllowedToEnter(String playerName) {
        if (this.status != Status.IN_PROGRESS) {
            return true;
        }
        if (this.isBuilder(playerName)) {
            return true;
        }
        switch (this.entryPermissionMode.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return this.entryWhitelist != null && this.entryWhitelist.contains(playerName);
            }
        }
        return true;
    }

    public boolean isAllowedToBuild(String playerName) {
        if (this.status != Status.IN_PROGRESS) {
            return true;
        }
        if (this.isBuilder(playerName)) {
            return true;
        }
        switch (this.buildPermissionMode.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return this.buildWhitelist != null && this.buildWhitelist.contains(playerName);
            }
        }
        return true;
    }

    public boolean isBuilder(String playerName) {
        if (playerName == null) {
            return false;
        }
        if (this.contractor != null && this.contractor.equals(playerName)) {
            return true;
        }
        return this.partners != null && this.partners.contains(playerName);
    }

    public int getRemainingDays() {
        if (this.startTime == 0L) {
            return this.duration;
        }
        long elapsed = System.currentTimeMillis() - this.startTime;
        int elapsedDays = (int)(elapsed / 86400000L);
        return Math.max(0, this.duration - elapsedDays);
    }

    public boolean addPartner(String partnerId) {
        if (this.partners.size() >= 1) {
            return false;
        }
        if (!this.partners.contains(partnerId)) {
            this.partners.add(partnerId);
            return true;
        }
        return false;
    }

    public boolean removePartner(String partnerId) {
        return this.partners.remove(partnerId);
    }

    public static enum PermissionMode {
        OPEN,
        CLOSED,
        CUSTOM;

    }

    public static enum Status {
        UNCONTRACTED("\u672a\u627f\u5305"),
        IN_PROGRESS("\u5efa\u8bbe\u4e2d"),
        COMPLETED("\u5df2\u5b8c\u5de5");

        private final String displayName;

        private Status(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

