/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.utils;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class EconomyManager {
    private final Economy economy;
    private final boolean hasXConomy;

    public EconomyManager(Economy economy) {
        this.economy = economy;
        this.hasXConomy = Bukkit.getPluginManager().getPlugin("XConomy") != null;
    }

    public boolean depositPlayer(OfflinePlayer player, double amount) {
        return this.deposit(player.getName(), amount);
    }

    public boolean deposit(String playerName, double amount) {
        if (this.hasXConomy) {
            try {
                ConsoleCommandSender console = Bukkit.getConsoleSender();
                String command = "money give " + playerName + " " + amount;
                boolean result = Bukkit.dispatchCommand((CommandSender)console, (String)command);
                if (result) {
                    return true;
                }
            }
            catch (Exception console) {
                // empty catch block
            }
        }
        if (this.economy != null) {
            try {
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
                return this.economy.depositPlayer(player, amount).transactionSuccess();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean withdrawPlayer(OfflinePlayer player, double amount) {
        return this.withdraw(player.getName(), amount);
    }

    public boolean withdraw(String playerName, double amount) {
        if (this.hasXConomy) {
            try {
                ConsoleCommandSender console = Bukkit.getConsoleSender();
                String command = "money take " + playerName + " " + amount;
                boolean result = Bukkit.dispatchCommand((CommandSender)console, (String)command);
                if (result) {
                    return true;
                }
            }
            catch (Exception console) {
                // empty catch block
            }
        }
        if (this.economy != null) {
            try {
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
                return this.economy.withdrawPlayer(player, amount).transactionSuccess();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public double getBalance(OfflinePlayer player) {
        return this.getBalance(player.getName());
    }

    public double getBalance(String playerName) {
        if (this.economy != null) {
            try {
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
                return this.economy.getBalance(player);
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public boolean hasEnough(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean hasEnough(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public String format(double amount) {
        if (this.economy != null) {
            try {
                return this.economy.format(amount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.format("%.2f", amount);
    }

    public boolean isEconomyAvailable() {
        return this.hasXConomy || this.economy != null;
    }
}

