/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ocean.easybuild.EasyBuildPlugin;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InteractiveSession {
    private static final Map<String, SessionData> activeSessions = new ConcurrentHashMap<String, SessionData>();
    private static final EasyBuildPlugin plugin = EasyBuildPlugin.getInstance();

    public static void startSession(final Player player, SessionType type, Consumer<String> callback, String commissionId) {
        final String playerName = player.getName();
        InteractiveSession.endSession(playerName);
        activeSessions.put(playerName, new SessionData(type, callback, commissionId));
        new BukkitRunnable(){

            public void run() {
                SessionData session = activeSessions.get(playerName);
                if (session != null && session.getStartTime() == activeSessions.get(playerName).getStartTime()) {
                    InteractiveSession.endSession(playerName);
                    if (player.isOnline()) {
                        player.sendMessage("\u00a7c\u8f93\u5165\u8d85\u65f6\uff0c\u5df2\u9000\u51fa\u4ea4\u4e92\u6a21\u5f0f\u3002");
                    }
                }
            }
        }.runTaskLater((Plugin)plugin, 1200L);
    }

    public static void endSession(String playerName) {
        activeSessions.remove(playerName);
    }

    public static boolean handleInput(Player player, String message) {
        String playerName = player.getName();
        SessionData session = activeSessions.get(playerName);
        if (session == null) {
            return false;
        }
        try {
            session.getCallback().accept(message);
        }
        catch (Exception e) {
            player.sendMessage("\u00a7c\u5904\u7406\u8f93\u5165\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            plugin.getLogger().warning("\u5904\u7406\u4ea4\u4e92\u5f0f\u8f93\u5165\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
        SessionData current = activeSessions.get(playerName);
        if (current == session) {
            InteractiveSession.endSession(playerName);
        }
        return true;
    }

    public static boolean isInSession(String playerName) {
        return activeSessions.containsKey(playerName);
    }

    public static SessionData getSession(String playerName) {
        return activeSessions.get(playerName);
    }

    public static class SessionData {
        private final SessionType type;
        private final Consumer<String> callback;
        private final String commissionId;
        private final long startTime;

        public SessionData(SessionType type, Consumer<String> callback, String commissionId) {
            this.type = type;
            this.callback = callback;
            this.commissionId = commissionId;
            this.startTime = System.currentTimeMillis();
        }

        public SessionType getType() {
            return this.type;
        }

        public Consumer<String> getCallback() {
            return this.callback;
        }

        public String getCommissionId() {
            return this.commissionId;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }

    public static enum SessionType {
        MODIFY_REWARD,
        TERMINATION_REASON,
        EXTENSION_REASON,
        EXTENSION_DAYS,
        SET_STATUS,
        APPROVAL_MESSAGE,
        REJECTION_MESSAGE;

    }
}

