/*
 * Decompiled with CFR 0.152.
 */
package ocean.easybuild.utils;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LangManager {
    private static Plugin plugin;
    private static String language;
    private static final Map<String, String> messages;

    public static void init(Plugin pl) {
        YamlConfiguration cfg;
        plugin = pl;
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            plugin.getDataFolder().mkdirs();
            cfg = new YamlConfiguration();
            cfg.set("language", (Object)language);
            try {
                cfg.save(configFile);
            }
            catch (Exception e) {
                plugin.getLogger().warning("\u65e0\u6cd5\u5199\u5165\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6: " + e.getMessage());
            }
        }
        cfg = YamlConfiguration.loadConfiguration((File)configFile);
        language = LangManager.normalizeLanguage(cfg.getString("language", language));
        LangManager.loadMessages(language);
    }

    private static String normalizeLanguage(String lang) {
        if (lang == null) {
            return "zh_CN";
        }
        String s = lang.trim().replace(" ", "").replace('-', '_');
        if (s.equalsIgnoreCase("zh") || s.equalsIgnoreCase("zh_cn")) {
            return "zh_CN";
        }
        if (s.equalsIgnoreCase("zh_tw") || s.equalsIgnoreCase("zh_hk")) {
            return "zh_TW";
        }
        if (s.equalsIgnoreCase("en") || s.equalsIgnoreCase("en_us")) {
            return "en_US";
        }
        if (s.equalsIgnoreCase("ru") || s.equalsIgnoreCase("ru_ru")) {
            return "ru_RU";
        }
        if (s.equalsIgnoreCase("ja") || s.equalsIgnoreCase("ja_jp")) {
            return "ja_JP";
        }
        if (s.equalsIgnoreCase("ko") || s.equalsIgnoreCase("ko_kr")) {
            return "ko_KR";
        }
        return s;
    }

    private static void loadMessages(String lang) {
        messages.clear();
        String resourcePath = "lang/messages_" + lang + ".yml";
        try (InputStream is = plugin.getResource(resourcePath);){
            if (is != null) {
                String content = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\A").next();
                YamlConfiguration yml = YamlConfiguration.loadConfiguration((Reader)new StringReader(content));
                for (String key : yml.getKeys(true)) {
                    if (!yml.isString(key)) continue;
                    messages.put(key, yml.getString(key));
                }
                plugin.getLogger().info("\u8bed\u8a00\u6587\u4ef6\u5df2\u52a0\u8f7d: " + lang);
                return;
            }
        }
        catch (Exception e) {
            plugin.getLogger().warning("\u52a0\u8f7d\u8bed\u8a00\u8d44\u6e90\u5931\u8d25: " + e.getMessage());
        }
        if (!"zh_CN".equals(lang)) {
            LangManager.loadMessages("zh_CN");
            plugin.getLogger().warning("\u672a\u627e\u5230\u8bed\u8a00 " + lang + "\uff0c\u5df2\u56de\u9000\u5230 zh_CN");
        }
    }

    public static String tr(String key, Object ... args) {
        String base = messages.getOrDefault(key, key);
        if (args != null && args.length > 0) {
            try {
                return String.format(base, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return base;
    }

    public static String getLanguage() {
        return language;
    }

    static {
        language = "zh_CN";
        messages = new HashMap<String, String>();
    }
}

