/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.api.recipes.builder;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import kono.ceu.gtconsolidate.api.recipes.properties.CoAProperty;
import kono.ceu.gtconsolidate.api.util.Logs;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;

public class CoARecipeBuilder
extends RecipeBuilder<CoARecipeBuilder> {
    public CoARecipeBuilder() {
    }

    public CoARecipeBuilder(Recipe recipe, RecipeMap<CoARecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public CoARecipeBuilder(RecipeBuilder<CoARecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    public CoARecipeBuilder copy() {
        return new CoARecipeBuilder(this);
    }

    public boolean applyProperty(@NotNull String key, Object value) {
        if (key.equals("coa_tier")) {
            this.casingTier(((Number)value).intValue());
            return true;
        }
        return super.applyProperty(key, value);
    }

    public CoARecipeBuilder casingTier(int tier) {
        if (tier < 0) {
            Logs.logger.error("Casing tier cannot be less than 0", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (tier > 14) {
            Logs.logger.error("Casing tier cannot be grater than 14", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.applyProperty(CoAProperty.getInstance(), tier);
        return this;
    }

    public int getCasingTier() {
        return this.recipePropertyStorage == null ? 0 : (Integer)this.recipePropertyStorage.getRecipePropertyValue((RecipeProperty)CoAProperty.getInstance(), (Object)0);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(CoAProperty.getInstance().getKey(), this.getCasingTier()).toString();
    }
}

