/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.blocks;

import gregtech.api.block.VariantActiveBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class BlockCoolantCasing
extends VariantActiveBlock<CasingType> {
    public BlockCoolantCasing() {
        super(Material.GLASS);
        this.setTranslationKey("coolant_casing");
        this.setHardness(5.0f);
        this.setResistance(5.0f);
        this.setSoundType(SoundType.GLASS);
        this.setHarvestLevel("pickaxe", 1);
        this.setDefaultState(this.getState(CasingType.EMPTY));
        this.useNeighborBrightness = true;
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @NotNull
    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canRenderInLayer(@NotNull IBlockState state, @NotNull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean isOpaqueCube(@NotNull IBlockState state) {
        return false;
    }

    public boolean isFullCube(@NotNull IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(@NotNull IBlockState state, IBlockAccess world, BlockPos pos, @NotNull EnumFacing side) {
        IBlockState sideState = world.getBlockState(pos.offset(side));
        return sideState.getBlock() == this ? this.getState(sideState) != this.getState(state) : super.shouldSideBeRendered(state, world, pos, side);
    }

    public static enum CasingType implements IStringSerializable
    {
        EMPTY("coolant_empty"),
        HELIUM_BASIC("helium_basic"),
        HELIUM_ADVANCED("helium_advanced"),
        HELIUM_ELITE("helium_elite"),
        CRYSTAL_QUARTZ_GLASS("crystal_quartz_glass"),
        HELIUM_3("helium_3");

        private final String name;

        private CasingType(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

