/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import gregicality.multiblocks.api.render.GCYMTextures;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.common.block.blocks.BlockLargeMultiblockCasing;
import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockCleanroomCasing;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kono.ceu.gtconsolidate.api.recipes.GTConsolidateRecipeMaps;
import kono.ceu.gtconsolidate.api.recipes.properties.CoAProperty;
import kono.ceu.gtconsolidate.api.util.GTConsolidateTraceabilityPredicate;
import kono.ceu.gtconsolidate.api.util.GTConsolidateUtil;
import kono.ceu.gtconsolidate.api.util.mixinhelper.MultiblockDisplayTextMixinHelper;
import kono.ceu.gtconsolidate.common.blocks.BlockCoACasing;
import kono.ceu.gtconsolidate.common.blocks.GTConsolidateMetaBlocks;
import kono.ceu.gtconsolidate.common.metatileentities.GTConsolidateMetaTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityCircuitFactory
extends RecipeMapMultiblockController {
    private int workTier;
    private EnergyContainerList inputHatches;

    public MetaTileEntityCircuitFactory(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES);
        this.recipeMapWorkable = new CircuitFactoryRecipeLogic(this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity mte) {
        return new MetaTileEntityCircuitFactory(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"IIIIIIIII", "A##F#F##A", "A##OOO##A", "A##OOO##A", "A#######A", "A#######A", "AA#MMM#AA", "$AAMMMAA$", "$$$MMM$$$", "$$$$$$$$$"}).aisle(new String[]{"IIIIIIIII", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABEBA$$"}).setRepeatable(2).aisle(new String[]{"IIIIIIIII", "GP#F#F#PG", "GP#DDD#PG", "GP#DDD#PG", "GP#####PG", "GP#####PG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABEBA$$"}).aisle(new String[]{"IIIIIIIII", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABEBA$$"}).setRepeatable(2).aisle(new String[]{"IIIIIIIII", "AP#F#F#PA", "AP#DDD#PA", "AP#DDD#PA", "AP#####PA", "AP#####PA", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABEBA$$"}).aisle(new String[]{"IIIIIIIII", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABEBA$$"}).setRepeatable(2).aisle(new String[]{"IIIIIIIII", "GP#F#F#PG", "GP#DDD#PG", "GP#DDD#PG", "GP#####PG", "GP#####PG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABEBA$$"}).aisle(new String[]{"IIIIIIIII", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABEBA$$"}).setRepeatable(2).aisle(new String[]{"IIIIIIIII", "A##F#F##A", "A##OOO##A", "A##OOO##A", "A#######A", "A#######A", "AA#MMM#AA", "$AAMSMAA$", "$$$MMM$$$", "$$$$$$$$$"}).where('A', MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{this.getCasingState1()})).where('B', MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.ASSEMBLY_LINE_CASING)})).where('C', MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{MetaBlocks.CLEANROOM_CASING.getState((Enum)BlockCleanroomCasing.CasingType.FILTER_CASING)})).where('D', MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{this.getCasingState2()})).where('E', MetaTileEntityCircuitFactory.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_LASER}).setMinGlobalLimited(1).setMaxGlobalLimited(4).or(MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{this.getCasingState1()}))).where('F', MetaTileEntityCircuitFactory.frames((Material[])new Material[]{Materials.TungstenSteel})).where('G', MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS)})).where('I', MetaTileEntityCircuitFactory.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).setMinGlobalLimited(1).setMaxGlobalLimited(30, 5).or(MetaTileEntityCircuitFactory.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setMaxGlobalLimited(10, 4)).or(MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{this.getCasingState1()}))).where('M', GTConsolidateTraceabilityPredicate.nonCleanMaintenance().or(MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{this.getCasingState1()}))).where('O', MetaTileEntityCircuitFactory.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS}).setMaxGlobalLimited(1).or(MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{this.getCasingState2()}))).where('P', MetaTileEntityCircuitFactory.states((IBlockState[])new IBlockState[]{MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.POLYTETRAFLUOROETHYLENE_PIPE)})).where('S', this.selfPredicate()).where('T', GTConsolidateTraceabilityPredicate.CoATieredCasing()).where('#', MetaTileEntityCircuitFactory.air()).where('$', MetaTileEntityCircuitFactory.any()).build();
    }

    public IBlockState getCasingState1() {
        return GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.ASSEMBLING_CASING);
    }

    public IBlockState getCasingState2() {
        return MetaBlocks.COMPUTER_CASING.getState((Enum)BlockComputerCasing.CasingType.ADVANCED_COMPUTER_CASING);
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle(new String[]{"AAAAAAAAA", "A##F#F##A", "A##DDD##A", "A##DOD##A", "A#######A", "A#######A", "AA#AAA#AA", "$AAAMAAA$", "$$$AAA$$$", "$$$$$$$$$"}).aisle(new String[]{"AAAAAAAAA", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABEBA$$"}).aisle(new String[]{"AAAAAAAAA", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "GP#F#F#PG", "GP#DDD#PG", "GP#DDD#PG", "GP#####PG", "GP#####PG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "AP#F#F#PA", "AP#DDD#PA", "AP#DDD#PA", "AP#####PA", "AP#####PA", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "GP#F#F#PG", "GP#DDD#PG", "GP#DDD#PG", "GP#####PG", "GP#####PG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"AAAAAAAAA", "G#######G", "G#######G", "G##DDD##G", "GB#####BG", "GB#####BG", "AA#TTT#AA", "CAAATAAAC", "$CATTTAC$", "$$ABABA$$"}).aisle(new String[]{"IIIIAiiii", "A##F#F##A", "A##DDD##A", "A##DDD##A", "A#######A", "A#######A", "AA#AAA#AA", "$AAASAAA$", "$$$AAA$$$", "$$$$$$$$$"}).where('A', this.getCasingState1()).where('B', MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.ASSEMBLY_LINE_CASING)).where('C', MetaBlocks.CLEANROOM_CASING.getState((Enum)BlockCleanroomCasing.CasingType.FILTER_CASING)).where('D', this.getCasingState2()).where('E', (MetaTileEntity)MetaTileEntities.LASER_INPUT_HATCH_256[1], EnumFacing.UP).where('F', ((BlockFrame)MetaBlocks.FRAMES.get(Materials.TungstenSteel)).getBlock(Materials.TungstenSteel)).where('G', MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS)).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[8], EnumFacing.SOUTH).where('i', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[8], EnumFacing.SOUTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : this.getCasingState1(), EnumFacing.NORTH).where('O', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[8], EnumFacing.NORTH).where('P', MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.POLYTETRAFLUOROETHYLENE_PIPE)).where('S', (MetaTileEntity)GTConsolidateMetaTileEntity.CIRCUIT_FACTORY, EnumFacing.SOUTH).where('#', Blocks.AIR.getDefaultState()).where('$', Blocks.AIR.getDefaultState());
        Arrays.stream(BlockCoACasing.CoACasingType.values()).forEach(casingType -> shapeInfo.add(builder.where('T', GTConsolidateMetaBlocks.COA_CASING.getState((Enum)casingType)).build()));
        return shapeInfo;
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        ArrayList inputs = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_LASER));
        this.inputHatches = new EnergyContainerList(inputs);
        Object type = context.get("CasingTier");
        this.workTier = type instanceof BlockCoACasing.CoACasingType ? ((BlockCoACasing.CoACasingType)((Object)type)).ordinal() : BlockCoACasing.CoACasingType.ULV.ordinal();
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        ArrayList inputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.INPUT_LASER));
        this.energyContainer = new EnergyContainerList(inputEnergy);
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        MultiblockAbility ability;
        if (sourcePart instanceof IMultiblockAbilityPart && (ability = ((IMultiblockAbilityPart)sourcePart).getAbility()) == MultiblockAbility.EXPORT_ITEMS) {
            return Textures.ADVANCED_COMPUTER_CASING;
        }
        return GCYMTextures.ASSEMBLING_CASING;
    }

    public int getWorkTier() {
        return this.workTier;
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.Builder builder = MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed());
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addEnergyUsageExactLine((long)this.recipeMapWorkable.getInfoProviderEUt()).addCustom(tl -> {
            if (this.isStructureFormed()) {
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.coa.recipe_tier", (Object[])new Object[]{GTValues.VNF[this.getWorkTier()]}));
            }
        });
        ((MultiblockDisplayTextMixinHelper)builder).addExtendedParallelLine((AbstractRecipeLogic)this.recipeMapWorkable);
        builder.addWorkingStatusLine();
        ((MultiblockDisplayTextMixinHelper)builder).addExtendedProgressLine((AbstractRecipeLogic)this.recipeMapWorkable);
        ((MultiblockDisplayTextMixinHelper)builder).addOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    public boolean canBeDistinct() {
        return true;
    }

    @NotNull
    public List<ITextComponent> getDataInfo() {
        List list = super.getDataInfo();
        list.add(new TextComponentTranslation("gtconsolidate.multiblock.coa.recipe_tier", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers((long)this.getWorkTier()), new Object[0]).setStyle(new Style().setColor(TextFormatting.RED))}));
        return list;
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.format((String)"gtconsolidate.machine.circuit_factory.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.format((String)"gtconsolidate.machine.circuit_factory.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit.energy_in.laser", (Object[])new Object[0])}));
        tooltip.add(I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit.maintenance_no_clean", (Object[])new Object[0])}));
        if (GTConsolidateUtil.isTABDown()) {
            tooltip.add(I18n.format((String)"gtconsolidate.machine.circuit_factory.tooltip.3", (Object[])new Object[0]));
            tooltip.add(I18n.format((String)"gtconsolidate.machine.circuit_factory.tooltip.4", (Object[])new Object[0]));
            tooltip.add(I18n.format((String)"gtconsolidate.machine.circuit_factory.tooltip.5", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.tab.build", (Object[])new Object[0]));
        }
    }

    private class CircuitFactoryRecipeLogic
    extends MultiblockRecipeLogic {
        public CircuitFactoryRecipeLogic(MetaTileEntityCircuitFactory mte) {
            super((RecipeMapMultiblockController)mte);
        }

        public long getMaxVoltage() {
            IEnergyContainer energyContainer = this.getEnergyContainer();
            if (!this.consumesEnergy()) {
                long voltage = energyContainer.getOutputVoltage();
                long amperage = energyContainer.getOutputAmperage();
                if (energyContainer instanceof EnergyContainerList && amperage == 1L) {
                    return GTValues.V[GTUtility.getFloorTierByVoltage((long)voltage)];
                }
                return voltage;
            }
            if (energyContainer instanceof EnergyContainerList) {
                EnergyContainerList energyList = (EnergyContainerList)energyContainer;
                long highestVoltage = energyList.getHighestInputVoltage();
                if (energyList.getNumHighestInputContainers() > 1) {
                    byte tier = GTUtility.getTierByVoltage((long)highestVoltage);
                    return GTValues.V[Math.min(tier + (energyList.getNumHighestInputContainers() - 1), 14)];
                }
                return highestVoltage;
            }
            return energyContainer.getInputVoltage();
        }

        public boolean checkRecipe(@NotNull Recipe recipe) {
            if (!super.checkRecipe(recipe)) {
                return false;
            }
            int recipeCasingTier = (Integer)recipe.getProperty((RecipeProperty)CoAProperty.getInstance(), (Object)0);
            return recipeCasingTier <= MetaTileEntityCircuitFactory.this.workTier;
        }
    }
}

