/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockLamp;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtechfoodoption.GTFOConfig;
import gregtechfoodoption.block.GTFOGlassCasing;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.recipe.GTFORecipeMaps;
import gregtechfoodoption.utils.GTFOLog;
import java.util.ArrayList;
import java.util.List;
import kono.ceu.gtconsolidate.api.util.Logs;
import kono.ceu.gtconsolidate.api.util.mixinhelper.MultiblockDisplayTextMixinHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileLargeGreenHouse
extends GCYMRecipeMapMultiblockController {
    protected static IBlockState[] GRASSES;

    public MetaTileLargeGreenHouse(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, GTFORecipeMaps.GREENHOUSE_RECIPES);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileLargeGreenHouse(this.metaTileEntityId);
    }

    public static void addGrasses() {
        GRASSES = new IBlockState[GTFOConfig.gtfoMiscConfig.greenhouseDirts.length];
        boolean errorsFound = false;
        for (int i = 0; i < GTFOConfig.gtfoMiscConfig.greenhouseDirts.length; ++i) {
            String blockStateString = GTFOConfig.gtfoMiscConfig.greenhouseDirts[i];
            try {
                String stateString;
                String[] splitBlockStateString = StringUtils.split((String)blockStateString, (String)"[");
                String blockString = splitBlockStateString[0];
                if (splitBlockStateString.length == 1) {
                    stateString = "default";
                } else if (splitBlockStateString.length == 2) {
                    stateString = StringUtils.reverse((String)StringUtils.reverse((String)StringUtils.split((String)blockStateString, (String)"[")[1]).replaceFirst("]", ""));
                } else {
                    Logs.logger.error("Block/BlockState Parsing error for \"{}\"", (Object)blockStateString);
                    errorsFound = true;
                    continue;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockString));
                if (block == null) {
                    Logs.logger.error("Block Parsing error for \"{}\". Block does not exist!", (Object)blockString);
                    errorsFound = true;
                    continue;
                }
                try {
                    IBlockState state;
                    MetaTileLargeGreenHouse.GRASSES[i] = state = CommandBase.convertArgToBlockState((Block)block, (String)stateString);
                }
                catch (NumberInvalidException e) {
                    Logs.logger.error("BlockState Parsing error {} for \"{}\". Invalid Number!", (Object)e, (Object)stateString);
                    errorsFound = true;
                }
                catch (InvalidBlockStateException e) {
                    Logs.logger.error("BlockState Parsing error {} for \"{}\". Invalid BlockState!", (Object)e, (Object)stateString);
                    errorsFound = true;
                }
                continue;
            }
            catch (Exception e) {
                GTFOLog.logger.error("Smoothable BlockState Parsing error " + e + " for \"" + blockStateString + "\"");
                errorsFound = true;
            }
        }
        if (errorsFound) {
            throw new IllegalArgumentException("One or more errors were found with the Greenhouse Blocks configuration for GTFO. Check log above.");
        }
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"CCCCCCCCC", "FGGGGGGGF", "FGGGGGGGF", "#FGGGGGF#", "#FGGGGGF#", "##FFPFF##", "####F####"}).aisle(new String[]{"CDDDDDDDC", "G#######G", "GAAAAAAAG", "#GAAAAAG#", "#GAALAAG#", "##GGPGG##", "####F####"}).setRepeatable(6).aisle(new String[]{"CDDDDDDDC", "F#######F", "FAAAAAAAF", "#FAAAAAF#", "#FAALAAF#", "##FFTFF##", "####F####"}).aisle(new String[]{"CDDDDDDDC", "G#######G", "GAAAAAAAG", "#GAAAAAG#", "#GAALAAG#", "##GGPGG##", "####F####"}).setRepeatable(6).aisle(new String[]{"CCCCSCCCC", "FGGGGGGGF", "FGGGGGGGF", "#FGGGGGF#", "#FGGGGGF#", "##FFPFF##", "####F####"}).where('A', MetaTileLargeGreenHouse.air()).where('C', MetaTileLargeGreenHouse.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID)}).setMinGlobalLimited(20).or(this.autoAbilities(true, true, true, true, true, true, false))).where('D', MetaTileLargeGreenHouse.states((IBlockState[])new IBlockState[]{Blocks.DIRT.getDefaultState(), Blocks.GRASS.getDefaultState()}).or(MetaTileLargeGreenHouse.states((IBlockState[])GRASSES))).where('F', MetaTileLargeGreenHouse.frames((Material[])new Material[]{Materials.Steel})).where('G', MetaTileLargeGreenHouse.states((IBlockState[])new IBlockState[]{GTFOMetaBlocks.GTFO_GLASS_CASING.getState((Enum)GTFOGlassCasing.CasingType.GREENHOUSE_GLASS)})).where('L', this.lampPredicate()).where('S', this.selfPredicate()).where('T', MetaTileLargeGreenHouse.tieredCasing().or(MetaTileLargeGreenHouse.states((IBlockState[])new IBlockState[]{MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE)}))).where('P', MetaTileLargeGreenHouse.states((IBlockState[])new IBlockState[]{MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE)})).where('#', MetaTileLargeGreenHouse.any()).build();
    }

    protected TraceabilityPredicate lampPredicate() {
        ArrayList<IBlockState> lamps = new ArrayList<IBlockState>();
        for (int i = 0; i < Materials.CHEMICAL_DYES.length; ++i) {
            EnumDyeColor color = EnumDyeColor.byMetadata((int)i);
            lamps.add(((BlockLamp)MetaBlocks.LAMPS.get(color)).getStateFromMeta(0));
            lamps.add(((BlockLamp)MetaBlocks.LAMPS.get(color)).getStateFromMeta(1));
            lamps.add(((BlockLamp)MetaBlocks.BORDERLESS_LAMPS.get(color)).getStateFromMeta(0));
            lamps.add(((BlockLamp)MetaBlocks.BORDERLESS_LAMPS.get(color)).getStateFromMeta(1));
        }
        return MetaTileLargeGreenHouse.states((IBlockState[])lamps.toArray(new IBlockState[0]));
    }

    public boolean canBeDistinct() {
        return true;
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.Builder builder = MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed());
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addEnergyUsageExactLine((long)this.recipeMapWorkable.getInfoProviderEUt());
        ((MultiblockDisplayTextMixinHelper)builder).addExtendedParallelLine((AbstractRecipeLogic)this.recipeMapWorkable);
        builder.addWorkingStatusLine();
        ((MultiblockDisplayTextMixinHelper)builder).addExtendedProgressLine((AbstractRecipeLogic)this.recipeMapWorkable);
        ((MultiblockDisplayTextMixinHelper)builder).addOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    public boolean isMultiblockPartWeatherResistant(@NotNull IMultiblockPart part) {
        return true;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.format((String)"gtconsolidate.machine.large_greenhouse.tooltip.1", (Object[])new Object[0]));
    }
}

