/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.mixin;

import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.chance.boost.BoostableChanceEntry;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kono.ceu.gtconsolidate.GTConsolidateConfig;
import kono.ceu.gtconsolidate.api.util.GTConsolidateUtil;
import kono.ceu.gtconsolidate.api.util.GTConsolidateValues;
import kono.ceu.gtconsolidate.api.util.mixinhelper.AbstractRecipeLogicMixinHelper;
import kono.ceu.gtconsolidate.api.util.mixinhelper.MultiblockDisplayTextMixinHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MultiblockDisplayText.Builder.class}, remap=false)
public class MultiblockDisplayTextMixin
implements MultiblockDisplayTextMixinHelper {
    @Shadow
    @Final
    private List<ITextComponent> textList;
    @Shadow
    @Final
    private boolean isStructureFormed;
    @Shadow
    @Final
    private boolean isActive;

    private MultiblockDisplayText.Builder self() {
        return (MultiblockDisplayText.Builder)this;
    }

    @Override
    @Unique
    public MultiblockDisplayText.Builder addExtendedParallelLine(AbstractRecipeLogic logic) {
        if (!this.isStructureFormed) {
            return this.self();
        }
        int maxParallel = logic.getParallelLimit();
        if (!(this.isActive && GTConsolidateConfig.feature.modifyParallelLine || maxParallel <= 1)) {
            TextComponentString parallels = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)TextFormattingUtil.formatNumbers((long)maxParallel));
            this.textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.parallel", (Object[])new Object[]{parallels}));
            return this.self();
        }
        int currentParallel = ((AbstractRecipeLogicMixinHelper)logic).getCurrentParallel();
        if (currentParallel == 0) {
            currentParallel = 1;
        }
        TextComponentTranslation current = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.LIGHT_PURPLE, (String)TextFormattingUtil.formatNumbers((long)currentParallel), (Object[])new Object[0]);
        TextComponentTranslation max = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)TextFormattingUtil.formatNumbers((long)maxParallel), (Object[])new Object[0]);
        TextComponentTranslation body = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.parallel_extended", (Object[])new Object[]{current, max});
        TextComponentTranslation hover = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.parallel_extended_hover", (Object[])new Object[0]);
        this.textList.add(TextComponentUtil.setHover((ITextComponent)body, (ITextComponent[])new ITextComponent[]{hover}));
        return this.self();
    }

    @Override
    @Unique
    public MultiblockDisplayText.Builder addExtendedProgressLine(AbstractRecipeLogic logic) {
        if (!this.isStructureFormed || !this.isActive) {
            return this.self();
        }
        int currentProgress = (int)(logic.getProgressPercent() * 100.0);
        if (!GTConsolidateConfig.feature.modifyProgressLine) {
            this.textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.progress", new Object[]{currentProgress}));
            return this.self();
        }
        double current = (double)logic.getProgress() / 20.0;
        double total = (double)logic.getMaxProgress() / 20.0;
        this.textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.progress", (Object[])new Object[]{MultiblockDisplayTextMixin.formatTime(current), MultiblockDisplayTextMixin.formatTime(total), currentProgress}));
        return this.self();
    }

    @Override
    @Unique
    public MultiblockDisplayText.Builder addOutputLine(AbstractRecipeLogic logic) {
        MetaTileEntity mte;
        Recipe recipe = logic.getPreviousRecipe();
        if (!(this.isStructureFormed && this.isActive && GTConsolidateConfig.feature.addOutputLine)) {
            return this.self();
        }
        if (recipe == null) {
            return this.self();
        }
        RecipeMap map = logic.getRecipeMap();
        Recipe trimmed = Recipe.trimRecipeOutputs((Recipe)recipe, (RecipeMap)map, (int)(mte = logic.getMetaTileEntity()).getItemOutputLimit(), (int)mte.getFluidOutputLimit());
        long eut = trimmed == null ? 0L : (long)trimmed.getEUt();
        long maxVoltage = logic.getMaximumOverclockVoltage();
        byte recipeTier = GTUtility.getTierByVoltage((long)eut);
        byte machineTier = GTConsolidateUtil.getOCTierByVoltage(maxVoltage);
        ArrayList<ItemStack> outputStack = new ArrayList<ItemStack>();
        ArrayList chancedItemOutputs = new ArrayList();
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        ArrayList chancedFluidOutputs = new ArrayList();
        outputStack.addAll((Collection<ItemStack>)trimmed.getOutputs());
        String outputs = MultiblockDisplayTextMixin.itemOutputsToString(outputStack);
        fluidStacks.addAll(trimmed.getFluidOutputs());
        String fluidOutputs = MultiblockDisplayTextMixin.fluidOutputsToString(fluidStacks);
        chancedItemOutputs.addAll(trimmed.getChancedOutputs().getChancedEntries());
        StringBuilder chancedOutputBuilder = new StringBuilder();
        for (ChancedItemOutput chancedItemOutput : chancedItemOutputs) {
            int ch = map.chanceFunction.getBoostedChance((BoostableChanceEntry)chancedItemOutput, (int)recipeTier, (int)machineTier);
            double chance = (double)ch / 100.0;
            String chanceStr = String.format("%.2f", chance);
            chancedOutputBuilder.append("\u00a7b").append(((ItemStack)chancedItemOutput.getIngredient()).func_82833_r()).append(" \u00a7f(\u00a7a").append(chanceStr).append("\u00a7f% ) x \u00a76").append(((ItemStack)chancedItemOutput.getIngredient()).func_190916_E()).append("\u00a7f, ");
        }
        String chancedOutputs = chancedOutputBuilder.toString();
        if (!chancedOutputs.isEmpty()) {
            chancedOutputs = chancedOutputs.substring(0, chancedOutputs.length() - 2);
        }
        chancedFluidOutputs.addAll(trimmed.getChancedFluidOutputs().getChancedEntries());
        StringBuilder chancedFluidOutputBuilder = new StringBuilder();
        for (ChancedFluidOutput chancedFluidOutput : chancedFluidOutputs) {
            int ch = map.chanceFunction.getBoostedChance((BoostableChanceEntry)chancedFluidOutput, (int)recipeTier, (int)machineTier);
            double chance = (double)ch / 100.0;
            String chanceStr = String.format("%.2f", chance);
            chancedFluidOutputBuilder.append("\u00a7b").append(((FluidStack)chancedFluidOutput.getIngredient()).getLocalizedName()).append(" \u00a7f(\u00a7a").append(chanceStr).append("\u00a7f %) x\u00a76 ").append(String.format("%,d", ((FluidStack)chancedFluidOutput.getIngredient()).amount)).append(" \u00a7fL, ");
        }
        String chancedFluidOutputsStr = chancedFluidOutputBuilder.toString();
        if (!chancedFluidOutputsStr.isEmpty()) {
            chancedFluidOutputsStr = chancedFluidOutputsStr.substring(0, chancedFluidOutputsStr.length() - 2);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(outputs);
        if (!outputs.isEmpty()) {
            builder.append(", ");
        }
        builder.append(chancedOutputs);
        if (!chancedOutputs.isEmpty()) {
            builder.append(", ");
        }
        builder.append(fluidOutputs);
        if (!fluidOutputs.isEmpty()) {
            builder.append(", ");
        }
        builder.append(chancedFluidOutputsStr);
        String text = builder.toString();
        if (text.length() >= 2) {
            text = text.substring(0, text.length() - 2);
        }
        TextComponentTranslation body = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.recipe_outputs", (Object[])new Object[]{text});
        TextComponentTranslation hover = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.recipe_outputs_hover", (Object[])new Object[0]);
        this.textList.add(TextComponentUtil.setHover((ITextComponent)body, (ITextComponent[])new ITextComponent[]{hover}));
        return this.self();
    }

    @Unique
    private static ITextComponent formatTime(double time) {
        if (GTConsolidateValues.timeUnit().equals("hr") && time >= 3600.0) {
            int hr = (int)(time / 3600.0);
            int min = (int)(time % 3600.0 / 60.0);
            double sec = time % 60.0;
            return TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.progress_hr", (Object[])new Object[]{hr, min, String.format("%.2f", sec)});
        }
        if ((GTConsolidateValues.timeUnit().equals("min") || GTConsolidateValues.timeUnit().equals("hr")) && time >= 60.0) {
            int min = (int)(time / 60.0);
            double sec = time % 60.0;
            return TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.progress_min", (Object[])new Object[]{min, String.format("%.2f", sec)});
        }
        return TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtconsolidate.multiblock.progress_sec", (Object[])new Object[]{String.format("%.2f", time)});
    }

    @Unique
    private static String fluidOutputsToString(List<FluidStack> stacks) {
        StringBuilder output = new StringBuilder();
        for (FluidStack stack : stacks) {
            output.append("\u00a7b").append(stack.getLocalizedName()).append(" \u00a7fx\u00a76 ").append(String.format("%,d", stack.amount)).append(" \u00a7fL, ");
        }
        String str = output.toString();
        return str.isEmpty() ? str : str.substring(0, str.length() - 2);
    }

    @Unique
    private static String itemOutputsToString(List<ItemStack> stacks) {
        StringBuilder output = new StringBuilder();
        for (ItemStack stack : stacks) {
            output.append("\u00a7b").append(stack.func_82833_r()).append(" \u00a7fx\u00a76 ").append(stack.func_190916_E()).append("\u00a7f, ");
        }
        String str = output.toString();
        return str.isEmpty() ? str : str.substring(0, str.length() - 2);
    }
}

