/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.api.util;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.PatternError;
import gregtech.api.pattern.PatternStringError;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import kono.ceu.gtconsolidate.common.blocks.BlockCoACasing;
import kono.ceu.gtconsolidate.common.blocks.GTConsolidateMetaBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class GTConsolidateTraceabilityPredicate {
    @NotNull
    public static TraceabilityPredicate manualMaintenance() {
        return ConfigHolder.machines.enableMaintenance ? MultiblockControllerBase.metaTileEntities((MetaTileEntity[])new MetaTileEntity[]{MetaTileEntities.MAINTENANCE_HATCH, MetaTileEntities.CONFIGURABLE_MAINTENANCE_HATCH}).setExactLimit(1) : new TraceabilityPredicate();
    }

    @NotNull
    public static TraceabilityPredicate energyHatchLimit(boolean allow1A, boolean allow4A) {
        return GTConsolidateTraceabilityPredicate.energyHatchLimit(allow1A, allow4A, false);
    }

    @NotNull
    public static TraceabilityPredicate energyHatchLimit(boolean allow1A, boolean allow4A, boolean allow16A) {
        return GTConsolidateTraceabilityPredicate.energyHatchLimit(allow1A, allow4A, allow16A, false);
    }

    @NotNull
    public static TraceabilityPredicate energyHatchLimit(boolean allow1A, boolean allow4A, boolean allow16A, boolean allow64A) {
        ArrayList<Object> energyHatch = new ArrayList<Object>();
        if (allow1A) {
            energyHatch.addAll(Arrays.asList(MetaTileEntities.ENERGY_INPUT_HATCH));
        }
        if (allow4A) {
            energyHatch.addAll(Arrays.asList(MetaTileEntities.ENERGY_INPUT_HATCH_4A));
        }
        if (allow16A) {
            energyHatch.addAll(Arrays.asList(MetaTileEntities.ENERGY_INPUT_HATCH_16A));
        }
        if (allow64A) {
            energyHatch.addAll(Arrays.asList(MetaTileEntities.SUBSTATION_ENERGY_INPUT_HATCH));
        }
        return MultiblockControllerBase.metaTileEntities((MetaTileEntity[])energyHatch.toArray(new MetaTileEntity[0]));
    }

    @NotNull
    public static TraceabilityPredicate CoATieredCasing() {
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState blockState = blockWorldState.getBlockState();
            Block block = blockState.getBlock();
            if (block instanceof BlockCoACasing) {
                BlockCoACasing.CoACasingType casingType = (BlockCoACasing.CoACasingType)((BlockCoACasing)blockState.getBlock()).getState(blockState);
                Object currentCasing = blockWorldState.getMatchContext().getOrPut("CasingTier", (Object)casingType);
                if (!currentCasing.equals((Object)casingType)) {
                    blockWorldState.setError((PatternError)new PatternStringError("gtconsolidate.multiblock.pattern.error.coa_casings"));
                    return false;
                }
                ((LinkedList)blockWorldState.getMatchContext().getOrPut("VABlock", new LinkedList())).add(blockWorldState.getPos());
                return true;
            }
            return false;
        }, () -> (BlockInfo[])ArrayUtils.addAll((Object[])((BlockInfo[])Arrays.stream(BlockCoACasing.CoACasingType.values()).map(type -> new BlockInfo(GTConsolidateMetaBlocks.COA_CASING.getState((Enum)type), null)).toArray(BlockInfo[]::new)), (Object[])new BlockInfo[0])).addTooltips(new String[]{"gtconsolidate.multiblock.pattern.error.coa_casings"});
    }
}

