package kono.ceu.gtconsolidate.loader;

import static gregtech.api.GTValues.*;
import static gregtech.api.unification.ore.OrePrefix.*;
import static gregtech.common.items.MetaItems.*;

import com.github.gtexpert.gtwp.common.metatileentities.GTWPMetaTileEntities;

import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtechfoodoption.machines.GTFOTileEntities;

import gregicality.multiblocks.common.metatileentities.GCYMMetaTileEntities;

import kono.ceu.gtconsolidate.api.util.Mods;
import kono.ceu.gtconsolidate.common.blocks.BlockParallelizedAssemblyLineCasing;
import kono.ceu.gtconsolidate.common.blocks.GTConsolidateMetaBlocks;
import kono.ceu.gtconsolidate.common.metatileentities.GTConsolidateMetaTileEntity;

public class MultiMachineLoader {

    private static final int sec = 20;
    private static final int min = 60 * sec;

    public static void init() {
        CEuMultiBlock();
        if (Mods.GregTechFoodOption.isModLoaded()) {
            GTFOMultiblock();
        }
        if (Mods.GTWoodProcessing.isModLoaded()) {
            GTWPMultiblock();
        }
    }

    public static void CEuMultiBlock() {
        // Adv. Fusion Reactors
        RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()
                .input(MetaTileEntities.FUSION_REACTOR[0], 16)
                .input(circuit, MarkerMaterials.Tier.LuV, 32)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[1])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_FUSION_REACTOR[0])
                .EUt(VA[UV]).duration(30 * sec).buildAndRegister();
        RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()
                .input(MetaTileEntities.FUSION_REACTOR[1], 16)
                .input(circuit, MarkerMaterials.Tier.ZPM, 32)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[1])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_FUSION_REACTOR[1])
                .EUt(VA[UV]).duration(1 * min).buildAndRegister();
        RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()
                .input(MetaTileEntities.FUSION_REACTOR[2], 16)
                .input(circuit, MarkerMaterials.Tier.UV, 32)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[1])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_FUSION_REACTOR[2])
                .EUt(VA[UV]).duration(2 * min).buildAndRegister();

        // Adv. EBF
        RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()
                .input(MetaTileEntities.ELECTRIC_BLAST_FURNACE, 4)
                .input(circuit, MarkerMaterials.Tier.IV, 8)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[0])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_EBF[0])
                .EUt(VA[LuV]).duration(1 * min).buildAndRegister();
        RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()
                .input(MetaTileEntities.ELECTRIC_BLAST_FURNACE, 16)
                .input(circuit, MarkerMaterials.Tier.LuV, 32)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[1])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_EBF[1])
                .EUt(VA[LuV]).duration(2 * min).buildAndRegister();
        RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder()
                .input(GTConsolidateMetaTileEntity.PARALLELIZED_EBF[0], 4)
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_EBF[1])
                .EUt(VA[ZPM]).duration(1 * min + 30 * sec).buildAndRegister();

        // Adv. VF
        RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()
                .input(MetaTileEntities.VACUUM_FREEZER, 4)
                .input(circuit, MarkerMaterials.Tier.IV, 8)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[0])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_VF[0])
                .EUt(VA[LuV]).duration(1 * min).buildAndRegister();
        RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()
                .input(MetaTileEntities.VACUUM_FREEZER, 16)
                .input(circuit, MarkerMaterials.Tier.LuV, 32)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[1])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_VF[1])
                .EUt(VA[LuV]).duration(2 * min).buildAndRegister();
        RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder()
                .input(GTConsolidateMetaTileEntity.PARALLELIZED_VF[0], 4)
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_VF[1])
                .EUt(VA[ZPM]).duration(1 * min + 30 * sec).buildAndRegister();

        // Adv, Assembly Line
        RecipeMaps.ASSEMBLY_LINE_RECIPES.recipeBuilder()
                .input(MetaTileEntities.ASSEMBLY_LINE, 4)
                .inputs(GTConsolidateMetaBlocks.PARALLELIZED_ASSEMBLY_LINE_CASING
                        .getItemVariant(BlockParallelizedAssemblyLineCasing.ParallelizedAssemblyLineCasingType.CONTROL,
                                4))
                .input(circuit, MarkerMaterials.Tier.UV, 2)
                .input(ROBOT_ARM_LuV)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[0])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_ASSEMBLY_LINE[0])
                .EUt(VA[UV]).duration(1 * min).buildAndRegister();
        RecipeMaps.ASSEMBLY_LINE_RECIPES.recipeBuilder()
                .input(MetaTileEntities.ASSEMBLY_LINE, 16)
                .inputs(GTConsolidateMetaBlocks.PARALLELIZED_ASSEMBLY_LINE_CASING
                        .getItemVariant(BlockParallelizedAssemblyLineCasing.ParallelizedAssemblyLineCasingType.CONTROL,
                                4))
                .input(circuit, MarkerMaterials.Tier.UHV, 2)
                .input(ROBOT_ARM_ZPM)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[1])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_ASSEMBLY_LINE[1])
                .EUt(VA[UHV]).duration(1 * min).buildAndRegister();
        RecipeMaps.ASSEMBLY_LINE_RECIPES.recipeBuilder()
                .input(MetaTileEntities.ASSEMBLY_LINE, 64)
                .inputs(GTConsolidateMetaBlocks.PARALLELIZED_ASSEMBLY_LINE_CASING
                        .getItemVariant(BlockParallelizedAssemblyLineCasing.ParallelizedAssemblyLineCasingType.CONTROL,
                                4))
                .input(circuit, MarkerMaterials.Tier.UHV, 8)
                .input(ROBOT_ARM_UV)
                .input(GCYMMetaTileEntities.PARALLEL_HATCH[2])
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_ASSEMBLY_LINE[2])
                .EUt(VA[UEV]).duration(1 * min).buildAndRegister();

        // CoA
        RecipeMaps.ASSEMBLY_LINE_RECIPES.recipeBuilder()
                .input(MetaTileEntities.ASSEMBLY_LINE)
                .input(TOOL_DATA_MODULE, 4)
                .input(ROBOT_ARM_LV, 4)
                .input(ROBOT_ARM_MV, 4)
                .input(ROBOT_ARM_HV, 4)
                .input(ROBOT_ARM_EV, 4)
                .input(ROBOT_ARM_IV, 4)
                .input(ROBOT_ARM_LuV, 4)
                .input(ROBOT_ARM_ZPM, 4)
                .input(ROBOT_ARM_UV, 4)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * 64))
                .fluidInputs(Materials.Lubricant.getFluid(10000))
                .output(GTConsolidateMetaTileEntity.COMPONENT_ASSEMBLY_LINE)
                .EUt(VA[LuV]).duration(2 * min).buildAndRegister();

        // Adv. Multi Smelter
        RecipeMaps.ASSEMBLY_LINE_RECIPES.recipeBuilder()
                .input(MetaTileEntities.ELECTRIC_FURNACE[IV], 3)
                .input(circuit, MarkerMaterials.Tier.LuV, 6)
                .inputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF))
                .input(cableGtSingle, Materials.Platinum, 4)
                .scannerResearch(b -> b
                        .researchStack(MetaTileEntities.MULTI_FURNACE.getStackForm())
                        .EUt(VA[IV]).duration(1 * min))
                .output(GTConsolidateMetaTileEntity.MEGA_FURNACE)
                .EUt(VA[LuV]).duration((90 * sec)).buildAndRegister();
    }

    public static void GTFOMultiblock() {
        RecipeMaps.ASSEMBLY_LINE_RECIPES.recipeBuilder()
                .input(MetaTileEntities.HULL[IV])
                .input(ELECTRIC_PUMP_IV, 2)
                .input(circuit, MarkerMaterials.Tier.LuV, 4)
                .input(frameGt, Materials.Steel)
                .input(plate, Materials.VanadiumGallium, 6)
                .scannerResearch(b -> b
                        .researchStack(GTFOTileEntities.GREENHOUSE.getStackForm())
                        .duration(30 * sec).EUt(VA[IV]))
                .output(GTConsolidateMetaTileEntity.LARGE_GREENHOUSE)
                .duration(90 * sec).EUt(VA[IV]).buildAndRegister();
    }

    public static void GTWPMultiblock() {
        RecipeMaps.ASSEMBLY_LINE_RECIPES.recipeBuilder()
                .input(screw, Materials.TungstenCarbide, 4)
                .input(toolHeadBuzzSaw, Materials.TungstenCarbide)
                .input(ELECTRIC_MOTOR_IV, 4)
                .input(MetaTileEntities.HULL[IV])
                .input(circuit, MarkerMaterials.Tier.IV, 4)
                .input(CONVEYOR_MODULE_IV, 2)
                .scannerResearch(b -> b
                        .researchStack(GTWPMetaTileEntities.SAWMILL.getStackForm())
                        .EUt(VA[IV]).duration(30 * sec))
                .output(GTConsolidateMetaTileEntity.PARALLELIZED_SAWMILL)
                .EUt(VA[IV]).duration(90 * sec).buildAndRegister();
    }
}
