/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.loader.handlers;

import com.github.gtexpert.core.api.unification.material.GTEMaterials;
import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregicality.multiblocks.api.recipes.GCYMRecipeMaps;
import gregicality.multiblocks.api.unification.GCYMMaterialFlags;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.recipes.GTRecipeHandler;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import java.util.ArrayList;
import kono.ceu.gtconsolidate.api.recipes.GTConsolidateRecipeMaps;
import kono.ceu.gtconsolidate.api.util.Mods;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TurboBlastFurnaceLoader {
    public static void generate() {
        if (Mods.GregTechExpertCore.isModLoaded()) {
            ArrayList materials = new ArrayList(GregTechAPI.materialManager.getRegisteredMaterials());
            materials.forEach(TurboBlastFurnaceLoader::alloyBlastFurnaceExtended);
            ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE.recipeBuilder()).input(OrePrefix.dust, Materials.Redstone)).input(OrePrefix.dust, Materials.Sulfur)).fluidInputs(new FluidStack[]{Materials.Blaze.getFluid(2304)})).fluidInputs(new FluidStack[]{Materials.Argon.getFluid(FluidStorageKeys.GAS, 200)})).circuitMeta(15)).blastFurnaceTemp(7200).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 1000)})).EUt(GTValues.VA[6])).duration(200)).buildAndRegister();
            ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE.recipeBuilder()).input(OrePrefix.dust, Materials.Redstone)).input(OrePrefix.dust, Materials.Sulfur)).fluidInputs(new FluidStack[]{Materials.Blaze.getFluid(2304)})).circuitMeta(5)).blastFurnaceTemp(7200).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 1000)})).EUt(GTValues.VA[6])).duration(1200)).buildAndRegister();
        }
    }

    public static void removeConfitRecipe() {
        GTRecipeHandler.removeRecipesByInputs(GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Steel)});
        GTRecipeHandler.removeRecipesByInputs(GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Iron, (int)4), OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Carbon)});
        GTRecipeHandler.removeRecipesByInputs(GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.WroughtIron, (int)4), OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Carbon)});
        GTRecipeHandler.removeRecipesByInputs(GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Yttrium)});
    }

    public static void reAddRecipe() {
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE.recipeBuilder()).input(OrePrefix.dust, Materials.Steel)).output(OrePrefix.ingot, Materials.Steel)).circuitMeta(1)).blastFurnaceTemp(1000).duration(800)).EUt(GTValues.VA[2])).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE.recipeBuilder()).input(OrePrefix.dust, Materials.Iron, 4)).input(OrePrefix.dust, Materials.Carbon)).output(OrePrefix.ingot, Materials.Steel, 4)).chancedOutput(OrePrefix.dust, Materials.Ash, 3333, 0)).circuitMeta(1)).blastFurnaceTemp(2000).duration(250)).EUt(GTValues.VA[4])).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE.recipeBuilder()).input(OrePrefix.dust, Materials.WroughtIron, 4)).input(OrePrefix.dust, Materials.Carbon)).output(OrePrefix.ingot, Materials.Steel, 4)).chancedOutput(OrePrefix.dust, Materials.Ash, 3333, 0)).circuitMeta(1)).blastFurnaceTemp(2000).duration(50)).EUt(GTValues.VA[4])).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE.recipeBuilder()).input(OrePrefix.dust, Materials.Yttrium)).output(OrePrefix.ingot, Materials.Yttrium)).circuitMeta(1)).blastFurnaceTemp(1799).duration(3202)).EUt(GTValues.VA[2])).buildAndRegister();
    }

    private static void alloyBlastFurnaceExtended(Material material) {
        if (material.hasFlag(GCYMMaterialFlags.NO_ALLOY_BLAST_RECIPES)) {
            return;
        }
        if (!material.hasProperty(GCYMPropertyKey.ALLOY_BLAST)) {
            return;
        }
        Fluid molten = material.getFluid(GCYMFluidStorageKeys.MOLTEN);
        if (molten == null) {
            return;
        }
        BlastProperty property = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        TurboBlastFurnaceLoader.produce(material, property);
    }

    private static void produce(@NotNull Material material, @NotNull BlastProperty blastProperty) {
        int componentAmount = material.getMaterialComponents().size();
        if (componentAmount < 2) {
            return;
        }
        Fluid molten = material.getFluid(GCYMFluidStorageKeys.MOLTEN);
        if (molten == null) {
            return;
        }
        BlastRecipeBuilder builder = TurboBlastFurnaceLoader.createBuilder(blastProperty, material);
        int outputAmount = TurboBlastFurnaceLoader.addInputs(material, (RecipeBuilder<BlastRecipeBuilder>)builder);
        if (outputAmount <= 0) {
            return;
        }
        TurboBlastFurnaceLoader.buildRecipes(blastProperty, molten, outputAmount, componentAmount, (RecipeBuilder<BlastRecipeBuilder>)builder);
    }

    @NotNull
    private static BlastRecipeBuilder createBuilder(@NotNull BlastProperty property, @NotNull Material material) {
        BlastRecipeBuilder builder = (BlastRecipeBuilder)GCYMRecipeMaps.ALLOY_BLAST_RECIPES.recipeBuilder();
        int duration = property.getDurationOverride();
        if (duration < 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)property.getBlastTemperature() / 100L));
        }
        builder.duration(duration);
        int EUt = property.getEUtOverride();
        if (EUt < 0) {
            EUt = GTValues.VA[2];
        }
        builder.EUt(EUt);
        return builder.blastFurnaceTemp(property.getBlastTemperature());
    }

    private static int addInputs(@NotNull Material material, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        int outputAmount = 0;
        int fluidAmount = 0;
        int dustAmount = 0;
        for (MaterialStack materialStack : material.getMaterialComponents()) {
            Material msMat = materialStack.material;
            int msAmount = (int)materialStack.amount;
            if (msMat.hasProperty(PropertyKey.DUST)) {
                if (dustAmount >= 9) {
                    return -1;
                }
                ++dustAmount;
                builder.input(OrePrefix.dust, msMat, msAmount);
            } else if (msMat.hasProperty(PropertyKey.FLUID)) {
                if (fluidAmount >= 2) {
                    return -1;
                }
                ++fluidAmount;
                builder.fluidInputs(new FluidStack[]{msMat.getFluid(1000 * msAmount)});
            } else {
                return -1;
            }
            outputAmount += msAmount;
        }
        return outputAmount;
    }

    private static void buildRecipes(@NotNull BlastProperty property, @NotNull Fluid molten, int outputAmount, int componentAmount, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        builder.fluidOutputs(new FluidStack[]{new FluidStack(molten, 144 * outputAmount)});
        int duration = builder.getDuration() * outputAmount * 3 / 4;
        if (property.getGasTier() != null) {
            RecipeBuilder builderGas = builder.copy();
            ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)builderGas.notConsumable((GTRecipeInput)new IntCircuitIngredient(TurboBlastFurnaceLoader.getGasCircuitNum(componentAmount)))).fluidInputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 200)})).duration((int)((double)duration * 0.67 * 0.5))).buildAndRegister();
        }
        ((BlastRecipeBuilder)((BlastRecipeBuilder)builder.notConsumable((GTRecipeInput)new IntCircuitIngredient(TurboBlastFurnaceLoader.getCircuitNum(componentAmount)))).duration(duration)).buildAndRegister();
    }

    private static int getCircuitNum(int componentAmount) {
        return componentAmount;
    }

    private static int getGasCircuitNum(int componentAmount) {
        return componentAmount + 11;
    }
}

