/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.loader.handlers;

import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregicality.multiblocks.api.recipes.GCYMRecipeMaps;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.items.MetaItems;
import java.util.HashMap;
import kono.ceu.gtconsolidate.api.recipes.GTConsolidateRecipeMaps;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class AbsoluteFreezerLoader {
    public static void register() {
        AbsoluteFreezerLoader.coolingEBF();
        AbsoluteFreezerLoader.coolingABS();
        AbsoluteFreezerLoader.coolingLiquid();
    }

    public static void coolingEBF() {
        for (Material mat : GregTechAPI.materialManager.getRegisteredMaterials()) {
            if (!OrePrefix.ingotHot.doGenerateItem(mat)) continue;
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTConsolidateRecipeMaps.ABSOLUTE_VACUUM_RECIPE.recipeBuilder()).input(OrePrefix.ingotHot, mat)).output(OrePrefix.ingot, mat)).buildAndRegister();
        }
    }

    public static void coolingABS() {
        HashMap<Fluid, Material> liquidStack = new HashMap<Fluid, Material>();
        for (Material mat : GregTechAPI.materialManager.getRegisteredMaterials()) {
            if (mat.hasFlag(MaterialFlags.IS_MAGNETIC) || !mat.hasProperty(PropertyKey.INGOT) || !mat.hasFluid()) continue;
            if (mat.getFluid(GCYMFluidStorageKeys.MOLTEN) != null) {
                liquidStack.put(mat.getFluid(GCYMFluidStorageKeys.MOLTEN), mat);
                continue;
            }
            if (mat.getFluid(FluidStorageKeys.LIQUID) == null) continue;
            liquidStack.put(mat.getFluid(FluidStorageKeys.LIQUID), mat);
        }
        GCYMRecipeMaps.ALLOY_BLAST_RECIPES.onRecipeBuild(blastRecipeBuilder -> {
            for (FluidStack stack : blastRecipeBuilder.getFluidOutputs()) {
                Fluid fluid = stack.getFluid();
                if (!liquidStack.containsKey(fluid)) continue;
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTConsolidateRecipeMaps.ABSOLUTE_VACUUM_RECIPE.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).fluidInputs(new FluidStack[]{new FluidStack(fluid, 144)})).output(OrePrefix.ingot, (Material)liquidStack.get(fluid))).buildAndRegister();
            }
        });
    }

    public static void coolingLiquid() {
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            if (!material.hasProperty(PropertyKey.FLUID) || material.getFluid(FluidStorageKeys.GAS) == null || material.getFluid(FluidStorageKeys.LIQUID) == null) continue;
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTConsolidateRecipeMaps.ABSOLUTE_VACUUM_RECIPE.recipeBuilder()).fluidInputs(new FluidStack[]{material.getFluid(FluidStorageKeys.GAS, 10000)})).fluidOutputs(new FluidStack[]{material.getFluid(FluidStorageKeys.LIQUID, 10000)})).buildAndRegister();
        }
        HashMap<Material, Material> coolingMap = new HashMap<Material, Material>();
        coolingMap.put(Materials.Air, Materials.LiquidAir);
        coolingMap.put(Materials.NetherAir, Materials.LiquidNetherAir);
        coolingMap.put(Materials.EnderAir, Materials.LiquidEnderAir);
        for (Material material : coolingMap.keySet()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTConsolidateRecipeMaps.ABSOLUTE_VACUUM_RECIPE.recipeBuilder()).fluidInputs(new FluidStack[]{material.getFluid(10000)})).fluidOutputs(new FluidStack[]{((Material)coolingMap.get(material)).getFluid(10000)})).buildAndRegister();
        }
    }
}

