/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import gregicality.multiblocks.api.capability.IParallelMultiblock;
import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregtech.api.GregTechAPI;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.IHeatingCoil;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.recipes.recipeproperties.TemperatureProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.core.sound.GTSoundEvents;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kono.ceu.gtconsolidate.api.util.GTConsolidateTraceabilityPredicate;
import kono.ceu.gtconsolidate.api.util.GTConsolidateValues;
import kono.ceu.gtconsolidate.client.GTConsolidateTextures;
import kono.ceu.gtconsolidate.common.metatileentities.GTConsolidateMetaTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityParallelizedEBF
extends RecipeMapMultiblockController
implements IHeatingCoil,
IParallelMultiblock {
    private final int maxParallel;
    private int blastFurnaceTemperature;
    public int height;

    public MetaTileEntityParallelizedEBF(ResourceLocation metaTileEntity, int maxParallel) {
        super(metaTileEntity, RecipeMaps.BLAST_RECIPES);
        this.recipeMapWorkable = new AdvancedEBFRecipeLogic(this);
        this.maxParallel = maxParallel;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityParallelizedEBF(this.metaTileEntityId, this.maxParallel);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP).aisle(new String[]{"XSX", "XXX", "XXX"}).aisle(new String[]{"CCC", "C#C", "CCC"}).aisle(new String[]{"CCC", "CIC", "CCC"}).setRepeatable(1, 4).aisle(new String[]{"XXX", "XMX", "XXX"}).where('S', this.selfPredicate()).where('X', MetaTileEntityParallelizedEBF.states((IBlockState[])new IBlockState[]{this.modeCasingState()}).setMinGlobalLimited(9).or(this.autoAbilities(false, false, true, true, true, true, false)).or(GTConsolidateTraceabilityPredicate.energyHatchLimit(false, this.maxParallel == 4, true).setMinGlobalLimited(1).setMaxGlobalLimited(2)).or(GTConsolidateTraceabilityPredicate.manualMaintenance())).where('M', MetaTileEntityParallelizedEBF.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('C', MetaTileEntityParallelizedEBF.heatingCoils()).where('I', this.indicatorPredicate()).where('#', MetaTileEntityParallelizedEBF.states((IBlockState[])new IBlockState[]{this.modeBlockState()})).build();
    }

    public TraceabilityPredicate indicatorPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            if (MetaTileEntityParallelizedEBF.states((IBlockState[])new IBlockState[]{this.modeBlockState()}).test(blockWorldState)) {
                blockWorldState.getMatchContext().increment("coilLayer", 1);
                return true;
            }
            return false;
        });
    }

    public IBlockState modeCasingState() {
        IBlockState iBlockState;
        switch (GTConsolidateValues.mode()) {
            case "NORMAL": {
                if (this.maxParallel == 4) {
                    iBlockState = MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING);
                    break;
                }
                iBlockState = MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING_MK2);
                break;
            }
            case "HARD": {
                if (this.maxParallel == 4) {
                    iBlockState = MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING_MK2);
                    break;
                }
                iBlockState = MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING_MK3);
                break;
            }
            default: {
                iBlockState = this.maxParallel == 4 ? MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF) : MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING);
            }
        }
        IBlockState state = iBlockState;
        return state;
    }

    public IBlockState modeBlockState() {
        IBlockState iBlockState;
        switch (GTConsolidateValues.mode()) {
            case "NORMAL": {
                if (this.maxParallel == 4) {
                    iBlockState = MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.TUNGSTENSTEEL_PIPE);
                    break;
                }
                iBlockState = MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL);
                break;
            }
            case "HARD": {
                if (this.maxParallel == 4) {
                    iBlockState = MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL);
                    break;
                }
                iBlockState = MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_COIL);
                break;
            }
            default: {
                iBlockState = this.maxParallel == 4 ? Blocks.field_150350_a.func_176223_P() : MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.TUNGSTENSTEEL_PIPE);
            }
        }
        IBlockState state = iBlockState;
        return state;
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle(new String[]{"EEM", "CCC", "CCC", "XXX"}).aisle(new String[]{"FXD", "C#C", "C#C", "XHX"}).aisle(new String[]{"ISO", "CCC", "CCC", "XXX"}).where('X', this.modeCasingState()).where('S', (MetaTileEntity)GTConsolidateMetaTileEntity.PARALLELIZED_EBF[this.maxParallel == 4 ? 0 : 1], EnumFacing.SOUTH).where('#', this.modeBlockState()).where('E', (MetaTileEntity)(this.maxParallel == 4 ? MetaTileEntities.ENERGY_INPUT_HATCH_4A[1] : MetaTileEntities.ENERGY_INPUT_HATCH_16A[0]), EnumFacing.NORTH).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[1], EnumFacing.SOUTH).where('O', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[1], EnumFacing.SOUTH).where('F', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.WEST).where('D', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[1], EnumFacing.EAST).where('H', (MetaTileEntity)MetaTileEntities.MUFFLER_HATCH[1], EnumFacing.UP).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : this.modeCasingState(), EnumFacing.NORTH);
        GregTechAPI.HEATING_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IHeatingCoilBlockStats)entry.getValue()).getTier())).forEach(entry -> shapeInfo.add(builder.where('C', (IBlockState)entry.getKey()).build()));
        return shapeInfo;
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.height = (Integer)context.getOrDefault("coilLayer", (Object)1);
        Object type = context.get("CoilType");
        this.blastFurnaceTemperature = type instanceof IHeatingCoilBlockStats ? ((IHeatingCoilBlockStats)type).getCoilTemperature() : BlockWireCoil.CoilType.CUPRONICKEL.getCoilTemperature();
        this.blastFurnaceTemperature += 100 * Math.max(0, GTUtility.getFloorTierByVoltage((long)this.getEnergyContainer().getInputVoltage()) - 2);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.blastFurnaceTemperature = 0;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        return this.blastFurnaceTemperature >= (Integer)recipe.getProperty((RecipeProperty)TemperatureProperty.getInstance(), (Object)0);
    }

    public boolean isParallel() {
        return true;
    }

    private int increaseFactor() {
        return this.maxParallel == 4 ? 1 : 4;
    }

    public int getMaxParallel() {
        return this.height * this.increaseFactor();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("height", this.height);
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.height = data.func_74762_e("height");
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.height);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.height = buf.readInt();
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString heatString = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.RED, (String)(TextFormattingUtil.formatNumbers((long)this.blastFurnaceTemperature) + "K"));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{heatString}));
            }
        }).addParallelsLine(this.getMaxParallel()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        SimpleOverlayRenderer simpleOverlayRenderer;
        switch (GTConsolidateValues.mode()) {
            case "NORMAL": {
                if (this.maxParallel == 4) {
                    simpleOverlayRenderer = GTConsolidateTextures.FUSION_CASING;
                    break;
                }
                simpleOverlayRenderer = GTConsolidateTextures.FUSION_CASING_MK2;
                break;
            }
            case "HARD": {
                if (this.maxParallel == 4) {
                    simpleOverlayRenderer = GTConsolidateTextures.FUSION_CASING_MK2;
                    break;
                }
                simpleOverlayRenderer = GTConsolidateTextures.FUSION_CASING_MK3;
                break;
            }
            default: {
                simpleOverlayRenderer = this.maxParallel == 4 ? Textures.HEAT_PROOF_CASING : GTConsolidateTextures.FUSION_CASING;
            }
        }
        SimpleOverlayRenderer renderer = simpleOverlayRenderer;
        return renderer;
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_ebf.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.parallel", (Object[])new Object[]{this.maxParallel}));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_ebf.tooltip2", (Object[])new Object[]{this.increaseFactor()}));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{this.maxParallel == 4 ? I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit.energy_in.4and16", (Object[])new Object[0]) : I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit.energy_in.16", (Object[])new Object[0])}));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit.manual_maintenance", (Object[])new Object[0])}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.3", (Object[])new Object[0]));
    }

    public int getCurrentTemperature() {
        return this.blastFurnaceTemperature;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.BLAST_FURNACE_OVERLAY;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @NotNull
    public List<ITextComponent> getDataInfo() {
        List list = super.getDataInfo();
        list.add(new TextComponentTranslation("gregtech.multiblock.blast_furnace.max_temperature", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers((long)this.blastFurnaceTemperature) + "K", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
        return list;
    }

    private static class AdvancedEBFRecipeLogic
    extends GCYMMultiblockRecipeLogic {
        public AdvancedEBFRecipeLogic(RecipeMapMultiblockController metaTileEntity) {
            super(metaTileEntity);
        }

        protected int @NotNull [] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int duration, int maxOverclocks) {
            return OverclockingLogic.heatingCoilOverclockingLogic((int)Math.abs(recipeEUt), (long)maxVoltage, (int)duration, (int)maxOverclocks, (int)((IHeatingCoil)this.metaTileEntity).getCurrentTemperature(), (int)((Integer)propertyStorage.getRecipePropertyValue((RecipeProperty)TemperatureProperty.getInstance(), (Object)0)));
        }
    }
}

