/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import gregicality.multiblocks.api.capability.IParallelMultiblock;
import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IndicatorImageWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.recipeproperties.FusionEUToStartProperty;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.api.util.interpolate.Eases;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.shader.postprocessing.BloomEffect;
import gregtech.client.shader.postprocessing.BloomType;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.EffectRenderContext;
import gregtech.client.utils.IBloomEffect;
import gregtech.client.utils.RenderBufferHelper;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleSupplier;
import kono.ceu.gtconsolidate.common.metatileentities.GTConsolidateMetaTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityParallelizedFusionReactor
extends RecipeMapMultiblockController
implements IFastRenderMetaTileEntity,
IBloomEffect,
IParallelMultiblock {
    protected static final int NO_COLOR = 0;
    private final int tier;
    private EnergyContainerList inputEnergyContainers;
    private long heat = 0L;
    private int fusionRingColor = 0;
    private final FusionProgressSupplier progressBarSupplier;
    @SideOnly(value=Side.CLIENT)
    private boolean registeredBloomRenderTicket;

    public MetaTileEntityParallelizedFusionReactor(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, RecipeMaps.FUSION_RECIPES);
        this.recipeMapWorkable = new ParallelizedFusionRecipeLogic(this);
        this.tier = tier;
        this.energyContainer = new EnergyContainerHandler((MetaTileEntity)this, 0L, 0L, 0L, 0L, 0L){

            @NotNull
            public String getName() {
                return "EnergyContainerInternal";
            }
        };
        this.progressBarSupplier = new FusionProgressSupplier();
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityParallelizedFusionReactor(this.metaTileEntityId, this.tier);
    }

    public int getMaxParallel() {
        List energyInputs = this.getAbilities(MultiblockAbility.INPUT_ENERGY);
        return energyInputs.size();
    }

    public boolean isParallel() {
        return true;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"###############", "######OGO######", "###############"}).aisle(new String[]{"######ICI######", "####GGAAAGG####", "######ICI######"}).aisle(new String[]{"####CC###CC####", "###EAAOGOAAE###", "####CC###CC####"}).aisle(new String[]{"###C#######C###", "##EKEG###GEKE##", "###C#######C###"}).aisle(new String[]{"##C#########C##", "#GAE#######EAG#", "##C#########C##"}).aisle(new String[]{"##C#########C##", "#GAG#######GAG#", "##C#########C##"}).aisle(new String[]{"#I###########I#", "OAO#########OAO", "#I###########I#"}).aisle(new String[]{"#C###########C#", "GAG#########GAG", "#C###########C#"}).aisle(new String[]{"#I###########I#", "OAO#########OAO", "#I###########I#"}).aisle(new String[]{"##C#########C##", "#GAG#######GAG#", "##C#########C##"}).aisle(new String[]{"##C#########C##", "#GAE#######EAG#", "##C#########C##"}).aisle(new String[]{"###C#######C###", "##EKEG###GEKE##", "###C#######C###"}).aisle(new String[]{"####CC###CC####", "###EAAOGOAAE###", "####CC###CC####"}).aisle(new String[]{"######ICI######", "####GGAAAGG####", "######ICI######"}).aisle(new String[]{"###############", "######OSO######", "###############"}).where('S', this.selfPredicate()).where('G', MetaTileEntityParallelizedFusionReactor.states((IBlockState[])new IBlockState[]{this.getCasingState(), this.getGlassState()})).where('E', MetaTileEntityParallelizedFusionReactor.states((IBlockState[])new IBlockState[]{this.getCasingState(), this.getGlassState()}).or(MetaTileEntityParallelizedFusionReactor.metaTileEntities((MetaTileEntity[])((MetaTileEntity[])Arrays.stream(MetaTileEntities.ENERGY_INPUT_HATCH_16A).filter(mte -> mte != null && this.tier - 2 <= mte.getTier() && mte.getTier() <= 8).toArray(MetaTileEntity[]::new))).setMinGlobalLimited(1).setPreviewCount(16))).where('C', MetaTileEntityParallelizedFusionReactor.states((IBlockState[])new IBlockState[]{this.getCasingState()})).where('K', MetaTileEntityParallelizedFusionReactor.states((IBlockState[])new IBlockState[]{this.getCoilState()})).where('O', MetaTileEntityParallelizedFusionReactor.states((IBlockState[])new IBlockState[]{this.getCasingState(), this.getGlassState()}).or(MetaTileEntityParallelizedFusionReactor.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS}))).where('A', MetaTileEntityParallelizedFusionReactor.air()).where('I', MetaTileEntityParallelizedFusionReactor.states((IBlockState[])new IBlockState[]{this.getCasingState()}).or(MetaTileEntityParallelizedFusionReactor.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setMinGlobalLimited(2))).where('#', MetaTileEntityParallelizedFusionReactor.any()).build();
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        int t = this.tier - 8;
        ArrayList<MultiblockShapeInfo> shapeInfos = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder baseBuilder = MultiblockShapeInfo.builder().aisle(new String[]{"###############", "######WGW######", "###############"}).aisle(new String[]{"######DCD######", "####GG###GG####", "######UCU######"}).aisle(new String[]{"####CC###CC####", "###w##EGE##s###", "####CC###CC####"}).aisle(new String[]{"###C#######C###", "##nKeG###GeKn##", "###C#######C###"}).aisle(new String[]{"##C#########C##", "#G#s#######w#G#", "##C#########C##"}).aisle(new String[]{"##C#########C##", "#G#G#######G#G#", "##C#########C##"}).aisle(new String[]{"#D###########D#", "N#S#########N#S", "#U###########U#"}).aisle(new String[]{"#C###########C#", "G#G#########G#G", "#C###########C#"}).aisle(new String[]{"#D###########D#", "N#S#########N#S", "#U###########U#"}).aisle(new String[]{"##C#########C##", "#G#G#######G#G#", "##C#########C##"}).aisle(new String[]{"##C#########C##", "#G#s#######w#G#", "##C#########C##"}).aisle(new String[]{"###C#######C###", "##eKnG###GnKe##", "###C#######C###"}).aisle(new String[]{"####CC###CC####", "###w##WGW##s###", "####CC###CC####"}).aisle(new String[]{"######DCD######", "####GG###GG####", "######UCU######"}).aisle(new String[]{"###############", "######EME######", "###############"}).where('M', (MetaTileEntity)GTConsolidateMetaTileEntity.PARALLELIZED_FUSION_REACTOR[t], EnumFacing.SOUTH).where('C', this.getCasingState()).where('G', MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS)).where('K', this.getCoilState()).where('W', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[6 + t], EnumFacing.NORTH).where('E', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[6 + t], EnumFacing.SOUTH).where('S', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[6 + t], EnumFacing.EAST).where('N', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[6 + t], EnumFacing.WEST).where('w', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH_16A[t + 1], EnumFacing.WEST).where('e', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH_16A[t + 1], EnumFacing.SOUTH).where('s', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH_16A[t + 1], EnumFacing.EAST).where('n', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH_16A[t + 1], EnumFacing.NORTH).where('U', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[6 + t], EnumFacing.UP).where('D', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[6 + t], EnumFacing.DOWN).where('#', Blocks.field_150350_a.func_176223_P());
        shapeInfos.add(baseBuilder.shallowCopy().where('G', this.getCasingState()).build());
        shapeInfos.add(baseBuilder.build());
        return shapeInfos;
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (this.recipeMapWorkable.isActive()) {
            return Textures.ACTIVE_FUSION_TEXTURE;
        }
        return Textures.FUSION_TEXTURE;
    }

    private IBlockState getGlassState() {
        return MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS);
    }

    private IBlockState getCasingState() {
        if (this.tier == 8) {
            return MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING);
        }
        if (this.tier == 9) {
            return MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING_MK2);
        }
        return MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING_MK3);
    }

    private IBlockState getCoilState() {
        if (this.tier == 8) {
            return MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL);
        }
        return MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_COIL);
    }

    protected int getFusionRingColor() {
        return this.fusionRingColor;
    }

    protected boolean hasFusionRingColor() {
        return this.fusionRingColor != 0;
    }

    protected void setFusionRingColor(int fusionRingColor) {
        if (this.fusionRingColor != fusionRingColor) {
            this.fusionRingColor = fusionRingColor;
            this.writeCustomData(GregtechDataCodes.UPDATE_COLOR, buf -> buf.func_150787_b(fusionRingColor));
        }
    }

    protected void formStructure(PatternMatchContext context) {
        long energyStored = this.energyContainer.getEnergyStored();
        super.formStructure(context);
        this.initializeAbilities();
        ((EnergyContainerHandler)this.energyContainer).setEnergyStored(energyStored);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.energyContainer = new EnergyContainerHandler((MetaTileEntity)this, 0L, 0L, 0L, 0L, 0L){

            @NotNull
            public String getName() {
                return "EnergyContainerInternal";
            }
        };
        this.inputEnergyContainers = new EnergyContainerList((List)Lists.newArrayList());
        this.heat = 0L;
        this.setFusionRingColor(0);
    }

    protected void initializeAbilities() {
        this.inputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.inputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS));
        this.outputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        List energyInputs = this.getAbilities(MultiblockAbility.INPUT_ENERGY);
        this.inputEnergyContainers = new EnergyContainerList(energyInputs);
        long euCapacity = this.calculateEnergyStorageFactor();
        this.energyContainer = new EnergyContainerHandler((MetaTileEntity)this, euCapacity, GTValues.V[this.tier], 0L, 0L, 0L){

            @NotNull
            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    private long calculateEnergyStorageFactor() {
        return 16L * (long)Math.pow(2.0, this.tier - 8) * 10000000L;
    }

    protected void updateFormedValid() {
        long energyAdded;
        if (this.inputEnergyContainers.getEnergyStored() > 0L && (energyAdded = this.energyContainer.addEnergy(this.inputEnergyContainers.getEnergyStored())) > 0L) {
            this.inputEnergyContainers.removeEnergy(energyAdded);
        }
        super.updateFormedValid();
        if (this.recipeMapWorkable.isWorking() && this.fusionRingColor == 0) {
            if (this.recipeMapWorkable.getPreviousRecipe() != null && !this.recipeMapWorkable.getPreviousRecipe().getFluidOutputs().isEmpty()) {
                this.setFusionRingColor(0xFF000000 | ((FluidStack)this.recipeMapWorkable.getPreviousRecipe().getFluidOutputs().get(0)).getFluid().getColor());
            }
        } else if (!this.recipeMapWorkable.isWorking() && this.isStructureFormed()) {
            this.setFusionRingColor(0);
        }
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.fusionRingColor);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.fusionRingColor = buf.func_150792_a();
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == GregtechDataCodes.UPDATE_COLOR) {
            this.fusionRingColor = buf.func_150792_a();
        } else {
            super.receiveCustomData(dataId, buf);
        }
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_fusion_reactor.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_fusion_reactor.tooltip2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.parallel", (Object[])new Object[]{16}));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit.energy_in.16", (Object[])new Object[0])}));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_fusion_reactor.capacity", (Object[])new Object[]{this.calculateEnergyStorageFactor() / 1000000L}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fusion_reactor.overclocking", (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.FUSION_REACTOR_OVERLAY;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public long getHeat() {
        return this.heat;
    }

    protected ModularUI.Builder createUITemplate(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND, (int)198, (int)236);
        builder.image(4, 4, 190, 138, (IGuiTexture)GuiTextures.DISPLAY);
        builder.widget((Widget)new ProgressWidget(() -> this.energyContainer.getEnergyCapacity() > 0L ? 1.0 * (double)this.energyContainer.getEnergyStored() / (double)this.energyContainer.getEnergyCapacity() : 0.0, 4, 144, 94, 7, GuiTextures.PROGRESS_BAR_FUSION_ENERGY, ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(this::addEnergyBarHoverText));
        builder.widget((Widget)new ProgressWidget(() -> this.energyContainer.getEnergyCapacity() > 0L ? 1.0 * (double)this.heat / (double)this.energyContainer.getEnergyCapacity() : 0.0, 100, 144, 94, 7, GuiTextures.PROGRESS_BAR_FUSION_HEAT, ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(this::addHeatBarHoverText));
        builder.widget((Widget)new IndicatorImageWidget(174, 122, 17, 17, this.getLogo()).setWarningStatus(this.getWarningLogo(), x$0 -> this.addWarningText((List)x$0)).setErrorStatus(this.getErrorLogo(), x$0 -> this.addErrorText((List)x$0)));
        if (this.tier == 8) {
            builder.widget((Widget)new ImageWidget(66, 9, 67, 12, (IGuiTexture)GuiTextures.FUSION_REACTOR_MK1_TITLE).setIgnoreColor(true));
        } else if (this.tier == 9) {
            builder.widget((Widget)new ImageWidget(65, 9, 69, 12, (IGuiTexture)GuiTextures.FUSION_REACTOR_MK2_TITLE).setIgnoreColor(true));
        } else {
            builder.widget((Widget)new ImageWidget(64, 9, 71, 12, (IGuiTexture)GuiTextures.FUSION_REACTOR_MK3_TITLE).setIgnoreColor(true));
        }
        builder.widget((Widget)new ImageWidget(55, 24, 89, 101, (IGuiTexture)GuiTextures.FUSION_REACTOR_DIAGRAM).setIgnoreColor(true));
        builder.widget((Widget)FusionProgressSupplier.Type.BOTTOM_LEFT.getWidget(this));
        builder.widget((Widget)FusionProgressSupplier.Type.TOP_LEFT.getWidget(this));
        builder.widget((Widget)FusionProgressSupplier.Type.TOP_RIGHT.getWidget(this));
        builder.widget((Widget)FusionProgressSupplier.Type.BOTTOM_RIGHT.getWidget(this));
        builder.widget((Widget)new ImageWidget(7, 98, 108, 41, (IGuiTexture)GuiTextures.FUSION_REACTOR_LEGEND).setIgnoreColor(true));
        builder.widget((Widget)new ImageCycleButtonWidget(173, 211, 18, 18, GuiTextures.BUTTON_POWER, () -> ((MultiblockRecipeLogic)this.recipeMapWorkable).isWorkingEnabled(), arg_0 -> ((MultiblockRecipeLogic)this.recipeMapWorkable).setWorkingEnabled(arg_0)));
        builder.widget((Widget)new ImageWidget(173, 229, 18, 6, (IGuiTexture)GuiTextures.BUTTON_POWER_DETAIL));
        builder.widget((Widget)new ImageCycleButtonWidget(173, 189, 18, 18, GuiTextures.BUTTON_VOID_MULTIBLOCK, 4, () -> this.getVoidingMode(), x$0 -> this.setVoidingMode(x$0)).setTooltipHoverString(x$0 -> MultiblockWithDisplayBase.getVoidingModeTooltip((int)x$0)));
        builder.widget((Widget)new ImageWidget(173, 171, 18, 18, (IGuiTexture)GuiTextures.BUTTON_NO_DISTINCT_BUSES).setTooltip("gregtech.multiblock.universal.distinct_not_supported"));
        builder.widget(this.getFlexButton(173, 153, 18, 18));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, 153);
        return builder;
    }

    private void addEnergyBarHoverText(List<ITextComponent> hoverList) {
        TextComponentString energyInfo = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.AQUA, (String)(TextFormattingUtil.formatNumbers((long)this.energyContainer.getEnergyStored()) + " / " + TextFormattingUtil.formatNumbers((long)this.energyContainer.getEnergyCapacity()) + " EU"));
        hoverList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.energy_stored", (Object[])new Object[]{energyInfo}));
    }

    private void addHeatBarHoverText(List<ITextComponent> hoverList) {
        TextComponentString heatInfo = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.RED, (String)(TextFormattingUtil.formatNumbers((long)this.heat) + " / " + TextFormattingUtil.formatNumbers((long)this.energyContainer.getEnergyCapacity())));
        hoverList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.fusion_reactor.heat", (Object[])new Object[]{heatInfo}));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        if (this.hasFusionRingColor() && !this.registeredBloomRenderTicket) {
            this.registeredBloomRenderTicket = true;
            BloomEffectUtil.registerBloomRender((IRenderSetup)FusionBloomSetup.INSTANCE, (BloomType)MetaTileEntityParallelizedFusionReactor.getBloomType(), (IBloomEffect)this, (MetaTileEntity)this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBloomEffect(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
        if (!this.hasFusionRingColor()) {
            return;
        }
        int color = RenderUtil.interpolateColor((int)this.getFusionRingColor(), (int)-1, (float)Eases.QUAD_IN.getInterpolation(Math.abs((float)Math.abs(this.getOffsetTimer() % 50L) + context.partialTicks() - 25.0f) / 25.0f));
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        EnumFacing relativeBack = RelativeDirection.BACK.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing.Axis axis = RelativeDirection.UP.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped()).func_176740_k();
        buffer.func_181668_a(8, DefaultVertexFormats.field_181706_f);
        RenderBufferHelper.renderRing((BufferBuilder)buffer, (double)((double)this.getPos().func_177958_n() - context.cameraX() + (double)(relativeBack.func_82601_c() * 7) + 0.5), (double)((double)this.getPos().func_177956_o() - context.cameraY() + (double)(relativeBack.func_96559_d() * 7) + 0.5), (double)((double)this.getPos().func_177952_p() - context.cameraZ() + (double)(relativeBack.func_82599_e() * 7) + 0.5), (double)6.0, (double)0.2, (int)10, (int)20, (float)r, (float)g, (float)b, (float)a, (EnumFacing.Axis)axis);
        Tessellator.func_178181_a().func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderBloomEffect(@NotNull EffectRenderContext context) {
        return this.hasFusionRingColor() && context.camera().func_78546_a(this.getRenderBoundingBox());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        EnumFacing relativeRight = RelativeDirection.RIGHT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing relativeBack = RelativeDirection.BACK.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        return new AxisAlignedBB(this.getPos().func_177972_a(relativeBack).func_177967_a(relativeRight, 6), this.getPos().func_177967_a(relativeBack, 13).func_177967_a(relativeRight.func_176734_d(), 6));
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public boolean isGlobalRenderer() {
        return true;
    }

    private static BloomType getBloomType() {
        ConfigHolder.FusionBloom fusionBloom = ConfigHolder.client.shader.fusionBloom;
        return BloomType.fromValue((int)(fusionBloom.useShader ? fusionBloom.bloomStyle : -1));
    }

    private static class FusionProgressSupplier {
        private final AtomicDouble tracker = new AtomicDouble(0.0);
        private final ProgressWidget.TimedProgressSupplier bottomLeft = new ProgressWidget.TimedProgressSupplier(200, 164, false){

            public double getAsDouble() {
                double val = super.getAsDouble();
                tracker.set(val);
                if (val >= 0.25) {
                    return 1.0;
                }
                return 4.0 * val;
            }

            public void resetCountdown() {
                super.resetCountdown();
                tracker.set(0.0);
            }
        };
        private final DoubleSupplier topLeft = () -> {
            double val = this.tracker.get();
            if (val < 0.25) {
                return 0.0;
            }
            if (val >= 0.5) {
                return 1.0;
            }
            return 4.0 * (val - 0.25);
        };
        private final DoubleSupplier topRight = () -> {
            double val = this.tracker.get();
            if (val < 0.5) {
                return 0.0;
            }
            if (val >= 0.75) {
                return 1.0;
            }
            return 4.0 * (val - 0.5);
        };
        private final DoubleSupplier bottomRight = () -> {
            double val = this.tracker.get();
            if (val < 0.75) {
                return 0.0;
            }
            if (val >= 1.0) {
                return 1.0;
            }
            return 4.0 * (val - 0.75);
        };

        public void resetCountdown() {
            this.bottomLeft.resetCountdown();
        }

        public DoubleSupplier getSupplier(Type type) {
            Object object;
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BOTTOM_LEFT: {
                    object = this.bottomLeft;
                    break;
                }
                case TOP_LEFT: {
                    object = this.topLeft;
                    break;
                }
                case TOP_RIGHT: {
                    object = this.topRight;
                    break;
                }
                case BOTTOM_RIGHT: {
                    object = this.bottomRight;
                }
            }
            return object;
        }

        private static enum Type {
            BOTTOM_LEFT(61, 66, 35, 41, GuiTextures.PROGRESS_BAR_FUSION_REACTOR_DIAGRAM_BL, ProgressWidget.MoveType.VERTICAL),
            TOP_LEFT(61, 30, 41, 35, GuiTextures.PROGRESS_BAR_FUSION_REACTOR_DIAGRAM_TL, ProgressWidget.MoveType.HORIZONTAL),
            TOP_RIGHT(103, 30, 35, 41, GuiTextures.PROGRESS_BAR_FUSION_REACTOR_DIAGRAM_TR, ProgressWidget.MoveType.VERTICAL_DOWNWARDS),
            BOTTOM_RIGHT(97, 72, 41, 35, GuiTextures.PROGRESS_BAR_FUSION_REACTOR_DIAGRAM_BR, ProgressWidget.MoveType.HORIZONTAL_BACKWARDS);

            private final int x;
            private final int y;
            private final int width;
            private final int height;
            private final TextureArea texture;
            private final ProgressWidget.MoveType moveType;

            private Type(int x, int y, int width, int height, TextureArea texture, ProgressWidget.MoveType moveType) {
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                this.texture = texture;
                this.moveType = moveType;
            }

            public ProgressWidget getWidget(MetaTileEntityParallelizedFusionReactor instance) {
                return new ProgressWidget(() -> instance.recipeMapWorkable.isActive() ? instance.progressBarSupplier.getSupplier(this).getAsDouble() : 0.0, this.x, this.y, this.width, this.height, this.texture, this.moveType).setIgnoreColor(true).setHoverTextConsumer(tl -> MultiblockDisplayText.builder((List)tl, (boolean)instance.isStructureFormed()).setWorkingStatus(instance.recipeMapWorkable.isWorkingEnabled(), instance.recipeMapWorkable.isActive()).addWorkingStatusLine());
            }
        }
    }

    private class ParallelizedFusionRecipeLogic
    extends GCYMMultiblockRecipeLogic {
        public ParallelizedFusionRecipeLogic(MetaTileEntityParallelizedFusionReactor tileEntity) {
            super((RecipeMapMultiblockController)tileEntity);
        }

        protected double getOverclockingDurationDivisor() {
            return 2.0;
        }

        protected double getOverclockingVoltageMultiplier() {
            return 2.0;
        }

        public long getMaxVoltage() {
            return Math.min(GTValues.V[MetaTileEntityParallelizedFusionReactor.this.tier], super.getMaxVoltage());
        }

        public void updateWorkable() {
            super.updateWorkable();
            if (MetaTileEntityParallelizedFusionReactor.this.heat > 0L && (!this.isActive || !this.workingEnabled || this.hasNotEnoughEnergy && this.progressTime == 0)) {
                MetaTileEntityParallelizedFusionReactor.this.heat = MetaTileEntityParallelizedFusionReactor.this.heat <= 10000L ? 0L : MetaTileEntityParallelizedFusionReactor.this.heat - 10000L;
            }
        }

        public boolean checkRecipe(@NotNull Recipe recipe) {
            if (!super.checkRecipe(recipe)) {
                return false;
            }
            if ((Long)recipe.getProperty((RecipeProperty)FusionEUToStartProperty.getInstance(), (Object)0L) > MetaTileEntityParallelizedFusionReactor.this.energyContainer.getEnergyCapacity()) {
                return false;
            }
            long heatDiff = (Long)recipe.getProperty((RecipeProperty)FusionEUToStartProperty.getInstance(), (Object)0L) - MetaTileEntityParallelizedFusionReactor.this.heat;
            if (heatDiff <= 0L) {
                return true;
            }
            if (MetaTileEntityParallelizedFusionReactor.this.energyContainer.getEnergyStored() < heatDiff) {
                return false;
            }
            MetaTileEntityParallelizedFusionReactor.this.energyContainer.removeEnergy(heatDiff);
            MetaTileEntityParallelizedFusionReactor.this.heat += heatDiff;
            return true;
        }

        protected void modifyOverclockPre(int @NotNull [] values, @NotNull IRecipePropertyStorage storage) {
            super.modifyOverclockPre(values, storage);
            long euToStart = (Long)storage.getRecipePropertyValue((RecipeProperty)FusionEUToStartProperty.getInstance(), (Object)0L);
            int fusionTier = FusionEUToStartProperty.getFusionTier((Long)euToStart);
            if (fusionTier != 0) {
                fusionTier = MetaTileEntityParallelizedFusionReactor.this.tier - fusionTier - 2;
            }
            values[2] = Math.min(fusionTier, values[2]);
        }

        @NotNull
        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = super.serializeNBT();
            tag.func_74772_a("Heat", MetaTileEntityParallelizedFusionReactor.this.heat);
            return tag;
        }

        public void deserializeNBT(@NotNull NBTTagCompound compound) {
            super.deserializeNBT(compound);
            MetaTileEntityParallelizedFusionReactor.this.heat = compound.func_74763_f("Heat");
        }

        protected void setActive(boolean active) {
            if (active != this.isActive) {
                MetaTileEntityParallelizedFusionReactor.this.progressBarSupplier.resetCountdown();
            }
            super.setActive(active);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final class FusionBloomSetup
    implements IRenderSetup {
        private static final FusionBloomSetup INSTANCE = new FusionBloomSetup();
        float lastBrightnessX;
        float lastBrightnessY;

        private FusionBloomSetup() {
        }

        public void preDraw(@NotNull BufferBuilder buffer) {
            BloomEffect.strength = (float)ConfigHolder.client.shader.fusionBloom.strength;
            BloomEffect.baseBrightness = (float)ConfigHolder.client.shader.fusionBloom.baseBrightness;
            BloomEffect.highBrightnessThreshold = (float)ConfigHolder.client.shader.fusionBloom.highBrightnessThreshold;
            BloomEffect.lowBrightnessThreshold = (float)ConfigHolder.client.shader.fusionBloom.lowBrightnessThreshold;
            BloomEffect.step = 1.0f;
            this.lastBrightnessX = OpenGlHelper.lastBrightnessX;
            this.lastBrightnessY = OpenGlHelper.lastBrightnessY;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179090_x();
        }

        public void postDraw(@NotNull BufferBuilder buffer) {
            GlStateManager.func_179098_w();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lastBrightnessX, (float)this.lastBrightnessY);
        }
    }
}

