/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.loader.handlers;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import kono.ceu.gtconsolidate.GTConsolidateConfig;
import kono.ceu.gtconsolidate.api.recipes.GTConsolidateRecipeMaps;
import kono.ceu.gtconsolidate.api.recipes.builder.CircuitFactoryRecipeBuilder;
import net.minecraftforge.fluids.FluidStack;

public class CircuitFactoryLoader {
    private static final int outputAmount = ConfigHolder.recipes.harderCircuitRecipes ? 1 : 2;
    private static final int voltage = GregTechAPI.isHighTier() ? 10 : 9;
    private static final int factor = GregTechAPI.isHighTier() ? 1 : 4;

    public static void register() {
        CircuitFactoryLoader.processor();
        if (GTConsolidateConfig.mode.generateLowTierCircuitRecipe) {
            CircuitFactoryLoader.lowTier();
        }
    }

    public static void processor() {
        CircuitFactoryLoader.addProcessorRecipe(MetaItems.GOOD_CIRCUIT_BOARD, MetaItems.SIMPLE_SYSTEM_ON_CHIP, Materials.Tin, 2, Materials.RedAlloy, 2, MetaItems.NAND_CHIP_ULV, outputAmount * 2, 2, 300);
        CircuitFactoryLoader.addProcessorRecipe(MetaItems.PLASTIC_CIRCUIT_BOARD, MetaItems.SIMPLE_SYSTEM_ON_CHIP, Materials.Tin, 2, Materials.RedAlloy, 2, MetaItems.NAND_CHIP_ULV, outputAmount * 2, 2, 300);
        CircuitFactoryLoader.addProcessorRecipe(MetaItems.PLASTIC_CIRCUIT_BOARD, MetaItems.SYSTEM_ON_CHIP, Materials.Copper, 2, Materials.Tin, 2, MetaItems.MICROPROCESSOR_LV, outputAmount * 3, 4, 50);
        CircuitFactoryLoader.addProcessorRecipe(MetaItems.PLASTIC_CIRCUIT_BOARD, MetaItems.SYSTEM_ON_CHIP, Materials.RedAlloy, 4, Materials.AnnealedCopper, 4, MetaItems.PROCESSOR_MV, outputAmount * 2, 5, 50);
        CircuitFactoryLoader.addProcessorRecipe(MetaItems.ADVANCED_CIRCUIT_BOARD, MetaItems.ADVANCED_SYSTEM_ON_CHIP, Materials.Electrum, 4, Materials.Platinum, 4, MetaItems.NANO_PROCESSOR_HV, outputAmount * 2, 6, 50);
        CircuitFactoryLoader.addProcessorRecipe(MetaItems.EXTREME_CIRCUIT_BOARD, MetaItems.ADVANCED_SYSTEM_ON_CHIP, Materials.Platinum, 12, Materials.NiobiumTitanium, 8, MetaItems.QUANTUM_PROCESSOR_EV, outputAmount * 2, 7, 50);
        CircuitFactoryLoader.addProcessorRecipe(MetaItems.ELITE_CIRCUIT_BOARD, MetaItems.CRYSTAL_SYSTEM_ON_CHIP, Materials.NiobiumTitanium, 8, Materials.YttriumBariumCuprate, 8, MetaItems.CRYSTAL_PROCESSOR_IV, outputAmount * 2, 7, 100);
        CircuitFactoryLoader.addProcessorRecipe(MetaItems.NEURO_PROCESSOR, MetaItems.HIGHLY_ADVANCED_SOC, Materials.YttriumBariumCuprate, 8, Materials.Naquadah, 8, MetaItems.WETWARE_PROCESSOR_LUV, outputAmount * 2, 8, 100);
    }

    public static void lowTier() {
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.BASIC_CIRCUIT_BOARD, 48)).input(OrePrefix.component, MarkerMaterials.Component.Resistor, 96)).input(OrePrefix.wireGtSingle, Materials.RedAlloy, 96)).input(OrePrefix.circuit, MarkerMaterials.Tier.ULV, 96)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.ELECTRONIC_CIRCUIT_LV, outputAmount * 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(128000 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.BASIC_CIRCUIT_BOARD, 48)).input(MetaItems.ADVANCED_SMD_RESISTOR, 48)).input(OrePrefix.wireGtSingle, Materials.RedAlloy, 96)).input(OrePrefix.circuit, MarkerMaterials.Tier.ULV, 96)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.ELECTRONIC_CIRCUIT_LV, outputAmount * 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(128000 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.GOOD_CIRCUIT_BOARD, 48)).input(OrePrefix.circuit, MarkerMaterials.Tier.LV, 96)).input(OrePrefix.component, MarkerMaterials.Component.Diode, 96)).input(OrePrefix.wireGtSingle, Materials.Copper, 96)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.ELECTRONIC_CIRCUIT_MV, outputAmount * 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(19200 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.GOOD_CIRCUIT_BOARD, 48)).input(OrePrefix.circuit, MarkerMaterials.Tier.LV, 96)).input(MetaItems.ADVANCED_SMD_DIODE, 48)).input(OrePrefix.wireGtSingle, Materials.Copper, 96)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.ELECTRONIC_CIRCUIT_MV, outputAmount * 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(19200 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.BASIC_CIRCUIT_BOARD, 48)).input(MetaItems.INTEGRATED_LOGIC_CIRCUIT, 48)).input(OrePrefix.component, MarkerMaterials.Component.Resistor, 96)).input(OrePrefix.component, MarkerMaterials.Component.Diode, 96)).input(OrePrefix.wireFine, Materials.Copper, 96)).input(OrePrefix.bolt, Materials.Tin, 96)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.INTEGRATED_CIRCUIT_LV, outputAmount * 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(12800 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.BASIC_CIRCUIT_BOARD, 48)).input(MetaItems.INTEGRATED_LOGIC_CIRCUIT, 48)).input(MetaItems.ADVANCED_SMD_RESISTOR, 48)).input(MetaItems.ADVANCED_SMD_DIODE, 48)).input(OrePrefix.wireFine, Materials.Copper, 96)).input(OrePrefix.bolt, Materials.Tin, 96)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.INTEGRATED_CIRCUIT_LV, outputAmount * 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(12800 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.GOOD_CIRCUIT_BOARD, 48)).input(MetaItems.INTEGRATED_LOGIC_CIRCUIT, 48)).input(OrePrefix.component, MarkerMaterials.Component.Resistor, 96)).input(OrePrefix.component, MarkerMaterials.Component.Diode, 96)).input(OrePrefix.wireFine, Materials.Gold, 96)).input(OrePrefix.bolt, Materials.Silver, 96)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.INTEGRATED_CIRCUIT_MV, outputAmount * 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(25600 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.GOOD_CIRCUIT_BOARD, 48)).input(MetaItems.INTEGRATED_LOGIC_CIRCUIT, 48)).input(MetaItems.ADVANCED_SMD_RESISTOR, 48)).input(MetaItems.ADVANCED_SMD_DIODE, 48)).input(OrePrefix.wireFine, Materials.Gold, 96)).input(OrePrefix.bolt, Materials.Silver, 96)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.INTEGRATED_CIRCUIT_MV, outputAmount * 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(25600 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.INTEGRATED_CIRCUIT_MV, outputAmount * 48)).input(MetaItems.INTEGRATED_LOGIC_CIRCUIT, 96)).input(MetaItems.RANDOM_ACCESS_MEMORY, 96)).input(OrePrefix.component, MarkerMaterials.Component.Transistor, 192)).input(OrePrefix.wireFine, Materials.Electrum, 384)).input(OrePrefix.bolt, Materials.AnnealedCopper, 384)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.INTEGRATED_CIRCUIT_HV, 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(51200 * factor)).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(MetaItems.INTEGRATED_CIRCUIT_MV, outputAmount * 48)).input(MetaItems.INTEGRATED_LOGIC_CIRCUIT, 96)).input(MetaItems.RANDOM_ACCESS_MEMORY, 96)).input(MetaItems.ADVANCED_SMD_TRANSISTOR, 96)).input(OrePrefix.wireFine, Materials.Electrum, 384)).input(OrePrefix.bolt, Materials.AnnealedCopper, 384)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000)})).output(MetaItems.INTEGRATED_CIRCUIT_HV, 64)).casingTier(1).EUt((int)GTValues.V[4])).duration(51200 * factor)).buildAndRegister();
    }

    public static void addProcessorRecipe(MetaItem.MetaValueItem board, MetaItem.MetaValueItem SoCStack, Material wireFineMaterial, int wireFineAmount, Material boltMaterial, int boltAmount, MetaItem.MetaValueItem output, int outputAmount, int tier, int duration) {
        int voltageTier = Math.min(tier < 5 ? tier + 3 : tier + 2, voltage);
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(board, 48)).input(SoCStack, 48)).input(OrePrefix.wireFine, wireFineMaterial, wireFineAmount * 48)).input(OrePrefix.bolt, boltMaterial, boltAmount * 48)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(3456)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1000 * tier)})).output(output, outputAmount * 64)).casingTier(tier).duration(duration * 10 * factor)).EUt((int)GTValues.V[voltageTier])).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(board, 80)).input(SoCStack, 80)).input(OrePrefix.wireGtQuadruple, wireFineMaterial, wireFineAmount * 5)).input(OrePrefix.ingot, boltMaterial, boltAmount * 10)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(5760)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(5000 * tier)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(tier)})).output(output, outputAmount * 128)).casingTier(tier).duration(duration * 30 * factor)).EUt((int)GTValues.V[voltageTier + 1])).buildAndRegister();
        ((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)((CircuitFactoryRecipeBuilder)GTConsolidateRecipeMaps.CIRCUIT_FACTORY_RECIPES.recipeBuilder()).input(board, 256)).input(SoCStack, 256)).input(OrePrefix.wireGtHex, wireFineMaterial, wireFineAmount * 2)).input(OrePrefix.wireGtDouble, wireFineMaterial, wireFineAmount)).input(OrePrefix.block, boltMaterial, boltAmount * 2)).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(10368)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(10000 * tier)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(500 * tier)})).fluidInputs(new FluidStack[]{Materials.Mutagen.getFluid(1000)})).output(output, outputAmount * 256)).casingTier(tier).duration(duration * 45 * factor)).EUt((int)GTValues.V[voltageTier + 2])).buildAndRegister();
    }
}

