/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.api.util;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import kono.ceu.gtconsolidate.GTConsolidateConfig;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GTConsolidateValues {
    public static final String MODID = "gtconsolidate";
    public static final String MODNAME = "GTConsolidate";
    public static final String VERSION = "1.0.4-beta";

    @NotNull
    public static ResourceLocation modId(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static TraceabilityPredicate manualMaintenance() {
        return ConfigHolder.machines.enableMaintenance ? MultiblockControllerBase.metaTileEntities((MetaTileEntity[])new MetaTileEntity[]{MetaTileEntities.MAINTENANCE_HATCH, MetaTileEntities.CONFIGURABLE_MAINTENANCE_HATCH}).setExactLimit(1) : new TraceabilityPredicate();
    }

    public static TraceabilityPredicate energyHatchLimit(boolean allow1A, boolean allow4A) {
        return GTConsolidateValues.energyHatchLimit(allow1A, allow4A, false);
    }

    public static TraceabilityPredicate energyHatchLimit(boolean allow1A, boolean allow4A, boolean allow16A) {
        return GTConsolidateValues.energyHatchLimit(allow1A, allow4A, allow16A, false);
    }

    public static TraceabilityPredicate energyHatchLimit(boolean allow1A, boolean allow4A, boolean allow16A, boolean allow64A) {
        ArrayList<Object> energyHatch = new ArrayList<Object>();
        if (allow1A) {
            energyHatch.addAll(Arrays.asList(MetaTileEntities.ENERGY_INPUT_HATCH));
        }
        if (allow4A) {
            energyHatch.addAll(Arrays.asList(MetaTileEntities.ENERGY_INPUT_HATCH_4A));
        }
        if (allow16A) {
            energyHatch.addAll(Arrays.asList(MetaTileEntities.ENERGY_INPUT_HATCH_16A));
        }
        if (allow64A) {
            energyHatch.addAll(Arrays.asList(MetaTileEntities.SUBSTATION_ENERGY_INPUT_HATCH));
        }
        return MultiblockControllerBase.metaTileEntities((MetaTileEntity[])energyHatch.toArray(new MetaTileEntity[0]));
    }

    @NotNull
    public static String mode() {
        String string;
        switch (GTConsolidateConfig.mode.mode) {
            case "NORMAL": {
                string = "NORMAL";
                break;
            }
            case "HARD": {
                string = "HARD";
                break;
            }
            default: {
                string = "EASY";
            }
        }
        return string;
    }
}

