/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.walhay.gregifiedenergistics.common.metatileentities.GregifiedEnergisticsMetaTileEntities;
import gregicality.multiblocks.api.capability.IParallelMultiblock;
import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IDataAccessHatch;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.recipes.recipeproperties.ResearchProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.client.particle.GTLaserBeamParticle;
import gregtech.client.particle.GTParticle;
import gregtech.client.particle.GTParticleManager;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiFluidHatch;
import gregtech.core.sound.GTSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import kono.ceu.gtconsolidate.api.util.GTConsolidateTraceabilityPredicate;
import kono.ceu.gtconsolidate.api.util.Mods;
import kono.ceu.gtconsolidate.api.util.mixinhelper.MultiblockDisplayTextMixinHelper;
import kono.ceu.gtconsolidate.client.GTConsolidateTextures;
import kono.ceu.gtconsolidate.common.blocks.BlockParallelizedAssemblyLineCasing;
import kono.ceu.gtconsolidate.common.blocks.GTConsolidateMetaBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityParallelizedAssemblyLine
extends RecipeMapMultiblockController
implements IParallelMultiblock {
    private static final ResourceLocation LASER_LOCATION = GTUtility.gregtechId((String)"textures/fx/laser/laser.png");
    private static final ResourceLocation LASER_HEAD_LOCATION = GTUtility.gregtechId((String)"textures/fx/laser/laser_start.png");
    @SideOnly(value=Side.CLIENT)
    private GTLaserBeamParticle[][] beamParticles;
    private int beamCount;
    private int beamTime;
    private final int maxParallel;

    public MetaTileEntityParallelizedAssemblyLine(ResourceLocation metaTileEntityId, int maxParallel) {
        super(metaTileEntityId, RecipeMaps.ASSEMBLY_LINE_RECIPES);
        this.maxParallel = maxParallel;
        this.recipeMapWorkable = new GCYMMultiblockRecipeLogic((RecipeMapMultiblockController)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityParallelizedAssemblyLine(this.metaTileEntityId, this.maxParallel);
    }

    public boolean isParallel() {
        return true;
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    private TraceabilityPredicate inputBusPredicate() {
        return Mods.GregifiedEnergistics.isModLoaded() ? MetaTileEntityParallelizedAssemblyLine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}) : MetaTileEntityParallelizedAssemblyLine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).or(MetaTileEntityParallelizedAssemblyLine.metaTileEntities((MetaTileEntity[])new MetaTileEntity[]{GregifiedEnergisticsMetaTileEntities.ME_ASSEMBLY_LINE_BUS, GregifiedEnergisticsMetaTileEntities.ME_ASSEMBLY_LINE_OPTICAL_BUS}));
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        FactoryBlockPattern pattern = FactoryBlockPattern.start((RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP, (RelativeDirection)RelativeDirection.RIGHT).aisle(new String[]{"FBF", "RTR", "SAG", " Y "}).aisle(new String[]{"FIF", "RTR", "DAG", " Y "}).setRepeatable(3, 15).aisle(new String[]{"FOF", "RTR", "DAG", " Y "}).where('S', this.selfPredicate()).where('F', MetaTileEntityParallelizedAssemblyLine.states((IBlockState[])new IBlockState[]{MetaTileEntityParallelizedAssemblyLine.getCasingState()}).or(this.autoAbilities(false, true, false, false, false, false, false)).or(MetaTileEntityParallelizedAssemblyLine.fluidInputPredicate())).where('O', MetaTileEntityParallelizedAssemblyLine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS}).addTooltips(new String[]{"gregtech.multiblock.pattern.location_end"})).where('Y', MetaTileEntityParallelizedAssemblyLine.states((IBlockState[])new IBlockState[]{MetaTileEntityParallelizedAssemblyLine.getCasingState()}).or(GTConsolidateTraceabilityPredicate.energyHatchLimit(false, this.maxParallel == 4, this.maxParallel != 64, this.maxParallel == 64))).where('B', this.inputBusPredicate()).where('I', MetaTileEntityParallelizedAssemblyLine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).addTooltips(new String[]{"gtconsolidate.multiblock.jei.bus.filtered"})).where('G', MetaTileEntityParallelizedAssemblyLine.states((IBlockState[])new IBlockState[]{MetaTileEntityParallelizedAssemblyLine.getGrateState()})).where('A', MetaTileEntityParallelizedAssemblyLine.states((IBlockState[])new IBlockState[]{MetaTileEntityParallelizedAssemblyLine.getControlCasingState()})).where('R', MetaTileEntityParallelizedAssemblyLine.states((IBlockState[])new IBlockState[]{MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS)})).where('T', MetaTileEntityParallelizedAssemblyLine.states((IBlockState[])new IBlockState[]{MetaTileEntityParallelizedAssemblyLine.getBaseCasingState()})).where('D', MetaTileEntityParallelizedAssemblyLine.extraHatchPredicate()).where(' ', MetaTileEntityParallelizedAssemblyLine.any());
        return pattern.build();
    }

    @NotNull
    protected static IBlockState getCasingState() {
        return MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.ASSEMBLY_CONTROL);
    }

    @NotNull
    protected static IBlockState getBaseCasingState() {
        return GTConsolidateMetaBlocks.PARALLELIZED_ASSEMBLY_LINE_CASING.getState(BlockParallelizedAssemblyLineCasing.ParallelizedAssemblyLineCasingType.CASING);
    }

    @NotNull
    protected static IBlockState getGrateState() {
        return MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING);
    }

    @NotNull
    protected static IBlockState getControlCasingState() {
        return GTConsolidateMetaBlocks.PARALLELIZED_ASSEMBLY_LINE_CASING.getState(BlockParallelizedAssemblyLineCasing.ParallelizedAssemblyLineCasingType.CONTROL);
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.Builder builder = MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed());
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addEnergyUsageExactLine((long)this.recipeMapWorkable.getInfoProviderEUt());
        ((MultiblockDisplayTextMixinHelper)builder).addExtendedParallelLine((AbstractRecipeLogic)this.recipeMapWorkable);
        builder.addWorkingStatusLine();
        ((MultiblockDisplayTextMixinHelper)builder).addExtendedProgressLine((AbstractRecipeLogic)this.recipeMapWorkable);
        ((MultiblockDisplayTextMixinHelper)builder).addOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    @NotNull
    protected static TraceabilityPredicate fluidInputPredicate() {
        if (ConfigHolder.machines.orderedFluidAssembly) {
            return MetaTileEntityParallelizedAssemblyLine.metaTileEntities((MetaTileEntity[])((MetaTileEntity[])((List)MultiblockAbility.REGISTRY.get(MultiblockAbility.IMPORT_FLUIDS)).stream().filter(mte -> !(mte instanceof MetaTileEntityMultiFluidHatch)).toArray(MetaTileEntity[]::new))).setMaxGlobalLimited(4);
        }
        return MetaTileEntityParallelizedAssemblyLine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS});
    }

    @NotNull
    protected static TraceabilityPredicate extraHatchPredicate() {
        if (ConfigHolder.machines.enableResearch) {
            return MetaTileEntityParallelizedAssemblyLine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.DATA_ACCESS_HATCH, MultiblockAbility.OPTICAL_DATA_RECEPTION}).setExactLimit(1).or(MetaTileEntityParallelizedAssemblyLine.states((IBlockState[])new IBlockState[]{MetaTileEntityParallelizedAssemblyLine.getGrateState()}));
        }
        return MetaTileEntityParallelizedAssemblyLine.states((IBlockState[])new IBlockState[]{MetaTileEntityParallelizedAssemblyLine.getGrateState()});
    }

    protected Function<BlockPos, Integer> multiblockPartSorter() {
        return RelativeDirection.LEFT.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart != null) {
            if (sourcePart instanceof IDataAccessHatch) {
                return Textures.GRATE_CASING_STEEL_FRONT;
            }
            return GTConsolidateTextures.ASSEMBLY_LINE_CONTROL;
        }
        if (this.isStructureFormed()) {
            return Textures.GRATE_CASING_STEEL_FRONT;
        }
        return GTConsolidateTextures.PARALLELIZED_ASSEMBLY_LINE_CONTROL;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        if (this.maxParallel == 64) {
            ArrayList inputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
            inputEnergy.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY));
            this.energyContainer = new EnergyContainerList(inputEnergy);
        }
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_MECHANICAL;
    }

    public void update() {
        super.update();
        if (ConfigHolder.client.shader.assemblyLineParticles) {
            if (this.getRecipeMapWorkable().isWorking()) {
                int maxBeams = this.getAbilities(MultiblockAbility.IMPORT_ITEMS).size() + 1;
                int maxProgress = this.getRecipeMapWorkable().getMaxProgress();
                int beamTime = Math.max(1, maxProgress / maxBeams);
                int beamCount = Math.min(maxBeams, this.getRecipeMapWorkable().getProgress() / beamTime + 1);
                if (beamCount != this.beamCount) {
                    if (beamCount < this.beamCount) {
                        this.beamCount = Math.max(0, beamCount - 1);
                        this.writeCustomData(GregtechDataCodes.UPDATE_PARTICLE, this::writeParticles);
                    }
                    this.beamTime = beamTime;
                    this.beamCount = beamCount;
                    this.writeCustomData(GregtechDataCodes.UPDATE_PARTICLE, this::writeParticles);
                }
            } else if (this.beamCount != 0) {
                this.beamTime = 0;
                this.beamCount = 0;
                this.writeCustomData(GregtechDataCodes.UPDATE_PARTICLE, this::writeParticles);
            }
        }
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.writeParticles(buf);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.readParticles(buf);
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == GregtechDataCodes.UPDATE_PARTICLE) {
            this.readParticles(buf);
        } else {
            super.receiveCustomData(dataId, buf);
        }
    }

    public void onRemoval() {
        super.onRemoval();
        if (this.getWorld().field_72995_K && this.beamParticles != null) {
            for (GTLaserBeamParticle[] particle : this.beamParticles) {
                if (particle[0] == null) continue;
                particle[0].setExpired();
                particle[1].setExpired();
            }
            this.beamParticles = null;
        }
    }

    private void writeParticles(@NotNull PacketBuffer buf) {
        buf.func_150787_b(this.beamCount);
        buf.func_150787_b(this.beamTime);
    }

    @SideOnly(value=Side.CLIENT)
    private void readParticles(@NotNull PacketBuffer buf) {
        this.beamCount = buf.func_150792_a();
        this.beamTime = buf.func_150792_a();
        if (this.beamParticles == null) {
            this.beamParticles = new GTLaserBeamParticle[17][2];
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getPos());
        EnumFacing relativeUp = RelativeDirection.UP.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing relativeLeft = RelativeDirection.LEFT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        boolean negativeUp = relativeUp.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        for (int i = 0; i < this.beamParticles.length; ++i) {
            GTLaserBeamParticle particle = this.beamParticles[i][0];
            if (i < this.beamCount && particle == null) {
                pos.func_189533_g((Vec3i)this.getPos());
                if (negativeUp) {
                    pos.func_189536_c(relativeUp.func_176734_d());
                }
                Vector3 startPos = new Vector3().add((BlockPos)pos.func_189534_c(relativeLeft, i)).add(relativeUp.func_176740_k() == EnumFacing.Axis.X ? 0.0 : 0.5, relativeUp.func_176740_k() == EnumFacing.Axis.Y ? 0.0 : 0.5, relativeUp.func_176740_k() == EnumFacing.Axis.Z ? 0.0 : 0.5);
                Vector3 endPos = startPos.copy().subtract((double)relativeUp.func_82601_c(), (double)relativeUp.func_96559_d(), (double)relativeUp.func_82599_e());
                this.beamParticles[i][0] = this.createALParticles(startPos, endPos);
                pos.func_189533_g((Vec3i)this.getPos());
                if (negativeUp) {
                    pos.func_189536_c(relativeUp.func_176734_d());
                }
                startPos = new Vector3().add((BlockPos)pos.func_189534_c(relativeLeft, i).func_189534_c(this.getFrontFacing().func_176734_d(), 2)).add(relativeUp.func_176740_k() == EnumFacing.Axis.X ? 0.0 : 0.5, relativeUp.func_176740_k() == EnumFacing.Axis.Y ? 0.0 : 0.5, relativeUp.func_176740_k() == EnumFacing.Axis.Z ? 0.0 : 0.5);
                endPos = startPos.copy().subtract((double)relativeUp.func_82601_c(), (double)relativeUp.func_96559_d(), (double)relativeUp.func_82599_e());
                this.beamParticles[i][1] = this.createALParticles(startPos, endPos);
                GTParticleManager.INSTANCE.addEffect((GTParticle)this.beamParticles[i][0]);
                GTParticleManager.INSTANCE.addEffect((GTParticle)this.beamParticles[i][1]);
                continue;
            }
            if (i < this.beamCount || particle == null) continue;
            particle.setExpired();
            this.beamParticles[i][0] = null;
            this.beamParticles[i][1].setExpired();
            this.beamParticles[i][1] = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    private GTLaserBeamParticle createALParticles(Vector3 startPos, Vector3 endPos) {
        return new GTLaserBeamParticle((MetaTileEntity)this, startPos, endPos, this.beamTime).setBody(LASER_LOCATION).setBeamHeight(0.125f).setDoubleVertical(true).setHead(LASER_HEAD_LOCATION).setHeadWidth(0.1f).setEmit(0.2f);
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        if (consumeIfSuccess) {
            return true;
        }
        if (ConfigHolder.machines.orderedAssembly) {
            List inputs = recipe.getInputs();
            List itemInputInventory = this.getAbilities(MultiblockAbility.IMPORT_ITEMS);
            if (itemInputInventory.size() < inputs.size()) {
                return false;
            }
            for (int i = 0; i < inputs.size(); ++i) {
                ItemStack topStack = ((IItemHandlerModifiable)itemInputInventory.get(i)).getStackInSlot(0);
                if (!((GTRecipeInput)inputs.get(i)).acceptsStack(topStack)) {
                    return false;
                }
                for (int j = 1; j < ((IItemHandlerModifiable)itemInputInventory.get(i)).getSlots(); ++j) {
                    ItemStack remainStack = ((IItemHandlerModifiable)itemInputInventory.get(i)).getStackInSlot(j);
                    if (remainStack.func_190926_b() || remainStack.func_77969_a(topStack)) continue;
                    return false;
                }
            }
            if (ConfigHolder.machines.orderedFluidAssembly) {
                inputs = recipe.getFluidInputs();
                List fluidInputInventory = this.getAbilities(MultiblockAbility.IMPORT_FLUIDS);
                if (fluidInputInventory.size() < inputs.size()) {
                    return false;
                }
                for (int i = 0; i < inputs.size(); ++i) {
                    if (((GTRecipeInput)inputs.get(i)).acceptsFluid(((IFluidTank)fluidInputInventory.get(i)).getFluid())) continue;
                    return false;
                }
            }
        }
        if (!ConfigHolder.machines.enableResearch || !recipe.hasProperty((RecipeProperty)ResearchProperty.getInstance())) {
            return super.checkRecipe(recipe, consumeIfSuccess);
        }
        return MetaTileEntityParallelizedAssemblyLine.isRecipeAvailable(this.getAbilities(MultiblockAbility.DATA_ACCESS_HATCH), recipe) || MetaTileEntityParallelizedAssemblyLine.isRecipeAvailable(this.getAbilities(MultiblockAbility.OPTICAL_DATA_RECEPTION), recipe);
    }

    private static boolean isRecipeAvailable(@NotNull Iterable<? extends IDataAccessHatch> hatches, @NotNull Recipe recipe) {
        for (IDataAccessHatch iDataAccessHatch : hatches) {
            if (iDataAccessHatch.isCreative()) {
                return true;
            }
            if (!iDataAccessHatch.isRecipeAvailable(recipe)) continue;
            return true;
        }
        return false;
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_al.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.parallel", (Object[])new Object[]{this.maxParallel}));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_al.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{I18n.func_135052_a((String)(this.maxParallel == 4 ? "gtconsolidate.multiblock.tooltip.universal.limit.energy_in.4and16" : (this.maxParallel == 16 ? "gtconsolidate.multiblock.tooltip.universal.limit.energy_in.16" : "gtconsolidate.multiblock.tooltip.universal.limit.energy_in.64")), (Object[])new Object[0])}));
        if (ConfigHolder.machines.orderedAssembly && ConfigHolder.machines.orderedFluidAssembly) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.assembly_line.tooltip_ordered_both", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_al.limit", (Object[])new Object[0])}));
        } else if (ConfigHolder.machines.orderedAssembly) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.assembly_line.tooltip_ordered_items", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{I18n.func_135052_a((String)"gtconsolidate.machine.parallelized_al.limit", (Object[])new Object[0])}));
        } else if (ConfigHolder.machines.orderedFluidAssembly) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.assembly_line.tooltip_ordered_fluids", (Object[])new Object[0]));
        }
    }
}

