/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.api.util;

import gregtech.api.util.ModIncompatibilityException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Mods {
    AppliedEnergistics2("appliedenergistics2"),
    GregicalityMultiblocks("gcym"),
    GregifiedEnergistics("gregifiedenergistics"),
    GregTech("gregtech"),
    GregTechFoodOption("gregtechfoodoption"),
    GregTechExpertCore("gtexpert"),
    GTConsolidate("gtconsolidate"),
    GTWoodProcessing("gtwp"),
    MixinBooter("mixinbooter"),
    Vanilla("minecraft"),
    Optifine(null){

        @Override
        public boolean isModLoaded() {
            if (this.modLoaded == null) {
                try {
                    Class<?> c = Class.forName("net.optifine.shaders.Shaders");
                    Field f = c.getDeclaredField("shaderPackLoaded");
                    f.setAccessible(true);
                    this.modLoaded = f.getBoolean(null);
                }
                catch (Exception ignored) {
                    this.modLoaded = false;
                }
            }
            return this.modLoaded;
        }
    };

    private final String ID;
    private final Function<Mods, Boolean> extraCheck;
    protected Boolean modLoaded;

    private Mods(String ID) {
        this.ID = ID;
        this.extraCheck = null;
    }

    private Mods(String ID, Function<Mods, Boolean> extraCheck) {
        this.ID = ID;
        this.extraCheck = extraCheck;
    }

    public boolean isModLoaded() {
        if (this.modLoaded == null) {
            this.modLoaded = Loader.isModLoaded((String)this.ID);
            if (this.modLoaded.booleanValue() && this.extraCheck != null && !this.extraCheck.apply(this).booleanValue()) {
                this.modLoaded = false;
            }
        }
        return this.modLoaded;
    }

    public void throwIncompatibilityIfLoaded(String ... customMessages) {
        if (this.isModLoaded()) {
            String modName = TextFormatting.BOLD + this.ID + TextFormatting.RESET;
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(modName + " mod detected, this mod is incompatible with GregTech CE Unofficial.");
            messages.addAll(Arrays.asList(customMessages));
            if (FMLLaunchHandler.side() == Side.SERVER) {
                throw new RuntimeException(String.join((CharSequence)",", messages));
            }
            Mods.throwClientIncompatibility(messages);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void throwClientIncompatibility(List<String> messages) {
        throw new ModIncompatibilityException(messages);
    }

    public ItemStack getItem(@NotNull String name) {
        return this.getItem(name, 1, 0, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int count) {
        return this.getItem(name, count, 0, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int count, int meta) {
        return this.getItem(name, count, meta, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int count, int meta, @Nullable String nbt) {
        return GameRegistry.makeItemStack((String)(this.ID + ":" + name), (int)meta, (int)count, (String)nbt);
    }

    @NotNull
    public ResourceLocation getResource(@NotNull String path) {
        return new ResourceLocation(this.ID, path);
    }

    private static Function<Mods, Boolean> versionContains(String versionPart) {
        return mod -> {
            if (mod.ID == null) {
                return false;
            }
            if (!mod.isModLoaded()) {
                return false;
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(mod.ID);
            if (container == null) {
                return false;
            }
            return container.getVersion().contains(versionPart);
        };
    }

    private static Function<Mods, Boolean> versionExcludes(String versionPart) {
        return mod -> {
            if (mod.ID == null) {
                return false;
            }
            if (!mod.isModLoaded()) {
                return false;
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(mod.ID);
            if (container == null) {
                return false;
            }
            return !container.getVersion().contains(versionPart);
        };
    }

    public static class Names {
        public static final String APPLIED_ENERGISTICS2 = "appliedenergistics2";
        public static final String GREGICALITY_MULTIBLOCKS = "gcym";
        public static final String GREGIFIED_ENERGISTICS = "gregifiedenergistics";
        public static final String GREGTECH = "gregtech";
        public static final String GREGTECH_FOOD_OPTION = "gregtechfoodoption";
        public static final String GREGTECH_EXPERT_CORE = "gtexpert";
        public static final String GTCONSOLIDATE = "gtconsolidate";
        public static final String GREGTECH_WOOD_PROCESSING = "gtwp";
        public static final String MIXINBOOTER = "mixinbooter";
        public static final String VANILLA = "minecraft";
    }
}

