/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import gregicality.multiblocks.api.capability.IParallelHatch;
import gregicality.multiblocks.api.metatileentity.GCYMMultiblockAbility;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import kono.ceu.gtconsolidate.api.util.mixinhelper.MultiblockDisplayTextMixinHelper;
import kono.ceu.gtconsolidate.common.blocks.BlockCoolantCasing;
import kono.ceu.gtconsolidate.common.blocks.GTConsolidateMetaBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMegaFurnace
extends RecipeMapMultiblockController {
    protected int heatingCoilLevel;
    protected int heatingCoilDiscount;

    public MetaTileEntityMegaFurnace(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.FURNACE_RECIPES);
        this.recipeMapWorkable = new MegaSmelterWorkable(this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMegaFurnace(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXXXX", "GGGGG", "GGGGG", "GGGGG", "XXXXX"}).aisle(new String[]{"XXXXX", "GCCCG", "GCCCG", "GCCCG", "XXXXX"}).aisle(new String[]{"XXXXX", "GC#CG", "GC#CG", "GC#CG", "XXMXX"}).aisle(new String[]{"XXXXX", "GCCCG", "GCCCG", "GCCCG", "XXXXX"}).aisle(new String[]{"XXSXX", "GGGGG", "GGGGG", "GGGGG", "XXXXX"}).where('S', this.selfPredicate()).where('X', MetaTileEntityMegaFurnace.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF)}).setMinGlobalLimited(25).or(this.autoAbilities(true, true, true, true, true, true, false))).where('M', MetaTileEntityMegaFurnace.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('C', MetaTileEntityMegaFurnace.heatingCoils()).where('G', MetaTileEntityMegaFurnace.states((IBlockState[])new IBlockState[]{GTConsolidateMetaBlocks.COOLANT_CASING.getState(BlockCoolantCasing.CasingType.CRYSTAL_QUARTZ_GLASS)})).where('#', MetaTileEntityMegaFurnace.air()).build();
    }

    public int getParallelFactor() {
        return this.getAbilities(GCYMMultiblockAbility.PARALLEL_HATCH).isEmpty() ? 1 : ((IParallelHatch)this.getAbilities(GCYMMultiblockAbility.PARALLEL_HATCH).get(0)).getCurrentParallel();
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.Builder builder = MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed());
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.recipeMapWorkable.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addEnergyUsageExactLine((long)this.recipeMapWorkable.getInfoProviderEUt()).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentTranslation hoverText;
                if (this.heatingCoilDiscount > 1) {
                    TextComponentString coilDiscount = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.AQUA, (String)(TextFormattingUtil.formatNumbers((double)(100.0 / (double)this.heatingCoilDiscount)) + "%"));
                    TextComponentTranslation base = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.multi_furnace.heating_coil_discount", (Object[])new Object[]{coilDiscount});
                    hoverText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.multi_furnace.heating_coil_discount_hover", (Object[])new Object[0]);
                    TextComponentUtil.setHover((ITextComponent)base, (ITextComponent[])new ITextComponent[]{hoverText});
                    tl.add(base);
                }
                if (this.recipeMapWorkable.getParallelLimit() > 1) {
                    TextComponentString parallels = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)TextFormattingUtil.formatNumbers((long)this.recipeMapWorkable.getParallelLimit()));
                    TextComponentTranslation bodyText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.parallel", (Object[])new Object[]{parallels});
                    hoverText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.multi_furnace.parallel_hover", (Object[])new Object[0]);
                    tl.add(TextComponentUtil.setHover((ITextComponent)bodyText, (ITextComponent[])new ITextComponent[]{hoverText}));
                }
            }
        }).addWorkingStatusLine();
        ((MultiblockDisplayTextMixinHelper)builder).addExtendedProgressLine((AbstractRecipeLogic)this.recipeMapWorkable);
        ((MultiblockDisplayTextMixinHelper)builder).addOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object coilType = context.get("CoilType");
        if (coilType instanceof IHeatingCoilBlockStats) {
            this.heatingCoilLevel = ((IHeatingCoilBlockStats)coilType).getLevel();
            this.heatingCoilDiscount = ((IHeatingCoilBlockStats)coilType).getEnergyDiscount();
        } else {
            this.heatingCoilLevel = BlockWireCoil.CoilType.CUPRONICKEL.getLevel();
            this.heatingCoilDiscount = BlockWireCoil.CoilType.CUPRONICKEL.getEnergyDiscount();
        }
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.heatingCoilLevel = 0;
        this.heatingCoilDiscount = 0;
    }

    public TraceabilityPredicate autoAbilities(boolean checkEnergyIn, boolean checkMaintenance, boolean checkItemIn, boolean checkItemOut, boolean checkFluidIn, boolean checkFluidOut, boolean checkMuffler) {
        TraceabilityPredicate predicate = super.autoAbilities(checkEnergyIn, checkMaintenance, checkItemIn, checkItemOut, checkFluidIn, checkFluidOut, checkMuffler);
        predicate = predicate.or(MetaTileEntityMegaFurnace.abilities((MultiblockAbility[])new MultiblockAbility[]{GCYMMultiblockAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1).setPreviewCount(1));
        return predicate;
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.HEAT_PROOF_CASING;
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.MULTI_FURNACE_OVERLAY;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public static int getEUtForParallel(int parallel, int discount) {
        return 4 * Math.max(1, parallel / 8 / discount);
    }

    public static int getMaxParallel(int heatingCoilLevel) {
        return 32 * heatingCoilLevel;
    }

    public static int getDurationForParallel(int parallel, int parallelLimit) {
        return (int)Math.max(1.0, (double)(256 * parallel) / Math.max(1.0, (double)parallelLimit * 1.0));
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.mega_furnace.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.mega_furnace.tooltip.2", (Object[])new Object[0]));
    }

    protected class MegaSmelterWorkable
    extends MultiblockRecipeLogic {
        public MegaSmelterWorkable(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        @NotNull
        public ParallelLogicType getParallelLogicType() {
            return ParallelLogicType.APPEND_ITEMS;
        }

        public void applyParallelBonus(@NotNull RecipeBuilder<?> builder) {
            builder.EUt(MetaTileEntityMegaFurnace.getEUtForParallel(builder.getParallel(), MetaTileEntityMegaFurnace.this.heatingCoilDiscount)).duration(MetaTileEntityMegaFurnace.getDurationForParallel(builder.getParallel(), this.getParallelLimit()));
        }

        public int getParallelLimit() {
            return MetaTileEntityMegaFurnace.getMaxParallel(MetaTileEntityMegaFurnace.this.heatingCoilLevel) * MetaTileEntityMegaFurnace.this.getParallelFactor();
        }
    }
}

