/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import codechicken.lib.util.ArrayUtils;
import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.IMachineHatchMultiblock;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.DummyCleanroom;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import gregtech.api.metatileentity.multiblock.ICleanroomReceiver;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import kono.ceu.gtconsolidate.client.GTConsolidateTextures;
import kono.ceu.gtconsolidate.common.blocks.BlockMultiblockCasing;
import kono.ceu.gtconsolidate.common.blocks.GTConsolidateMetaBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityExtendedProcessingArray
extends RecipeMapMultiblockController
implements IMachineHatchMultiblock {
    private final int tier;
    private boolean machineChanged;

    public MetaTileEntityExtendedProcessingArray(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, null);
        this.tier = tier;
        this.recipeMapWorkable = new ExtendedProcessingArrayWorkable(this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityExtendedProcessingArray(this.metaTileEntityId, this.tier);
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        ((ExtendedProcessingArrayWorkable)this.recipeMapWorkable).findMachineStack();
    }

    public int getMachineLimit() {
        return 64;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXXXX", "XXXXX", "XXXXX", "XXXXX", "XXXXX"}).aisle(new String[]{"XXXXX", "X###X", "X#C#X", "X###X", "XXXXX"}).aisle(new String[]{"XXXXX", "X#C#X", "XC#CX", "X#C#X", "XXXXX"}).aisle(new String[]{"XXXXX", "X###X", "X#C#X", "X###X", "XXXXX"}).aisle(new String[]{"XXXXX", "XXXXX", "XXSXX", "XXXXX", "XXXXX"}).where('C', MetaTileEntityExtendedProcessingArray.states((IBlockState[])new IBlockState[]{MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_COIL)})).where('S', this.selfPredicate()).where('X', MetaTileEntityExtendedProcessingArray.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(50).or(this.autoAbilities(false, true, true, true, true, true, true)).or(MetaTileEntityExtendedProcessingArray.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(4)).or(MetaTileEntityExtendedProcessingArray.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MACHINE_HATCH}).setExactLimit(1))).where('#', MetaTileEntityExtendedProcessingArray.air()).build();
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        ExtendedProcessingArrayWorkable logic = (ExtendedProcessingArrayWorkable)this.recipeMapWorkable;
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.recipeMapWorkable.getEnergyContainer()).addEnergyTierLine(logic.currentMachineStack == ItemStack.field_190927_a ? -1 : logic.machineTier).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString maxMachinesText = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)Integer.toString(this.getMachineLimit() * this.getParallelFactor()));
                maxMachinesText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.machine_hatch.machines_max", (Object[])new Object[]{maxMachinesText});
                if (logic.activeRecipeMap == null) {
                    TextComponentTranslation noneText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.YELLOW, (String)"gregtech.machine.machine_hatch.machines_none", (Object[])new Object[0]);
                    TextComponentTranslation bodyText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.machine_hatch.machines", (Object[])new Object[]{noneText});
                    TextComponentTranslation hoverText1 = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.machine_hatch.machines_none_hover", (Object[])new Object[0]);
                    tl.add(TextComponentUtil.setHover((ITextComponent)bodyText, (ITextComponent[])new ITextComponent[]{hoverText1, maxMachinesText}));
                } else {
                    String key = logic.getMachineStack().func_77977_a();
                    TextComponentTranslation mapText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)(key + ".name"), (Object[])new Object[0]);
                    mapText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)"%sx %s", (Object[])new Object[]{logic.getParallelLimit(), mapText});
                    TextComponentTranslation bodyText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.machine_hatch.machines", (Object[])new Object[]{mapText});
                    TextComponentString voltageName = new TextComponentString(GTValues.VNF[logic.machineTier]);
                    int amps = logic.getMachineStack().func_190916_E() * this.getParallelFactor();
                    String energyFormatted = TextFormattingUtil.formatNumbers((long)(GTValues.V[logic.machineTier] * (long)amps));
                    TextComponentTranslation hoverText = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.machine_hatch.machines_max_eut", (Object[])new Object[]{energyFormatted, amps, voltageName});
                    tl.add(TextComponentUtil.setHover((ITextComponent)bodyText, (ITextComponent[])new ITextComponent[]{hoverText, maxMachinesText}));
                }
                if (this.isActive()) {
                    tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.DARK_RED, (String)"gregtech.machine.machine_hatch.locked", (Object[])new Object[0]));
                }
            }
        }).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    public IBlockState getCasingState() {
        return this.tier == 0 ? GTConsolidateMetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.OSMIRIDIUM_STURDY) : (this.tier == 1 ? GTConsolidateMetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.DARMSTADTIUM_STURDY) : GTConsolidateMetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.TRITANIUM_STURDY));
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.tier == 0 ? GTConsolidateTextures.OSMIRIDIUM_STURDY : (this.tier == 1 ? GTConsolidateTextures.DARMSTADTIUM_STURDY : GTConsolidateTextures.TRITANIUM_STURDY);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return Textures.ADVANCED_PROCESSING_ARRAY_OVERLAY;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public void notifyMachineChanged() {
        this.machineChanged = true;
    }

    public String[] getBlacklist() {
        return ConfigHolder.machines.processingArrayBlacklist;
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_MECHANICAL;
    }

    public SoundEvent getSound() {
        return GTSoundEvents.ARC;
    }

    public TraceabilityPredicate autoAbilities(boolean checkEnergyIn, boolean checkMaintenance, boolean checkItemIn, boolean checkItemOut, boolean checkFluidIn, boolean checkFluidOut, boolean checkMuffler) {
        TraceabilityPredicate predicate = super.autoAbilities(checkMaintenance, checkMuffler).or(checkEnergyIn ? MetaTileEntityExtendedProcessingArray.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(4).setPreviewCount(1) : new TraceabilityPredicate());
        predicate = predicate.or(MetaTileEntityExtendedProcessingArray.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityExtendedProcessingArray.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS}).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityExtendedProcessingArray.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityExtendedProcessingArray.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS}).setPreviewCount(1));
        return predicate;
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)("gtconsolidate.machine.extended_processing_array.tooltip.factor." + this.getParallelFactor()), (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.parallel", (Object[])new Object[]{this.getMachineLimit() * this.getParallelFactor()}));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.extended_processing_array.tooltip.1", (Object[])new Object[]{this.getParallelFactor()}));
    }

    private int getParallelFactor() {
        return this.tier == 0 ? 4 : (this.tier == 1 ? 16 : 64);
    }

    public int getItemOutputLimit() {
        ItemStack machineStack = ((ExtendedProcessingArrayWorkable)this.recipeMapWorkable).getMachineStack();
        MetaTileEntity mte = GTUtility.getMetaTileEntity((ItemStack)machineStack);
        return mte == null ? 0 : mte.getItemOutputLimit();
    }

    protected class ExtendedProcessingArrayWorkable
    extends MultiblockRecipeLogic {
        private static final ICleanroomProvider DUMMY_CLEANROOM = DummyCleanroom.createForAllTypes();
        ItemStack currentMachineStack;
        MetaTileEntity mte;
        private int machineTier;
        private long machineVoltage;
        private RecipeMap<?> activeRecipeMap;

        public ExtendedProcessingArrayWorkable(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
            this.currentMachineStack = ItemStack.field_190927_a;
            this.mte = null;
        }

        public void invalidate() {
            super.invalidate();
            if (this.mte != null && this.mte instanceof ICleanroomReceiver) {
                ((ICleanroomReceiver)this.mte).setCleanroom(null);
            }
            this.currentMachineStack = ItemStack.field_190927_a;
            this.mte = null;
            MetaTileEntityExtendedProcessingArray.this.machineChanged = true;
            this.machineTier = 0;
            this.machineVoltage = 0L;
            this.activeRecipeMap = null;
        }

        public boolean isRecipeMapValid(@NotNull RecipeMap<?> recipeMap) {
            if (ArrayUtils.contains((Object[])((IMachineHatchMultiblock)this.metaTileEntity).getBlacklist(), (Object)recipeMap.getUnlocalizedName())) {
                return false;
            }
            return GTUtility.isMachineValidForMachineHatch((ItemStack)this.currentMachineStack, (String[])((IMachineHatchMultiblock)this.metaTileEntity).getBlacklist());
        }

        protected boolean shouldSearchForRecipes() {
            return this.canWorkWithMachines() && super.shouldSearchForRecipes();
        }

        public boolean canWorkWithMachines() {
            if (MetaTileEntityExtendedProcessingArray.this.machineChanged) {
                this.findMachineStack();
                MetaTileEntityExtendedProcessingArray.this.machineChanged = false;
                this.previousRecipe = null;
                if (MetaTileEntityExtendedProcessingArray.this.isDistinct()) {
                    this.invalidatedInputList.clear();
                } else {
                    this.invalidInputsForRecipes = false;
                }
            }
            return !this.currentMachineStack.func_190926_b() && this.activeRecipeMap != null;
        }

        @Nullable
        public RecipeMap<?> getRecipeMap() {
            return this.activeRecipeMap;
        }

        public void findMachineStack() {
            RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
            ItemStack machine = ((IItemHandlerModifiable)controller.getAbilities(MultiblockAbility.MACHINE_HATCH).get(0)).getStackInSlot(0);
            this.mte = GTUtility.getMetaTileEntity((ItemStack)machine);
            if (this.mte == null) {
                this.activeRecipeMap = null;
            } else {
                this.activeRecipeMap = this.mte.getRecipeMap();
                MetaTileEntityHolder holder = new MetaTileEntityHolder();
                this.mte = holder.setMetaTileEntity(this.mte);
                holder.func_145834_a(this.metaTileEntity.getWorld());
                MetaTileEntity metaTileEntity = this.mte;
                if (metaTileEntity instanceof ICleanroomReceiver) {
                    ICleanroomReceiver receiver = (ICleanroomReceiver)metaTileEntity;
                    if (ConfigHolder.machines.cleanMultiblocks) {
                        receiver.setCleanroom(DUMMY_CLEANROOM);
                    } else {
                        ICleanroomProvider provider = controller.getCleanroom();
                        if (provider != null) {
                            receiver.setCleanroom(provider);
                        }
                    }
                }
            }
            this.machineTier = this.mte instanceof ITieredMetaTileEntity ? ((ITieredMetaTileEntity)this.mte).getTier() : 0;
            this.machineVoltage = GTValues.V[this.machineTier];
            this.currentMachineStack = machine;
        }

        public boolean checkRecipe(@NotNull Recipe recipe) {
            if (this.mte == null) {
                return false;
            }
            AbstractRecipeLogic arl = this.mte.getRecipeLogic();
            if (arl == null) {
                return false;
            }
            return arl.checkRecipe(recipe) && super.checkRecipe(recipe);
        }

        protected int getOverclockForTier(long voltage) {
            return super.getOverclockForTier(Math.min(this.machineVoltage, this.getMaximumOverclockVoltage()));
        }

        public int getParallelLimit() {
            return this.currentMachineStack == null || this.currentMachineStack.func_190926_b() ? MetaTileEntityExtendedProcessingArray.this.getMachineLimit() * MetaTileEntityExtendedProcessingArray.this.getParallelFactor() : Math.min(this.currentMachineStack.func_190916_E() * MetaTileEntityExtendedProcessingArray.this.getParallelFactor(), MetaTileEntityExtendedProcessingArray.this.getMachineLimit() * MetaTileEntityExtendedProcessingArray.this.getParallelFactor());
        }

        protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
            return super.findRecipe(Math.min(super.getMaxVoltage(), this.machineVoltage), inputs, fluidInputs);
        }

        public long getMaxVoltage() {
            return super.getMaximumOverclockVoltage();
        }

        protected int getNumberOfOCs(int recipeEUt) {
            if (!this.isAllowOverclocking()) {
                return 0;
            }
            int recipeTier = Math.max(0, GTUtility.getTierByVoltage((long)(recipeEUt / Math.max(1, this.parallelRecipesPerformed))));
            int maximumTier = Math.min(this.machineTier, GTUtility.getTierByVoltage((long)this.getMaxVoltage()));
            int numberOfOCs = maximumTier - recipeTier;
            if (recipeTier == 0) {
                --numberOfOCs;
            }
            return numberOfOCs;
        }

        private ItemStack getMachineStack() {
            return this.currentMachineStack;
        }
    }
}

