package kono.ceu.gtconsolidate.loader.handlers;

import static gregtech.api.GTValues.*;
import static gregtech.api.unification.ore.OrePrefix.*;
import static kono.ceu.gtconsolidate.api.recipes.GTConsolidateRecipeMaps.COA_RECIPES;
import static kono.ceu.gtconsolidate.loader.Components.*;

import net.minecraft.item.ItemStack;

import gregtech.api.GTValues;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.items.MetaItems;

import kono.ceu.gtconsolidate.api.recipes.builder.CoARecipeBuilder;

public class CoALoaders {

    public static void register() {
        // Motors
        registerMotor(Materials.Tin, false, Materials.Iron, Materials.IronMagnetic, Materials.Copper, false, LV);
        registerMotor(Materials.Tin, false, Materials.Steel, Materials.SteelMagnetic, Materials.Copper, false, LV);
        registerMotor(Materials.Copper, false, Materials.Aluminium, Materials.SteelMagnetic, Materials.Cupronickel,
                true, MV);
        registerMotor(Materials.Silver, true, Materials.StainlessSteel, Materials.IronMagnetic, Materials.Electrum,
                true, HV);
        registerMotor(Materials.Aluminium, true, Materials.Titanium, Materials.NeodymiumMagnetic, Materials.Kanthal,
                true, EV);
        registerMotor(Materials.Tungsten, true, Materials.TungstenSteel, Materials.NeodymiumMagnetic,
                Materials.Graphene, true, IV);
        registerMotorAL(Materials.SamariumMagnetic, 1, Materials.HSSS, 2, Materials.HSSS, 2, Materials.HSSS, 4,
                Materials.Ruridit, 64, Materials.NiobiumTitanium, LuV);
        registerMotorAL(Materials.SamariumMagnetic, 1, Materials.Osmiridium, 4, Materials.Osmiridium, 4,
                Materials.Osmiridium, 8, Materials.Europium, 64 + 32, Materials.VanadiumGallium, ZPM);
        registerMotorAL(Materials.SamariumMagnetic, 1, Materials.Tritanium, 4, Materials.Tritanium, 4,
                Materials.Tritanium, 8, Materials.Americium, 64 + 64, Materials.YttriumBariumCuprate, UV);
        // Pumps
        registerPump(Materials.Tin, Materials.Bronze, Materials.Tin, Materials.Tin,
                new Material[] { Materials.Rubber, Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, LV);
        registerPump(Materials.Copper, Materials.Steel, Materials.Bronze, Materials.Bronze,
                new Material[] { Materials.Rubber, Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, MV);
        registerPump(Materials.Gold, Materials.StainlessSteel, Materials.Steel, Materials.Steel,
                new Material[] { Materials.Rubber, Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, HV);
        registerPump(Materials.Aluminium, Materials.Titanium, Materials.StainlessSteel, Materials.StainlessSteel,
                new Material[] { Materials.Rubber, Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, EV);
        registerPump(Materials.Tungsten, Materials.TungstenSteel, Materials.TungstenSteel, Materials.TungstenSteel,
                new Material[] { Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, IV);
        registerPumpAL(pipeSmallFluid, Materials.NiobiumTitanium, Materials.HSSS, Materials.HSSS, Materials.HSSS,
                Materials.NiobiumTitanium, 4, LuV);
        registerPumpAL(pipeNormalFluid, Materials.Polybenzimidazole, Materials.Osmiridium, Materials.Osmiridium,
                Materials.Osmiridium, Materials.VanadiumGallium, 8, ZPM);
        registerPumpAL(pipeLargeFluid, Materials.Naquadah, Materials.Tritanium, Materials.Tritanium,
                Materials.NaquadahAlloy, Materials.YttriumBariumCuprate, 16, UV);
        // Conveyors
        registerConveyor(Materials.Tin,
                new Material[] { Materials.Rubber, Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, LV);
        registerConveyor(Materials.Tin,
                new Material[] { Materials.Rubber, Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, MV);
        registerConveyor(Materials.Tin,
                new Material[] { Materials.Rubber, Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, HV);
        registerConveyor(Materials.Tin,
                new Material[] { Materials.Rubber, Materials.SiliconeRubber, Materials.StyreneButadieneRubber }, EV);
        registerConveyor(Materials.Tin, new Material[] { Materials.SiliconeRubber, Materials.StyreneButadieneRubber },
                IV);
        registerConveyorAL(Materials.HSSS, Materials.HSSS, Materials.HSSS, Materials.HSSS, Materials.NiobiumTitanium,
                LuV);
        registerConveyorAL(Materials.Osmiridium, Materials.Osmiridium, Materials.Osmiridium, Materials.Osmiridium,
                Materials.VanadiumGallium, ZPM);
        registerConveyorAL(Materials.Tritanium, Materials.Tritanium, Materials.Tritanium, Materials.Tritanium,
                Materials.NiobiumTitanium, UV);
        // Pistons
        registerPiston(Materials.Steel, Materials.Tin, Materials.Steel, Materials.Steel, LV);
        registerPiston(Materials.Aluminium, Materials.Copper, Materials.Aluminium, Materials.Aluminium, MV);
        registerPiston(Materials.StainlessSteel, Materials.Gold, Materials.StainlessSteel, Materials.StainlessSteel,
                HV);
        registerPiston(Materials.Titanium, Materials.Aluminium, Materials.Titanium, Materials.Titanium, EV);
        registerPiston(Materials.TungstenSteel, Materials.Tungsten, Materials.TungstenSteel, Materials.TungstenSteel,
                IV);
        registerPistonAL(Materials.HSSS, Materials.HSSS, Materials.HSSS, Materials.HSSS, Materials.HSSS, Materials.HSSS,
                Materials.NiobiumTitanium, LuV);
        registerPistonAL(Materials.Osmiridium, Materials.Osmiridium, Materials.Osmiridium, Materials.Osmiridium,
                Materials.Osmiridium, Materials.Osmiridium, Materials.VanadiumGallium, ZPM);
        registerPistonAL(Materials.Tritanium, Materials.Tritanium, Materials.Tritanium, Materials.Tritanium,
                Materials.NaquadahAlloy, Materials.NaquadahAlloy, Materials.YttriumBariumCuprate, UV);
        // RobotArms
        registerRobotArm(Materials.Tin, Materials.Steel, LV);
        registerRobotArm(Materials.Copper, Materials.Aluminium, MV);
        registerRobotArm(Materials.Gold, Materials.StainlessSteel, HV);
        registerRobotArm(Materials.Aluminium, Materials.Titanium, EV);
        registerRobotArm(Materials.Tungsten, Materials.TungstenSteel, IV);
        registerRobotArmAL(Materials.HSSS, Materials.HSSS, Materials.HSSS, Materials.NiobiumTitanium, LuV);
        registerRobotArmAL(Materials.Osmiridium, Materials.Osmiridium, Materials.Osmiridium, Materials.VanadiumGallium,
                ZPM);
        registerRobotArmAL(Materials.Tritanium, Materials.Tritanium, Materials.Tritanium,
                Materials.YttriumBariumCuprate, UV);
        // FieldGenerators
        registerFieldGenerator(OreDictUnifier.get(new UnificationEntry(gem, Materials.EnderPearl)), Materials.Steel,
                LV);
        registerFieldGenerator(OreDictUnifier.get(new UnificationEntry(gem, Materials.EnderEye)), Materials.Aluminium,
                MV);
        registerFieldGenerator(MetaItems.QUANTUM_EYE.getStackForm(), Materials.StainlessSteel, HV);
        registerFieldGenerator(OreDictUnifier.get(new UnificationEntry(gem, Materials.NetherStar)), Materials.Titanium,
                EV);
        registerFieldGenerator(MetaItems.QUANTUM_STAR.getStackForm(), Materials.TungstenSteel, IV);
        registerFieldGeneratorAL(Materials.HSSS, Materials.HSSS, MetaItems.QUANTUM_STAR, Materials.NiobiumTitanium,
                LuV);
        registerFieldGeneratorAL(Materials.NaquadahAlloy, Materials.NaquadahAlloy, MetaItems.QUANTUM_STAR,
                Materials.VanadiumGallium, ZPM);
        registerFieldGeneratorAL(Materials.Tritanium, Materials.Tritanium, MetaItems.GRAVI_STAR,
                Materials.YttriumBariumCuprate, UV);
        // Emitters
        registerEmitter(Materials.Brass, Materials.Tin, OreDictUnifier.get(gem, Materials.Quartzite), LV);
        registerEmitter(Materials.Electrum, Materials.Copper, OreDictUnifier.get(gemFlawless, Materials.Emerald), MV);
        registerEmitter(Materials.Chrome, Materials.Gold, OreDictUnifier.get(gem, Materials.EnderEye), HV);
        registerEmitter(Materials.Platinum, Materials.Aluminium, MetaItems.QUANTUM_EYE.getStackForm(), EV);
        registerEmitter(Materials.Iridium, Materials.Tungsten, MetaItems.QUANTUM_STAR.getStackForm(), IV);
        registerEmitterAL(Materials.HSSS, Materials.Ruridit, Materials.Palladium, Materials.NiobiumTitanium,
                MetaItems.QUANTUM_STAR, LuV);
        registerEmitterAL(Materials.NaquadahAlloy, Materials.Osmiridium, Materials.Trinium, Materials.VanadiumGallium,
                MetaItems.QUANTUM_STAR, ZPM);
        registerEmitterAL(Materials.Tritanium, Materials.Tritanium, Materials.Naquadria, Materials.YttriumBariumCuprate,
                MetaItems.GRAVI_STAR, UV);
        // Sensors
        registerSensor(Materials.Brass, Materials.Steel, OreDictUnifier.get(gem, Materials.Quartzite), LV);
        registerSensor(Materials.Electrum, Materials.Aluminium, OreDictUnifier.get(gemFlawless, Materials.Emerald), MV);
        registerSensor(Materials.Chrome, Materials.StainlessSteel, OreDictUnifier.get(gem, Materials.EnderEye), HV);
        registerSensor(Materials.Platinum, Materials.Titanium, MetaItems.QUANTUM_EYE.getStackForm(), EV);
        registerSensor(Materials.Iridium, Materials.TungstenSteel, MetaItems.QUANTUM_STAR.getStackForm(), IV);
        registerSensorAL(Materials.HSSS, Materials.Ruridit, Materials.Palladium, Materials.NiobiumTitanium,
                MetaItems.QUANTUM_STAR, 1, LuV);
        registerSensorAL(Materials.NaquadahAlloy, Materials.Osmiridium, Materials.Trinium, Materials.VanadiumGallium,
                MetaItems.QUANTUM_STAR, 2, ZPM);
        registerSensorAL(Materials.Tritanium, Materials.Tritanium, Materials.Naquadria, Materials.YttriumBariumCuprate,
                MetaItems.GRAVI_STAR, 1, UV);
    }

    /**
     * The recipe is based on GTNH's recipe.
     * Duplicated recipes for multiple inputs (i.e., SBR vs Silicone) should be respected.
     * Multiply all inputs by 48x, but output 64 at a time.
     *
     * Item conversion rules (in case of odd numbers, round down):
     * All wires/cables should convert to 16x sizes (excluding fine wires).
     * All rods should convert to long rods. However, the quantity is x24, not x48.
     * Superconducting wires were added on a whim by the author :)
     */
    public static void registerMotor(Material cableMaterial, boolean isCableDouble, Material stickMaterial,
                                     Material magneticMaterial, Material wireMaterial, boolean isWireDouble,
                                     int tier) {
        int cableAmount = isCableDouble ? 12 : 6;
        int wireAmount = isWireDouble ? 24 : 12;

        COA_RECIPES.recipeBuilder()
                .input(cableGtHex, cableMaterial, cableAmount)
                .input(stickLong, stickMaterial, 48)
                .input(stickLong, magneticMaterial, 24)
                .input(wireGtHex, wireMaterial, wireAmount)
                .input(wireGtSingle, scMaterial(tier), isWireDouble ? 2 * 48 : 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(motor(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800)
                .buildAndRegister();
    }

    // Fine Wire -> 16x Wire (x3/4)
    public static void registerMotorAL(Material magneticMaterial, int amountMagnetic, Material stickMaterial,
                                       int amountStick, Material ringMaterial, int amountRing, Material roundMaterial,
                                       int amountRound, Material fineMaterial, int amountFine, Material cableMaterial,
                                       int tier) {
        CoARecipeBuilder builder = COA_RECIPES.recipeBuilder()
                .input(stickLong, magneticMaterial, amountMagnetic * 48)
                .input(stickLong, stickMaterial, amountStick * 48)
                .input(ring, ringMaterial, amountRing * 48)
                .input(round, roundMaterial, amountRound * 48)
                .input(wireGtHex, fineMaterial, amountFine * 3 / 4)
                .input(cableGtHex, cableMaterial, 6)
                .input(wireGtDouble, scMaterial(tier), 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(motor(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800);

        if (tier == UV) builder.fluidInputs(Materials.Naquadria.getFluid(L * 4 * 48));

        builder.buildAndRegister();
    }

    public static void registerConveyor(Material cableMaterial, Material[] rubberMaterials, int tier) {
        for (Material rubber : rubberMaterials) {
            COA_RECIPES.recipeBuilder()
                    .input(cableGtOctal, cableMaterial, 3)
                    .input(motor(tier), 2 * 48)
                    .input(wireGtSingle, scMaterial(tier), 48)
                    .fluidInputs(rubber.getFluid(L * 6 * 48))
                    .fluidInputs(Materials.SolderingAlloy.getFluid(L * tier))
                    .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                    .output(conveyor(tier), 64)
                    .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800)
                    .buildAndRegister();
        }
    }

    public static void registerConveyorAL(Material plateMaterial, Material ringMaterial, Material roundMaterial,
                                          Material screwMaterial, Material cableMaterial, int tier) {
        CoARecipeBuilder builder = COA_RECIPES.recipeBuilder()
                .input(motor(tier), 2 * 48)
                .input(plate, plateMaterial, 2 * 48)
                .input(ring, ringMaterial, 4 * 48)
                .input(round, roundMaterial, 16 * 48)
                .input(screw, screwMaterial, 4 * 48)
                .input(cableGtHex, cableMaterial, 6)
                .input(wireGtDouble, scMaterial(tier), 48)
                .fluidInputs(Materials.StyreneButadieneRubber.getFluid(L * 8 * (tier - 6) * 48))
                .fluidInputs(Materials.SolderingAlloy.getFluid(L * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(conveyor(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800);

        if (tier == UV) builder.fluidInputs(Materials.Naquadria.getFluid(L * 4 * 48));

        builder.buildAndRegister();
    }

    public static void registerPump(Material cableMaterial, Material pipeMaterial, Material screwMaterial,
                                    Material rotorMaterial, Material[] rubberMaterials, int tier) {
        for (Material rubber : rubberMaterials) {
            COA_RECIPES.recipeBuilder()
                    .input(motor(tier), 48)
                    .input(cableGtHex, cableMaterial, 3)
                    .input(pipeNormalFluid, pipeMaterial, 48)
                    .input(screw, screwMaterial, 48)
                    .input(rotor, rotorMaterial, 48)
                    .input(ring, rubber, 2 * 48)
                    .input(wireGtSingle, scMaterial(tier), 48)
                    .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                    .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                    .output(pump(tier), 64)
                    .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800)
                    .buildAndRegister();
        }
    }

    public static void registerPumpAL(OrePrefix pipePreFix, Material pipeMaterial, Material plateMaterial,
                                      Material screwMaterial, Material rotorMaterial, Material cableMaterial,
                                      int ringAmount, int tier) {
        CoARecipeBuilder builder = COA_RECIPES.recipeBuilder()
                .input(motor(tier), 48)
                .input(pipePreFix, pipeMaterial, 48)
                .input(plate, plateMaterial, 2 * 48)
                .input(screw, screwMaterial, 8 * 48)
                .input(ring, Materials.SiliconeRubber, ringAmount * 48)
                .input(rotor, rotorMaterial, 48)
                .input(cableGtHex, cableMaterial, 6)
                .input(wireGtSingle, scMaterial(tier), 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(pump(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800);

        if (tier == UV) builder.fluidInputs(Materials.Naquadria.getFluid(L * 4 * 48));

        builder.buildAndRegister();
    }

    public static void registerPiston(Material stickMaterial, Material cableMaterial, Material plateMaterial,
                                      Material gearMaterial, int tier) {
        COA_RECIPES.recipeBuilder()
                .input(stickLong, stickMaterial, 48)
                .input(cableGtHex, cableMaterial, 6)
                .input(plate, plateMaterial, 3 * 48)
                .input(gearSmall, gearMaterial, 48)
                .input(motor(tier), 48)
                .input(wireGtSingle, scMaterial(tier), 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(piston(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800)
                .buildAndRegister();
    }

    public static void registerPistonAL(Material plateMaterial, Material ringMaterial, Material roundMaterial,
                                        Material stickMaterial, Material gearMaterial, Material smallGearMaterial,
                                        Material cableMaterial, int tier) {
        CoARecipeBuilder builder = COA_RECIPES.recipeBuilder()
                .input(motor(tier), 48)
                .input(plate, plateMaterial, 4 * 48)
                .input(ring, ringMaterial, 4 * 48)
                .input(round, roundMaterial, 16 * 48)
                .input(stickLong, stickMaterial, 2 * 48)
                .input(gear, gearMaterial, 48)
                .input(gearSmall, smallGearMaterial, 2 * 48)
                .input(cableGtHex, cableMaterial, 6)
                .input(wireGtDouble, scMaterial(tier), 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(piston(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800);

        if (tier == UV) builder.fluidInputs(Materials.Naquadria.getFluid(L * 4 * 48));

        builder.buildAndRegister();
    }

    public static void registerRobotArm(Material cableMaterial, Material stickMaterial, int tier) {
        COA_RECIPES.recipeBuilder()
                .input(cableGtHex, cableMaterial, 9)
                .input(stickLong, stickMaterial, 48)
                .input(motor(tier), 2 * 48)
                .input(piston(tier), 48)
                .input(circuit, markerMaterial(tier), 48)
                .input(wireGtSingle, scMaterial(tier), 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(robotArm(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800)
                .buildAndRegister();
    }

    public static void registerRobotArmAL(Material stickMaterial, Material gearMaterial, Material smallGearMaterial,
                                          Material cableMaterial, int tier) {
        CoARecipeBuilder builder = COA_RECIPES.recipeBuilder()
                .input(stickLong, stickMaterial, 4 * 48)
                .input(gear, gearMaterial, 48)
                .input(gearSmall, smallGearMaterial, 3 * 48)
                .input(motor(tier), 2 * 48)
                .input(piston(tier), 48)
                .input(circuit, markerMaterial(tier), 48)
                .input(circuit, markerMaterial(tier - 1), 2 * 48)
                .input(circuit, markerMaterial(tier - 2), 4 * 48)
                .input(cableGtHex, cableMaterial, 12)
                .input(wireGtSingle, scMaterial(tier), 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(robotArm(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800);

        if (tier == UV) builder.fluidInputs(Materials.Naquadria.getFluid(L * 4 * 48));

        builder.buildAndRegister();
    }

    public static void registerFieldGenerator(ItemStack coreStack, Material plateMaterial, int tier) {
        COA_RECIPES.recipeBuilder()
                .inputs(GTUtility.copy(48, coreStack))
                .input(tier >= EV ? plateDouble : plate, plateMaterial, 2 * 48)
                .input(circuit, markerMaterial(tier), 2 * 48)
                .input(wireGtHex, scMaterial(tier), 48)
                .input(wireFine, scMaterial(tier), 64)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(fieldGenerator(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800)
                .buildAndRegister();
    }

    public static void registerFieldGeneratorAL(Material frameMaterial, Material plateMaterial,
                                                MetaItem<?>.MetaValueItem coreItem, Material cableMaterial, int tier) {
        CoARecipeBuilder builder = COA_RECIPES.recipeBuilder()
                .input(frameGt, frameMaterial, 48)
                .input(plate, plateMaterial, 6 * 48)
                .input(coreItem, 48)
                .input(emitter(tier), 2 * 48)
                .input(circuit, markerMaterial(tier), 2 * 48)
                .input(wireGtHex, scMaterial(tier), 2 * 48)
                .input(cableGtHex, cableMaterial, 12)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(fieldGenerator(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800);

        if (tier == UV) builder.fluidInputs(Materials.Naquadria.getFluid(L * 4 * 48));

        builder.buildAndRegister();
    }

    public static void registerSensor(Material stickMaterial, Material plateMaterial, ItemStack coreStack, int tier) {
        COA_RECIPES.recipeBuilder()
                .input(stickLong, stickMaterial, 24)
                .input(plate, plateMaterial, 4 * 48)
                .input(circuit, markerMaterial(tier), 48)
                .inputs(GTUtility.copy(48, coreStack))
                .input(wireFine, scMaterial(tier), 2 * 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(sensor(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800)
                .buildAndRegister();
    }

    public static void registerSensorAL(Material frameMaterial, Material plateMaterial, Material foilMaterial,
                                        Material cableMaterial, MetaItem<?>.MetaValueItem coreItem, int coreItemAmount,
                                        int tier) {
        CoARecipeBuilder builder = COA_RECIPES.recipeBuilder()
                .input(frameGt, frameMaterial, 48)
                .input(motor(tier), 48)
                .input(plate, plateMaterial, 4 * 48)
                .input(coreItem, coreItemAmount * 48)
                .input(circuit, markerMaterial(tier), 2 * 48)
                .input(plateDense, foilMaterial, 128)
                .input(cableGtHex, cableMaterial, 12)
                .input(wireFine, scMaterial(tier), 2 * 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(sensor(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800);

        if (tier == UV) builder.fluidInputs(Materials.Naquadria.getFluid(L * 4 * 48));

        builder.buildAndRegister();
    }

    public static void registerEmitter(Material stickMaterial, Material cableMaterial, ItemStack coreStack, int tier) {
        COA_RECIPES.recipeBuilder()
                .input(stickLong, stickMaterial, 2 * 48)
                .input(cableGtHex, cableMaterial, 6)
                .input(circuit, markerMaterial(tier), 2 * 48)
                .inputs(GTUtility.copy(48, coreStack))
                .input(wireFine, scMaterial(tier), 2 * 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(emitter(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800)
                .buildAndRegister();
    }

    public static void registerEmitterAL(Material frameMaterial, Material stickMaterial, Material foilMaterial,
                                         Material cableMaterial, MetaItem<?>.MetaValueItem coreItem, int tier) {
        CoARecipeBuilder builder = COA_RECIPES.recipeBuilder()
                .input(frameGt, frameMaterial, 48)
                .input(motor(tier), 48)
                .input(stickLong, stickMaterial, 4 * 48)
                .input(coreItem, 48)
                .input(circuit, markerMaterial(tier), 2 * 48)
                .input(plateDense, foilMaterial, 128)
                .input(cableGtHex, cableMaterial, 12)
                .input(wireFine, scMaterial(tier), 2 * 48)
                .fluidInputs(Materials.SolderingAlloy.getFluid(144 * tier))
                .fluidInputs(Materials.Lubricant.getFluid(1000 * tier))
                .output(emitter(tier), 64)
                .casingTier(tier).EUt(GTValues.VA[tier + 2]).duration(4800);

        if (tier == UV) builder.fluidInputs(Materials.Naquadria.getFluid(L * 4 * 48));

        builder.buildAndRegister();
    }
}
