/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregicality.multiblocks.api.render.GCYMTextures;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.common.block.blocks.BlockLargeMultiblockCasing;
import gregicality.multiblocks.common.block.blocks.BlockUniqueCasing;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.IHeatingCoil;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.recipes.recipeproperties.TemperatureProperty;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import java.util.ArrayList;
import java.util.List;
import kono.ceu.gtconsolidate.api.recipes.GTConsolidateRecipeMaps;
import kono.ceu.gtconsolidate.api.util.GTConsolidateTraceabilityPredicate;
import kono.ceu.gtconsolidate.common.blocks.BlockCoolantCasing;
import kono.ceu.gtconsolidate.common.blocks.GTConsolidateMetaBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityTurboBlastFurnace
extends GCYMRecipeMapMultiblockController
implements IHeatingCoil {
    private int blastFurnaceTemperature;
    private int baseTemperature;
    private int defaultTemperature;

    public MetaTileEntityTurboBlastFurnace(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, GTConsolidateRecipeMaps.TURBO_BLAST_RECIPE);
        this.recipeMapWorkable = new GigaBlastFurnaceRecipeLogic((RecipeMapMultiblockController)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityTurboBlastFurnace(this.metaTileEntityId);
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString heatString = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.RED, (String)(TextFormattingUtil.formatNumbers((long)this.blastFurnaceTemperature) + "K"));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{heatString}));
            }
        }).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("CoilType");
        if (type instanceof IHeatingCoilBlockStats) {
            IHeatingCoilBlockStats stats = (IHeatingCoilBlockStats)type;
            this.defaultTemperature = stats.getCoilTemperature();
        } else {
            this.defaultTemperature = BlockWireCoil.CoilType.CUPRONICKEL.getCoilTemperature();
        }
        this.baseTemperature = this.defaultTemperature;
        this.defaultTemperature += 100 * Math.max(0, GTUtility.getTierByVoltage((long)this.getEnergyContainer().getInputVoltage()) - 2);
        this.blastFurnaceTemperature = this.defaultTemperature;
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.blastFurnaceTemperature = 0;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        return this.blastFurnaceTemperature >= (Integer)recipe.getProperty((RecipeProperty)TemperatureProperty.getInstance(), (Object)0);
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        ArrayList inputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY));
        this.energyContainer = new EnergyContainerList(inputEnergy);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casing = MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getCasingState()}).setMinGlobalLimited(300);
        return FactoryBlockPattern.start().aisle(new String[]{"##XXXXXXXXX##", "##XXXXXXXXX##", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "##TTTTTTTTT##"}).aisle(new String[]{"#XXXXXXXXXXX#", "#XXXXXXXXXXX#", "###FJJJJJF###", "###FJJJJJF###", "###FFVVVFF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FFVVVFF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FFVVVFF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FFVVVFF###", "###FJJJJJF###", "###FJJJJJF###", "#TTTTTTTTTTT#"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXXXVVVVVXXXX", "##F#######F##", "##F#######F##", "##FFFHPHFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFHPHFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFHPHFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFHPHFFF##", "##F#######F##", "##F#######F##", "TTTTTTTTTTTTT"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXXXXXDXXXXXX", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "#F####P####F#", "#F####P####F#", "TTTTTTPTTTTTT"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXDXXXVXX", "#J##BBPBB##J#", "#J##TITIT##J#", "#FFHJJJJJHFF#", "#G##BITIB##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##BITIB##G#", "#FFHHHHHHHFF#", "#G##BITIB##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##BITIB##G#", "#FFHHHHHHHFF#", "#G##BITIB##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##BITIB##G#", "#FFHJJJJJHFF#", "#J##TITIT##J#", "#J##BBPBB##J#", "TTTTTTPTTTTTT"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXDXXXVXX", "#J##BAAAB##J#", "#J##IAAAI##J#", "#VHHJAAAJHHV#", "#G##IAAAI##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##IAAAI##G#", "#VHHHAAAHHHV#", "#G##IAAAI##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##IAAAI##G#", "#VHHHAAAHHHV#", "#G##IAAAI##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##IAAAI##G#", "#VHHJAAAJHHV#", "#J##IAAAI##J#", "#J##BAAAB##J#", "TTTTTMPMTTTTT"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXVDDDDDDDVXX", "#J#PPADAPP#J#", "#J#PTADATP#J#", "#VPPJADAJPPV#", "#G#PTADATP#G#", "#G#PCADACP#G#", "#G#PCADACP#G#", "#G#PCADACP#G#", "#G#PTADATP#G#", "#VPPHADAHPPV#", "#G#PTADATP#G#", "#G#PCADACP#G#", "#G#PCADACP#G#", "#G#PCADACP#G#", "#G#PTADATP#G#", "#VPPHADAHPPV#", "#G#PTADATP#G#", "#G#PCADACP#G#", "#G#PCADACP#G#", "#G#PCADACP#G#", "#G#PTADATP#G#", "#VPPJADAJPPV#", "#J#PTADATP#J#", "#J#PPADAPP#J#", "TTTPPPMPPPTTT"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXDXXXVXX", "#J##BAAAB##J#", "#J##IAAAI##J#", "#VHHJAAAJHHV#", "#G##IAAAI##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##IAAAI##G#", "#VHHHAAAHHHV#", "#G##IAAAI##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##IAAAI##G#", "#VHHHAAAHHHV#", "#G##IAAAI##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##CAAAC##G#", "#G##IAAAI##G#", "#VHHJAAAJHHV#", "#J##IAAAI##J#", "#J##BAAAB##J#", "TTTTTMPMTTTTT"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXDXXXVXX", "#J##BBPBB##J#", "#J##TITIT##J#", "#FFHJJJJJHFF#", "#G##BITIB##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##BITIB##G#", "#FFHHHHHHHFF#", "#G##BITIB##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##BITIB##G#", "#FFHHHHHHHFF#", "#G##BITIB##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##CCCCC##G#", "#G##BITIB##G#", "#FFHJJJJJHFF#", "#J##TITIT##J#", "#J##BBPBB##J#", "TTTTTTPTTTTTT"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXXXXXDXXXXXX", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "#F####P####F#", "#F####P####F#", "TTTTTTPTTTTTT"}).aisle(new String[]{"XXXXXXXXXXXXX", "XXXXVVVVVXXXX", "##F#######F##", "##F#######F##", "##FFFHPHFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFHPHFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFHPHFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFHPHFFF##", "##F#######F##", "##F#######F##", "TTTTTTTTTTTTT"}).aisle(new String[]{"#XXXXXXXXXXX#", "#XXXXXXXXXXX#", "###FJJJJJF###", "###FJJJJJF###", "###FFVVVFF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FFVVVFF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FFVVVFF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FGGGGGF###", "###FFVVVFF###", "###FJJJJJF###", "###FJJJJJF###", "#TTTTTTTTTTT#"}).aisle(new String[]{"##XXXXXXXXX##", "##XXXXSXXXX##", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "##TTTTTTTTT##"}).where('S', this.selfPredicate()).where('X', casing.or(this.autoAbilities(false, true, true, true, true, true, false)).or(GTConsolidateTraceabilityPredicate.energyHatchLimit(true, true, true, true))).where('F', MetaTileEntityTurboBlastFurnace.frames((Material[])new Material[]{Materials.NaquadahAlloy})).where('H', casing).where('P', MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getPipeState()})).where('B', MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getFireboxState()})).where('I', MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getIntakeState()})).where('T', MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getCasingState2()})).where('V', MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getVentState()})).where('M', MetaTileEntityTurboBlastFurnace.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('C', MetaTileEntityTurboBlastFurnace.heatingCoils()).where('D', MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getFusionCoil()})).where('G', MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getGlassState()})).where('J', MetaTileEntityTurboBlastFurnace.states((IBlockState[])new IBlockState[]{MetaTileEntityTurboBlastFurnace.getCoolantState()})).where('A', MetaTileEntityTurboBlastFurnace.air()).where('#', MetaTileEntityTurboBlastFurnace.any()).build();
    }

    private static IBlockState getCasingState() {
        return GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.HIGH_TEMPERATURE_CASING);
    }

    private static IBlockState getCasingState2() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST);
    }

    private static IBlockState getFireboxState() {
        return MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.TUNGSTENSTEEL_FIREBOX);
    }

    private static IBlockState getIntakeState() {
        return MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.EXTREME_ENGINE_INTAKE_CASING);
    }

    private static IBlockState getPipeState() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.TUNGSTENSTEEL_PIPE);
    }

    private static IBlockState getVentState() {
        return GCYMMetaBlocks.UNIQUE_CASING.getState((Enum)BlockUniqueCasing.UniqueCasingType.HEAT_VENT);
    }

    private static IBlockState getFusionCoil() {
        return MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_COIL);
    }

    private static IBlockState getGlassState() {
        return MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS);
    }

    private static IBlockState getCoolantState() {
        return GTConsolidateMetaBlocks.COOLANT_CASING.getState(BlockCoolantCasing.CasingType.HELIUM_3);
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.turbo_blast_furnace.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.3", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.turbo_blast_furnace.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.turbo_blast_furnace.tooltip.3", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.machine.turbo_blast_furnace.tooltip.4", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtconsolidate.multiblock.accept_64a", (Object[])new Object[0]));
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return iMultiblockPart instanceof IMufflerHatch ? Textures.ROBUST_TUNGSTENSTEEL_CASING : GCYMTextures.BLAST_CASING;
    }

    @NotNull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return GCYMTextures.MEGA_BLAST_FURNACE_OVERLAY;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean isTiered() {
        return false;
    }

    protected void updateFormedValid() {
        super.updateFormedValid();
        int bounce = this.baseTemperature / 100;
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 20L == 0L) {
            if (this.isActive()) {
                long maxTemperature = Integer.MAX_VALUE;
                this.blastFurnaceTemperature = (int)Math.min(maxTemperature, (long)this.blastFurnaceTemperature + (long)bounce);
            } else {
                this.blastFurnaceTemperature = Math.max(this.defaultTemperature, this.blastFurnaceTemperature - bounce * 10);
            }
        }
    }

    public int getCurrentTemperature() {
        return this.blastFurnaceTemperature;
    }

    private class GigaBlastFurnaceRecipeLogic
    extends GCYMMultiblockRecipeLogic {
        public GigaBlastFurnaceRecipeLogic(RecipeMapMultiblockController metaTileEntity) {
            super(metaTileEntity);
        }

        protected int @NotNull [] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int duration, int maxOverclocks) {
            return OverclockingLogic.heatingCoilOverclockingLogic((int)Math.abs(recipeEUt), (long)maxVoltage, (int)duration, (int)maxOverclocks, (int)((IHeatingCoil)this.metaTileEntity).getCurrentTemperature(), (int)((Integer)propertyStorage.getRecipePropertyValue((RecipeProperty)TemperatureProperty.getInstance(), (Object)0)));
        }
    }
}

