/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.MultiblockPart;

import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityItemBus;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityFilteredItemBus
extends MetaTileEntityItemBus {
    @Nullable
    protected GhostCircuitItemStackHandler circuitInventory;
    private IItemHandlerModifiable actualImportItems;
    private FilteredImportHandler filteredImportHandler;

    public MetaTileEntityFilteredItemBus(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier, false);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityFilteredItemBus(this.metaTileEntityId, this.getTier());
    }

    protected void initializeInventory() {
        this.filteredImportHandler = new FilteredImportHandler((MetaTileEntity)this, this.getInventorySize(), (MetaTileEntity)this.getController());
        this.circuitInventory = new GhostCircuitItemStackHandler((MetaTileEntity)this);
        this.actualImportItems = new ItemHandlerList(Arrays.asList(new GTItemStackHandler[]{this.filteredImportHandler, this.circuitInventory}));
        super.initializeInventory();
    }

    public IItemHandlerModifiable getImportItems() {
        return this.actualImportItems;
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        return new FilteredImportHandler((MetaTileEntity)this, this.getInventorySize(), (MetaTileEntity)this.getController());
    }

    private int getInventorySize() {
        int sizeRoot = 1 + Math.min(9, this.getTier());
        return sizeRoot * sizeRoot;
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.format((String)"gregtech.machine.item_bus.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.format((String)"gtconsolidate.machine.filtered_item_bus.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.format((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.format((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    public static class FilteredImportHandler
    extends NotifiableItemStackHandler {
        public FilteredImportHandler(MetaTileEntity metaTileEntity, int slots, MetaTileEntity entityToNotify) {
            super(metaTileEntity, slots, entityToNotify, false);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            int amountInSlot = this.getStackInSlot(slot).getCount();
            int slotLimit = Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
            int spaceAvailable = slotLimit - amountInSlot;
            int amountToInsert = Math.min(spaceAvailable, stack.getCount());
            if (amountToInsert <= 0) {
                return stack;
            }
            ItemStack existingStack = this.getStackInSlot(slot);
            if (!existingStack.isEmpty()) {
                if (!ItemStackHashStrategy.comparingAllButCount().equals((Object)stack, (Object)existingStack)) {
                    return stack;
                }
            } else {
                for (int i = 0; i < this.getSlots(); ++i) {
                    ItemStack otherStack = this.getStackInSlot(i);
                    if (otherStack.isEmpty() || ItemStackHashStrategy.comparingAllButCount().equals((Object)stack, (Object)otherStack)) continue;
                    return stack;
                }
            }
            int remainderAmount = stack.getCount() - amountToInsert;
            ItemStack remainder = ItemStack.EMPTY;
            if (remainderAmount > 0) {
                remainder = stack.copy();
                remainder.setCount(remainderAmount);
            }
            if (!simulate) {
                ItemStack temp = stack.copy();
                temp.setCount(amountInSlot + amountToInsert);
                this.setStackInSlot(slot, temp);
            }
            return remainder;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.getStackInSlot(slot).isEmpty() || ItemStackHashStrategy.comparingAllButCount().equals((Object)this.getStackInSlot(slot), (Object)stack);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }
    }
}

