/*
 * Decompiled with CFR 0.152.
 */
package kono.ceu.gtconsolidate.common.metatileentities.multi.electric;

import gregicality.multiblocks.api.capability.IParallelMultiblock;
import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import kono.ceu.gtconsolidate.api.util.GTConsolidateTraceabilityPredicate;
import kono.ceu.gtconsolidate.api.util.GTConsolidateValues;
import kono.ceu.gtconsolidate.common.blocks.BlockCoolantCasing;
import kono.ceu.gtconsolidate.common.blocks.GTConsolidateMetaBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityParallelizedVF
extends RecipeMapMultiblockController
implements IParallelMultiblock {
    private final int maxParallel;

    public MetaTileEntityParallelizedVF(ResourceLocation metaTileEntityId, int maxParallel) {
        super(metaTileEntityId, RecipeMaps.VACUUM_RECIPES);
        this.maxParallel = maxParallel;
        this.recipeMapWorkable = new GCYMMultiblockRecipeLogic((RecipeMapMultiblockController)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityParallelizedVF(this.metaTileEntityId, this.maxParallel);
    }

    public boolean isParallel() {
        return true;
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXX", "XXX", "XXX"}).aisle(new String[]{"XXX", "X#X", "XXX"}).aisle(new String[]{"XXX", "XSX", "XXX"}).where('S', this.selfPredicate()).where('X', MetaTileEntityParallelizedVF.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(14).or(this.autoAbilities(false, false, true, true, true, true, false)).or(GTConsolidateTraceabilityPredicate.manualMaintenance()).or(GTConsolidateTraceabilityPredicate.energyHatchLimit(false, this.maxParallel == 4, true).setMinGlobalLimited(1).setMaxGlobalLimited(2))).where('#', this.modePredicate()).build();
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.FROST_PROOF_CASING;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.ALUMINIUM_FROSTPROOF);
    }

    public TraceabilityPredicate modePredicate() {
        TraceabilityPredicate traceabilityPredicate;
        IBlockState heliumBasic = GTConsolidateMetaBlocks.COOLANT_CASING.getState(BlockCoolantCasing.CasingType.HELIUM_BASIC);
        IBlockState heliumAdvanced = GTConsolidateMetaBlocks.COOLANT_CASING.getState(BlockCoolantCasing.CasingType.HELIUM_ADVANCED);
        IBlockState heliumElite = GTConsolidateMetaBlocks.COOLANT_CASING.getState(BlockCoolantCasing.CasingType.HELIUM_ELITE);
        switch (GTConsolidateValues.mode()) {
            case "NORMAL": {
                if (this.maxParallel == 4) {
                    traceabilityPredicate = MetaTileEntityParallelizedVF.states((IBlockState[])new IBlockState[]{heliumBasic});
                    break;
                }
                traceabilityPredicate = MetaTileEntityParallelizedVF.states((IBlockState[])new IBlockState[]{heliumAdvanced});
                break;
            }
            case "HARD": {
                if (this.maxParallel == 4) {
                    traceabilityPredicate = MetaTileEntityParallelizedVF.states((IBlockState[])new IBlockState[]{heliumAdvanced});
                    break;
                }
                traceabilityPredicate = MetaTileEntityParallelizedVF.states((IBlockState[])new IBlockState[]{heliumElite});
                break;
            }
            default: {
                traceabilityPredicate = this.maxParallel == 4 ? MetaTileEntityParallelizedVF.air() : MetaTileEntityParallelizedVF.states((IBlockState[])new IBlockState[]{heliumBasic});
            }
        }
        TraceabilityPredicate predicate = traceabilityPredicate;
        return predicate;
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.VACUUM_FREEZER_OVERLAY;
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.format((String)"gtconsolidate.machine.parallelized_vf.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.format((String)"gregtech.universal.tooltip.parallel", (Object[])new Object[]{this.maxParallel}));
        tooltip.add(I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{this.maxParallel == 4 ? I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit.energy_in.4and16", (Object[])new Object[0]) : I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit.energy_in.16", (Object[])new Object[0])}));
        tooltip.add(I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit", (Object[])new Object[]{I18n.format((String)"gtconsolidate.multiblock.tooltip.universal.limit.manual_maintenance", (Object[])new Object[0])}));
    }
}

